/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.gef.examples.logicdesigner.model.LogicElement;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;

public class Wire
extends LogicElement {
    static final long serialVersionUID = 1L;
    protected boolean value;
    protected LogicSubpart source;
    protected LogicSubpart target;
    protected String sourceTerminal;
    protected String targetTerminal;
    protected List bendpoints = new ArrayList();

    public void attachSource() {
        if (this.getSource() == null || this.getSource().getSourceConnections().contains(this)) {
            return;
        }
        this.getSource().connectOutput(this);
    }

    public void attachTarget() {
        if (this.getTarget() == null || this.getTarget().getTargetConnections().contains(this)) {
            return;
        }
        this.getTarget().connectInput(this);
    }

    public void detachSource() {
        if (this.getSource() == null) {
            return;
        }
        this.getSource().disconnectOutput(this);
    }

    public void detachTarget() {
        if (this.getTarget() == null) {
            return;
        }
        this.getTarget().disconnectInput(this);
    }

    public List getBendpoints() {
        return this.bendpoints;
    }

    public LogicSubpart getSource() {
        return this.source;
    }

    public String getSourceTerminal() {
        return this.sourceTerminal;
    }

    public LogicSubpart getTarget() {
        return this.target;
    }

    public String getTargetTerminal() {
        return this.targetTerminal;
    }

    public boolean getValue() {
        return this.value;
    }

    public void insertBendpoint(int index, Bendpoint point) {
        this.getBendpoints().add(index, point);
        this.firePropertyChange("bendpoint", null, null);
    }

    public void removeBendpoint(int index) {
        this.getBendpoints().remove(index);
        this.firePropertyChange("bendpoint", null, null);
    }

    public void setBendpoint(int index, Bendpoint point) {
        this.getBendpoints().set(index, point);
        this.firePropertyChange("bendpoint", null, null);
    }

    public void setBendpoints(Vector points) {
        this.bendpoints = points;
        this.firePropertyChange("bendpoint", null, null);
    }

    public void setSource(LogicSubpart e) {
        LogicSubpart old = this.source;
        this.source = e;
        this.firePropertyChange("source", old, this.source);
    }

    public void setSourceTerminal(String s) {
        String old = this.sourceTerminal;
        this.sourceTerminal = s;
        this.firePropertyChange("sourceTerminal", old, this.sourceTerminal);
    }

    public void setTarget(LogicSubpart e) {
        LogicSubpart old = this.target;
        this.target = e;
        this.firePropertyChange("target", old, this.target);
    }

    public void setTargetTerminal(String s) {
        String old = this.targetTerminal;
        this.targetTerminal = s;
        this.firePropertyChange("targetTerminal", old, this.targetTerminal);
    }

    public void setValue(boolean value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        if (this.target != null) {
            this.target.update();
        }
        this.firePropertyChange("value", null, null);
    }

    public String toString() {
        return "Wire(" + this.getSource() + "," + this.getSourceTerminal() + "->" + this.getTarget() + "," + this.getTargetTerminal() + ")";
    }
}

