/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance.ast.locator;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.core.tests.performance.Util;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.osgi.framework.Bundle;

public class PhpElementConciliatorTestWrapper
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IFile testFile;
    protected IProject project;
    protected static final char OFFSET_CHAR = '|';
    private PerformanceMonitor perfMonitor;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/project/locator/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/project/locator/php53"});
    }

    public PhpElementConciliatorTestWrapper() {
        super("");
    }

    public Test suite(Map map) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(map.get("project").toString());
        this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
        TestSuite suite = new TestSuite("Locator Tests");
        PHPVersion phpVersion = (PHPVersion)map.get("phpVersion");
        String[] stringArray = TESTS.get(phpVersion);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String testsDirectory = stringArray[n2];
            testsDirectory = testsDirectory.replaceAll("project", map.get("project").toString());
            String[] stringArray2 = PhpElementConciliatorTestWrapper.getPDTTFiles((String)testsDirectory, (Bundle)PHPCorePerformanceTests.getDefault().getBundle());
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                final String fileName = stringArray2[n4];
                try {
                    final PdttFile pdttFile = new PdttFile(PHPCorePerformanceTests.getDefault().getBundle(), fileName);
                    PhpElementConciliatorTest test = new PhpElementConciliatorTest(fileName){

                        protected void tearDown() throws Exception {
                            if (PhpElementConciliatorTestWrapper.this.testFile != null) {
                                PhpElementConciliatorTestWrapper.this.testFile.delete(true, null);
                                PhpElementConciliatorTestWrapper.this.testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            PhpElementConciliatorTestWrapper.this.executeLocator(pdttFile.getFile(), fileName);
                        }
                    };
                    suite.addTest((Test)test);
                }
                catch (Exception e) {
                    suite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n4;
            }
            ++n2;
        }
        return suite;
    }

    protected void executeLocator(String data, String fileName) throws Exception {
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        offset = data.lastIndexOf(124);
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        this.testFile = this.project.getFile("pdttest/test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(1, null);
        this.project.build(10, null);
        PHPCoreTests.waitForIndexer();
        final Program astRoot = Util.createProgramFromSource(this.testFile);
        PhpElementConciliatorTestWrapper.assertNotNull((Object)astRoot);
        final int finalOffset = offset;
        this.perfMonitor.execute("PerformanceTests.testPhpElementConciliator_" + fileName, new PerformanceMonitor.Operation(){

            public void run() throws Exception {
                NodeFinder.perform((ASTNode)astRoot, (int)finalOffset, (int)0);
            }
        }, 1, 10);
    }

    public class PhpElementConciliatorTest
    extends AbstractPDTTTest {
        public PhpElementConciliatorTest(String description) {
            super(description);
        }
    }
}

