/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.PhpSourceParser;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.PhpFormatter;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;

public class PHPAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.text != null && c.text.length() > 1 && c.text.trim().length() > 1 && PHPAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            try {
                this.smartPaste(d, c);
            }
            catch (Exception e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return PHPUiPlugin.getDefault().getPreferenceStore();
    }

    protected void smartPaste(IDocument document, DocumentCommand command) {
        int i;
        String newline;
        StringBuffer helpBuffer;
        block30: {
            block28: {
                if (command.offset == -1 || document.getLength() == 0) {
                    return;
                }
                helpBuffer = new StringBuffer();
                try {
                    if (!(document instanceof IStructuredDocument)) break block28;
                    DefaultIndentationStrategy.placeMatchingBlanksForStructuredDocument((IStructuredDocument)((IStructuredDocument)document), (StringBuffer)helpBuffer, (int)document.getLineOfOffset(command.offset), (int)command.offset);
                    IRegion region = document.getLineInformation(document.getLineOfOffset(command.offset));
                    if (document.get(region.getOffset(), region.getLength()).trim().length() == 0) {
                        if (command.offset != region.getOffset()) {
                            document.replace(region.getOffset(), region.getLength(), "");
                            command.offset = region.getOffset();
                        }
                        break block28;
                    }
                    return;
                }
                catch (BadLocationException e) {
                    PHPUiPlugin.log(e);
                }
            }
            newline = PHPModelUtils.getLineSeparator(null);
            IStructuredModel structuredModel = null;
            try {
                try {
                    IProject project = null;
                    structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                    DOMModelForPHP doModelForPHP = (DOMModelForPHP)structuredModel;
                    project = PHPAutoIndentStrategy.getProject(doModelForPHP);
                    newline = PHPModelUtils.getLineSeparator((IProject)project);
                }
                catch (Exception e) {
                    PHPUiPlugin.log(e);
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        Document tempdocument = new Document(command.text);
        int lines = tempdocument.getNumberOfLines();
        int startingEmptyLines = 0;
        StringBuffer tempsb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < lines) {
                IRegion region = tempdocument.getLineInformation(i2);
                if (tempsb.length() > 0) {
                    tempsb.append(newline);
                }
                String currentLine = tempdocument.get(region.getOffset(), region.getLength());
                if (tempsb.length() == 0) {
                    if (currentLine.trim().length() == 0) {
                        ++startingEmptyLines;
                    } else {
                        tempsb.append(currentLine.trim());
                    }
                } else {
                    tempsb.append(tempdocument.get(region.getOffset(), region.getLength()));
                }
                ++i2;
            }
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
        JobSafeStructuredDocument newdocument = new JobSafeStructuredDocument((RegionParser)new PhpSourceParser());
        String start = "<?php";
        newdocument.set(String.valueOf(start) + newline + tempsb.toString());
        PhpFormatter formatter = new PhpFormatter(0, newdocument.getLength(), true);
        formatter.format(newdocument.getFirstStructuredDocumentRegion());
        ArrayList<String> list = new ArrayList<String>();
        try {
            int lineNumber = newdocument.getNumberOfLines();
            i = 0;
            while (i < lineNumber) {
                if (i != 0) {
                    IRegion region = newdocument.getLineInformation(i);
                    String line = newdocument.get(region.getOffset(), region.getLength());
                    list.add(line);
                }
                ++i;
            }
        }
        catch (BadLocationException badLocationException) {}
        StringBuffer sb = new StringBuffer();
        i = 0;
        while (i < startingEmptyLines) {
            sb.append(newline);
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            if (!formatter.getIgnoreLines().contains(i + 1)) {
                sb.append(helpBuffer.toString());
            }
            sb.append((String)list.get(i));
            if (i != list.size() - 1) {
                sb.append(newline);
            }
            ++i;
        }
        command.text = sb.toString();
    }

    private static final IProject getProject(DOMModelForPHP doModelForPHP) {
        IFile file;
        String id = doModelForPHP.getId();
        if (id != null && (file = PHPAutoIndentStrategy.getFile(id)) != null) {
            return file.getProject();
        }
        return null;
    }

    private static IFile getFile(String id) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(id));
    }
}

