/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitStatement;
import org.eclipse.php.internal.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;

public class ClassHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new ClassApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setDefaultTextColor(0, 80, 50);
    }

    public String getDisplayName() {
        return "Classes";
    }

    protected class ClassApply
    extends AbstractSemanticApply {
        protected ClassApply() {
        }

        public boolean visit(ClassDeclaration clazz) {
            ClassHighlighting.this.highlight((ASTNode)clazz.getName());
            Expression superClass = clazz.getSuperClass();
            if (superClass instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)superClass);
            } else if (superClass != null) {
                ClassHighlighting.this.highlight((ASTNode)superClass);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation clazz) {
            Expression name = clazz.getClassName().getName();
            if (name instanceof Identifier) {
                ClassHighlighting.this.highlight((ASTNode)name);
            } else if (name instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)name);
            }
            return true;
        }

        public boolean visit(FormalParameter param) {
            Expression type = param.getParameterType();
            if (type instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)type);
            } else if (type instanceof Identifier) {
                ClassHighlighting.this.highlight((ASTNode)type);
            }
            return true;
        }

        public boolean visit(TraitUseStatement node) {
            List traitList = node.getTraitList();
            for (NamespaceName namespaceName : traitList) {
                this.highlightNamespaceType(namespaceName);
            }
            List tsList = node.getTsList();
            for (TraitStatement traitStatement : tsList) {
                FullyQualifiedTraitMethodReference reference;
                TraitAliasStatement statement;
                if (traitStatement instanceof TraitAliasStatement) {
                    statement = (TraitAliasStatement)traitStatement;
                    if (!(statement.getAlias().getTraitMethod() instanceof FullyQualifiedTraitMethodReference)) continue;
                    reference = (FullyQualifiedTraitMethodReference)statement.getAlias().getTraitMethod();
                    this.highlightNamespaceType(reference.getClassName());
                    continue;
                }
                if (!(traitStatement instanceof TraitPrecedenceStatement)) continue;
                statement = (TraitPrecedenceStatement)traitStatement;
                reference = statement.getPrecedence().getMethodReference();
                this.highlightNamespaceType(reference.getClassName());
                traitList = statement.getPrecedence().getTrList();
                for (NamespaceName namespaceName : traitList) {
                    this.highlightNamespaceType(namespaceName);
                }
            }
            return false;
        }

        private void highlightNamespaceType(NamespaceName name) {
            List segments = name.segments();
            Identifier segment = (Identifier)segments.get(segments.size() - 1);
            ClassHighlighting.this.highlight((ASTNode)segment);
        }
    }
}

