/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.php.core.compiler.PHPSourceElementRequestorExtension;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.internal.core.compiler.ast.nodes.CatchClause;
import org.eclipse.php.internal.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ConstantDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.compiler.ast.nodes.ForEachStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.LambdaFunctionDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ListVariable;
import org.eclipse.php.internal.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReferenceExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.MagicMemberUtil;

public class PHPSourceElementRequestor
extends SourceElementRequestVisitor {
    private static final String MAGIC_PROPERTY_TYPE = "MagicPropertyType";
    private static final String CONSTRUCTOR_NAME = "__construct";
    private static final String VOID_RETURN_TYPE = "void";
    private static final Pattern WHITESPACE_SEPERATOR = Pattern.compile("\\s+");
    private static final String GLOBAL_NAMESPACE_CONTAINER_NAME = "global namespace";
    private static final String DEFAULT_VALUE = " ";
    protected Stack<Declaration> declarations = new Stack();
    private PHPSourceElementRequestorExtension[] extensions;
    protected List<ASTNode> deferredDeclarations = new LinkedList<ASTNode>();
    protected Stack<Set<String>> methodGlobalVars = new Stack();
    protected NamespaceDeclaration fLastNamespace;
    protected Map<String, UsePart> fLastUseParts = new HashMap<String, UsePart>();

    public PHPSourceElementRequestor(ISourceElementRequestor requestor, IModuleSource sourceModule) {
        super((IElementRequestor)requestor);
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", "phpSourceElementRequestors");
        ArrayList<PHPSourceElementRequestorExtension> requestors = new ArrayList<PHPSourceElementRequestorExtension>(elements.length);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                PHPSourceElementRequestorExtension extension = (PHPSourceElementRequestorExtension)((Object)element.createExecutableExtension("class"));
                extension.setRequestor(this.fRequestor);
                extension.setSourceModule(sourceModule);
                requestors.add(extension);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
            ++n2;
        }
        this.extensions = requestors.toArray(new PHPSourceElementRequestorExtension[requestors.size()]);
    }

    protected IElementRequestor getRequestor() {
        return this.fRequestor;
    }

    public MethodDeclaration getCurrentMethod() {
        Declaration currDecleration = this.declarations.peek();
        if (currDecleration instanceof MethodDeclaration) {
            return (MethodDeclaration)currDecleration;
        }
        return null;
    }

    public boolean endvisit(LambdaFunctionDeclaration lambdaMethod) throws Exception {
        this.methodGlobalVars.pop();
        this.fInMethod = false;
        if (!this.fNodes.isEmpty() && this.fNodes.peek() == lambdaMethod) {
            this.fRequestor.exitMethod(lambdaMethod.sourceEnd() - 1);
            this.fNodes.pop();
        }
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(lambdaMethod);
            ++n2;
        }
        return true;
    }

    public boolean endvisit(MethodDeclaration method) throws Exception {
        this.methodGlobalVars.pop();
        this.declarations.pop();
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(method);
            ++n2;
        }
        return super.endvisit(method);
    }

    public boolean endvisit(TypeDeclaration type) throws Exception {
        if (type instanceof NamespaceDeclaration) {
            NamespaceDeclaration namespaceDecl = (NamespaceDeclaration)type;
            this.fLastNamespace = null;
            if (namespaceDecl.isGlobal()) {
                return true;
            }
        }
        this.declarations.pop();
        this.resolveMagicMembers(type);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(type);
            ++n2;
        }
        return super.endvisit(type);
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(LambdaFunctionDeclaration lambdaMethod) throws Exception {
        void var6_9;
        this.fNodes.push(lambdaMethod);
        this.methodGlobalVars.add(new HashSet());
        Collection<FormalParameter> arguments = lambdaMethod.getArguments();
        StringBuilder metadata = new StringBuilder();
        String[] parameters = new String[arguments.size()];
        if (arguments != null) {
            Iterator<FormalParameter> i = arguments.iterator();
            boolean bl = false;
            while (i.hasNext()) {
                void var6_7;
                Argument arg = i.next();
                metadata.append(arg.getName());
                parameters[var6_7] = arg.getName();
                ++var6_7;
                if (!i.hasNext()) continue;
                metadata.append(",");
            }
        }
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        boolean bl = false;
        while (var6_9 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[var6_9];
            visitor.visit(lambdaMethod);
            ++var6_9;
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.parameterNames = parameters;
        mi.name = "__anonymous";
        mi.modifiers = 64;
        if (lambdaMethod.isStatic()) {
            mi.modifiers |= 0x80;
        }
        mi.nameSourceStart = lambdaMethod.sourceStart();
        mi.nameSourceEnd = lambdaMethod.sourceEnd();
        mi.declarationStart = mi.nameSourceStart;
        mi.isConstructor = false;
        this.fRequestor.enterMethod(mi);
        this.fInMethod = true;
        for (Argument argument : arguments) {
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.name = argument.getName();
            info.modifiers = 64;
            info.nameSourceStart = argument.getNameStart();
            info.nameSourceEnd = argument.getNameEnd() - 1;
            info.declarationStart = argument.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(argument.sourceEnd() - 1);
        }
        return true;
    }

    public boolean visit(MethodDeclaration method) throws Exception {
        this.methodGlobalVars.add(new HashSet());
        Declaration parentDeclaration = null;
        if (!this.declarations.empty()) {
            parentDeclaration = this.declarations.peek();
        }
        if (parentDeclaration instanceof MethodDeclaration) {
            this.deferredDeclarations.add((ASTNode)method);
            return false;
        }
        if (parentDeclaration instanceof InterfaceDeclaration) {
            method.setModifier(1);
        }
        this.declarations.push((Declaration)method);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(method);
            ++n2;
        }
        boolean visit = this.visitMethodDeclaration(method);
        if (visit) {
            List arguments = method.getArguments();
            for (Argument arg : arguments) {
                IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                info.name = arg.getName();
                info.modifiers = 64;
                info.nameSourceStart = arg.getNameStart();
                info.nameSourceEnd = arg.getNameEnd() - 1;
                info.declarationStart = arg.sourceStart();
                this.fRequestor.enterField(info);
                this.fRequestor.exitField(arg.sourceEnd() - 1);
            }
        }
        return visit;
    }

    private boolean visitMethodDeclaration(MethodDeclaration method) throws Exception {
        this.fNodes.push(method);
        List args = method.getArguments();
        String[] parameter = new String[args.size()];
        String[] initializers = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            parameter[a] = arg.getName();
            if (arg.getInitialization() != null) {
                if (arg.getInitialization() instanceof Literal) {
                    Literal scalar = (Literal)arg.getInitialization();
                    initializers[a] = scalar.getValue();
                } else {
                    initializers[a] = DEFAULT_VALUE;
                }
            }
            ++a;
        }
        IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
        mi.parameterNames = parameter;
        mi.name = method.getName();
        mi.modifiers = method.getModifiers();
        mi.nameSourceStart = method.getNameStart();
        mi.nameSourceEnd = method.getNameEnd() - 1;
        mi.declarationStart = method.sourceStart();
        mi.parameterInitializers = initializers;
        this.modifyMethodInfo(method, mi);
        this.fRequestor.enterMethod(mi);
        this.fInMethod = true;
        this.fCurrentMethod = method;
        return true;
    }

    protected void modifyMethodInfo(MethodDeclaration methodDeclaration, IElementRequestor.MethodInfo mi) {
        Declaration parentDeclaration = null;
        this.declarations.pop();
        if (!this.declarations.empty()) {
            parentDeclaration = this.declarations.peek();
        }
        this.declarations.push((Declaration)methodDeclaration);
        boolean bl = mi.isConstructor = mi.name.equalsIgnoreCase(CONSTRUCTOR_NAME) || parentDeclaration instanceof ClassDeclaration && mi.name.equalsIgnoreCase(((ClassDeclaration)parentDeclaration).getName());
        if (this.fCurrentClass == null || this.fCurrentClass == this.fLastNamespace) {
            mi.modifiers |= 0x2000;
        }
        mi.parameterTypes = this.processParamterTypes(methodDeclaration);
        mi.returnType = this.processReturnType(methodDeclaration);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension extension = pHPSourceElementRequestorExtensionArray[n2];
            extension.modifyMethodInfo(methodDeclaration, mi);
            ++n2;
        }
    }

    private String[] processParamterTypes(MethodDeclaration methodDeclaration) {
        List args = methodDeclaration.getArguments();
        PHPDocBlock docBlock = ((PHPMethodDeclaration)methodDeclaration).getPHPDoc();
        String[] parameterType = new String[args.size()];
        int a = 0;
        while (a < args.size()) {
            Argument arg = (Argument)args.get(a);
            if (arg instanceof FormalParameter) {
                SimpleReference type = ((FormalParameter)arg).getParameterType();
                if (type != null) {
                    parameterType[a] = type.getName();
                } else if (docBlock != null) {
                    PHPDocTag[] pHPDocTagArray = docBlock.getTags(7);
                    int n = pHPDocTagArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PHPDocTag tag = pHPDocTagArray[n2];
                        SimpleReference[] refs = tag.getReferences();
                        if (refs.length == 2 && refs[0].getName().equals(arg.getName())) {
                            parameterType[a] = refs[1].getName();
                        }
                        ++n2;
                    }
                }
            }
            ++a;
        }
        return parameterType;
    }

    private String processReturnType(MethodDeclaration methodDeclaration) {
        PHPDocBlock docBlock = ((PHPMethodDeclaration)methodDeclaration).getPHPDoc();
        String type = VOID_RETURN_TYPE;
        if (docBlock != null) {
            PHPDocTag[] pHPDocTagArray = docBlock.getTags(6);
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                SimpleReference[] simpleReferenceArray = tag.getReferences();
                if (simpleReferenceArray.length != 0) {
                    SimpleReference reference = simpleReferenceArray[0];
                    return PHPModelUtils.extractElementName(reference.getName());
                }
                ++n2;
            }
        }
        return type;
    }

    public boolean visit(TypeDeclaration type) throws Exception {
        if (type instanceof NamespaceDeclaration) {
            NamespaceDeclaration namespaceDecl;
            this.fLastNamespace = namespaceDecl = (NamespaceDeclaration)type;
            this.fLastUseParts.clear();
            if (namespaceDecl.isGlobal()) {
                return true;
            }
        }
        if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
            this.deferredDeclarations.add((ASTNode)type);
            return false;
        }
        this.declarations.push((Declaration)type);
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(type);
            ++n2;
        }
        return super.visit(type);
    }

    protected String[] processSuperClasses(TypeDeclaration type) {
        ASTListNode superClasses = type.getSuperClasses();
        if (superClasses == null) {
            return new String[0];
        }
        List superClassNames = superClasses.getChilds();
        ArrayList<String> result = new ArrayList<String>(superClassNames.size());
        for (Object nameNode : superClassNames) {
            if (nameNode instanceof FullyQualifiedReference) {
                FullyQualifiedReference fullyQualifiedName = (FullyQualifiedReference)((Object)nameNode);
                String name = fullyQualifiedName.getFullyQualifiedName();
                if (fullyQualifiedName.getNamespace() != null) {
                    String namespace = fullyQualifiedName.getNamespace().getName();
                    if (name.charAt(0) == '\\') {
                        name = name.substring(1);
                    } else if (this.fLastUseParts.containsKey(namespace)) {
                        name = this.fLastUseParts.get(namespace).getNamespace().getFullyQualifiedName() + '\\' + fullyQualifiedName.getName();
                    } else if (this.fLastNamespace != null) {
                        name = this.fLastNamespace.getName() + '\\' + name;
                    }
                } else if (this.fLastUseParts.containsKey(name)) {
                    if ((name = this.fLastUseParts.get(name).getNamespace().getFullyQualifiedName()).charAt(0) == '\\') {
                        name = name.substring(1);
                    }
                } else if (this.fLastNamespace != null) {
                    name = this.fLastNamespace.getName() + '\\' + name;
                }
                result.add(name);
                continue;
            }
            if (!(nameNode instanceof SimpleReference)) continue;
            result.add(((SimpleReference)nameNode).getName());
        }
        return result.toArray(new String[result.size()]);
    }

    protected void modifyClassInfo(TypeDeclaration typeDeclaration, IElementRequestor.TypeInfo ti) {
        if (typeDeclaration instanceof NamespaceDeclaration) {
            ti.modifiers |= 0x800;
        }
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension extension = pHPSourceElementRequestorExtensionArray[n2];
            extension.modifyClassInfo(typeDeclaration, ti);
            ++n2;
        }
    }

    private void resolveMagicMembers(TypeDeclaration type) {
        IPHPDocAwareDeclaration declaration;
        PHPDocBlock doc;
        if (type instanceof IPHPDocAwareDeclaration && (doc = (declaration = (IPHPDocAwareDeclaration)type).getPHPDoc()) != null) {
            PHPDocTag[] tags;
            PHPDocTag[] pHPDocTagArray = tags = doc.getTags();
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleReference var;
                String[] split;
                PHPDocTag docTag = pHPDocTagArray[n2];
                int tagKind = docTag.getTagKind();
                if (tagKind == 30 || tagKind == 31 || tagKind == 32) {
                    split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
                    if (split.length < 2) break;
                    IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                    info.modifiers = 0x400040;
                    info.name = split[1];
                    info.type = split[0];
                    var = new SimpleReference(docTag.sourceStart(), docTag.sourceStart() + 9, this.removeParenthesis(split));
                    info.nameSourceStart = var.sourceStart();
                    info.nameSourceEnd = var.sourceEnd();
                    info.declarationStart = info.nameSourceStart;
                    this.fRequestor.enterField(info);
                    this.fRequestor.exitField(info.nameSourceEnd);
                } else if (tagKind == 33) {
                    split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim());
                    if (split.length < 2) break;
                    IElementRequestor.MethodInfo mi = new IElementRequestor.MethodInfo();
                    mi.parameterNames = null;
                    mi.name = this.removeParenthesis(split);
                    var = new SimpleReference(docTag.sourceStart(), docTag.sourceStart() + 6, this.removeParenthesis(split));
                    mi.modifiers = 64;
                    mi.nameSourceStart = var.sourceStart();
                    mi.nameSourceEnd = var.sourceEnd();
                    mi.declarationStart = mi.nameSourceStart;
                    mi.isConstructor = false;
                    mi.returnType = split[0];
                    MagicMemberUtil.MagicMethod magicMethod = MagicMemberUtil.getMagicMethod(docTag.getValue());
                    if (magicMethod != null) {
                        mi.parameterNames = magicMethod.parameterNames;
                        mi.parameterTypes = magicMethod.parameterTypes;
                        mi.parameterInitializers = magicMethod.parameterInitializers;
                    }
                    this.fRequestor.enterMethod(mi);
                    this.fRequestor.exitMethod(mi.nameSourceEnd);
                }
                ++n2;
            }
        }
    }

    private String removeParenthesis(String[] split) {
        String name = split[1];
        return name.endsWith("()") ? name.substring(0, name.length() - 2) : name;
    }

    public boolean visit(FieldDeclaration declaration) throws Exception {
        IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
        info.modifiers = 70;
        info.name = declaration.getName();
        info.nameSourceStart = declaration.getNameStart();
        info.nameSourceEnd = declaration.getNameEnd() - 1;
        info.declarationStart = declaration.sourceStart();
        this.fRequestor.enterField(info);
        this.fRequestor.exitField(declaration.sourceEnd() - 1);
        return true;
    }

    public boolean endvisit(FieldDeclaration declaration) throws Exception {
        return true;
    }

    public boolean visit(PHPFieldDeclaration declaration) throws Exception {
        IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
        info.modifiers = declaration.getModifiers();
        info.name = declaration.getName();
        SimpleReference var = declaration.getRef();
        info.nameSourceEnd = var.sourceEnd() - 1;
        info.nameSourceStart = var.sourceStart();
        info.declarationStart = declaration.getDeclarationStart();
        PHPDocBlock doc = declaration.getPHPDoc();
        if (doc != null) {
            PHPDocTag[] pHPDocTagArray = doc.getTags(12);
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                SimpleReference[] references = tag.getReferences();
                if (references.length > 0) {
                    info.type = PHPModelUtils.extractElementName(references[0].getName());
                }
                ++n2;
            }
        }
        this.fRequestor.enterField(info);
        return true;
    }

    public boolean visit(CatchClause catchClause) throws Exception {
        IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
        info.modifiers = 64;
        VariableReference var = catchClause.getVariable();
        info.name = var.getName();
        info.nameSourceEnd = var.sourceEnd() - 1;
        info.nameSourceStart = var.sourceStart();
        info.declarationStart = catchClause.sourceStart();
        this.fRequestor.enterField(info);
        return true;
    }

    public boolean endvisit(CatchClause catchClause) throws Exception {
        this.fRequestor.exitField(catchClause.sourceEnd() - 1);
        return true;
    }

    public boolean visit(ForEachStatement foreachStatement) throws Exception {
        IElementRequestor.FieldInfo info;
        SimpleReference var;
        if (foreachStatement.getKey() instanceof VariableReference) {
            var = (SimpleReference)foreachStatement.getKey();
            info = new IElementRequestor.FieldInfo();
            info.modifiers = 64;
            info.name = var.getName();
            info.nameSourceEnd = var.sourceEnd() - 1;
            info.nameSourceStart = var.sourceStart();
            info.declarationStart = var.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(var.sourceEnd() - 1);
        }
        if (foreachStatement.getValue() instanceof VariableReference) {
            var = (SimpleReference)foreachStatement.getValue();
            info = new IElementRequestor.FieldInfo();
            info.modifiers = 64;
            info.name = var.getName();
            info.nameSourceEnd = var.sourceEnd() - 1;
            info.nameSourceStart = var.sourceStart();
            info.declarationStart = var.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(var.sourceEnd() - 1);
        }
        return true;
    }

    public boolean endvisit(ForEachStatement foreachStatement) throws Exception {
        return true;
    }

    public boolean endvisit(PHPFieldDeclaration declaration) throws Exception {
        this.fRequestor.exitField(declaration.sourceEnd() - 1);
        return true;
    }

    public boolean visit(CallExpression call) throws Exception {
        FieldDeclaration constantDecl = ASTUtils.getConstantDeclaration(call);
        if (constantDecl != null) {
            if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
                this.deferredDeclarations.add((ASTNode)constantDecl);
                return false;
            }
            this.visit(constantDecl);
        } else {
            int argsCount = 0;
            CallArgumentsList args = call.getArgs();
            if (args != null && args.getChilds() != null) {
                argsCount = args.getChilds().size();
            }
            this.fRequestor.acceptMethodReference(call.getName(), argsCount, call.getCallName().sourceStart(), call.getCallName().sourceEnd());
        }
        return true;
    }

    public boolean visit(Include include) throws Exception {
        if (include.getExpr() instanceof Scalar) {
            Scalar filePath = (Scalar)include.getExpr();
            this.fRequestor.acceptMethodReference("include", 0, filePath.sourceStart(), filePath.sourceEnd());
        }
        return true;
    }

    public boolean visit(ConstantDeclaration declaration) throws Exception {
        IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
        info.modifiers = 70;
        ConstantReference constantName = declaration.getConstantName();
        info.name = ASTUtils.stripQuotes(constantName.getName());
        info.nameSourceEnd = constantName.sourceEnd() - 1;
        info.nameSourceStart = constantName.sourceStart();
        info.declarationStart = declaration.sourceStart();
        this.fRequestor.enterField(info);
        return true;
    }

    public boolean endvisit(ConstantDeclaration declaration) throws Exception {
        this.fRequestor.exitField(declaration.sourceEnd() - 1);
        return true;
    }

    public boolean visit(Assignment assignment) throws Exception {
        Expression left = assignment.getVariable();
        if (left instanceof FieldAccess) {
            Expression field;
            FieldAccess fieldAccess = (FieldAccess)left;
            Expression dispatcher = fieldAccess.getDispatcher();
            if (dispatcher instanceof VariableReference && "$this".equals(((VariableReference)dispatcher).getName()) && (field = fieldAccess.getField()) instanceof SimpleReference) {
                SimpleReference ref = (SimpleReference)field;
                IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
                info.modifiers = 64;
                info.name = String.valueOf('$') + ref.getName();
                info.nameSourceEnd = ref.sourceEnd() - 1;
                info.nameSourceStart = ref.sourceStart();
                info.declarationStart = assignment.sourceStart();
                this.fRequestor.enterField(info);
                this.fNodes.push(assignment);
            }
        } else if (left instanceof VariableReference) {
            Declaration parentDeclaration;
            if (!this.declarations.empty() && ((parentDeclaration = this.declarations.peek()) instanceof MethodDeclaration && this.methodGlobalVars.peek().contains(((VariableReference)left).getName()) || parentDeclaration == this.fLastNamespace)) {
                this.deferredDeclarations.add((ASTNode)assignment);
                return false;
            }
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.modifiers = 64;
            info.name = ((VariableReference)left).getName();
            info.nameSourceEnd = left.sourceEnd() - 1;
            info.nameSourceStart = left.sourceStart();
            info.declarationStart = assignment.sourceStart();
            this.fRequestor.enterField(info);
            this.fNodes.push(assignment);
        }
        return true;
    }

    public boolean endvisit(Assignment assignment) throws Exception {
        if (!this.fNodes.isEmpty() && this.fNodes.peek() == assignment) {
            this.fRequestor.exitField(assignment.sourceEnd() - 1);
            this.fNodes.pop();
        }
        return true;
    }

    public boolean visit(UseStatement declaration) throws Exception {
        Collection<UsePart> parts = declaration.getParts();
        for (UsePart part : parts) {
            String name = null;
            if (part.getAlias() != null) {
                name = part.getAlias().getName();
            } else {
                name = part.getNamespace().getName();
                int index = name.lastIndexOf(92);
                if (index >= 0) {
                    name = name.substring(index + 1);
                }
            }
            IElementRequestor.ImportInfo info = new IElementRequestor.ImportInfo();
            String containerName = this.fLastNamespace == null ? GLOBAL_NAMESPACE_CONTAINER_NAME : this.fLastNamespace.getName();
            info.containerName = containerName;
            info.name = part.getNamespace().getFullyQualifiedName();
            info.sourceStart = part.getNamespace().sourceStart();
            info.sourceEnd = part.getNamespace().sourceEnd();
            this.fRequestor.acceptImport(info);
            this.fLastUseParts.put(name, part);
        }
        return true;
    }

    public boolean visit(ListVariable listVariable) throws Exception {
        Collection<? extends Expression> variables = listVariable.getVariables();
        for (Expression expression : variables) {
            if (!(expression instanceof VariableReference)) continue;
            IElementRequestor.FieldInfo info = new IElementRequestor.FieldInfo();
            info.modifiers = 64;
            info.name = ((VariableReference)expression).getName();
            info.nameSourceEnd = expression.sourceEnd() - 1;
            info.nameSourceStart = expression.sourceStart();
            info.declarationStart = expression.sourceStart();
            this.fRequestor.enterField(info);
            this.fRequestor.exitField(expression.sourceEnd() - 1);
        }
        return true;
    }

    public boolean endvisit(ListVariable listVariable) throws Exception {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visit(GlobalStatement s) throws Exception {
        if (!this.declarations.empty() && this.declarations.peek() instanceof MethodDeclaration) {
            for (Expression expression : s.getVariables()) {
                void var2_3;
                if (expression instanceof ReferenceExpression) {
                    Expression expression2 = ((ReferenceExpression)expression).getVariable();
                }
                if (!(var2_3 instanceof SimpleReference)) continue;
                this.methodGlobalVars.peek().add(((SimpleReference)var2_3).getName());
            }
        }
        return true;
    }

    public boolean visit(TypeReference reference) throws Exception {
        this.fRequestor.acceptTypeReference(reference.getName(), reference.sourceStart());
        return true;
    }

    public boolean visit(Statement node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(node);
            ++n2;
        }
        if (node instanceof PHPFieldDeclaration) {
            return this.visit((PHPFieldDeclaration)node);
        }
        if (node instanceof FieldDeclaration) {
            return this.visit((FieldDeclaration)node);
        }
        if (node instanceof ConstantDeclaration) {
            return this.visit((ConstantDeclaration)node);
        }
        if (node instanceof CatchClause) {
            return this.visit((CatchClause)node);
        }
        if (node instanceof ForEachStatement) {
            return this.visit((ForEachStatement)node);
        }
        if (node instanceof GlobalStatement) {
            return this.visit((GlobalStatement)node);
        }
        if (node instanceof UseStatement) {
            return this.visit((UseStatement)node);
        }
        return true;
    }

    public boolean endvisit(Statement node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(node);
            ++n2;
        }
        if (node instanceof PHPFieldDeclaration) {
            return this.endvisit((PHPFieldDeclaration)node);
        }
        if (node instanceof FieldDeclaration) {
            return this.endvisit((FieldDeclaration)node);
        }
        if (node instanceof ConstantDeclaration) {
            return this.endvisit((ConstantDeclaration)node);
        }
        if (node instanceof CatchClause) {
            return this.endvisit((CatchClause)node);
        }
        if (node instanceof ForEachStatement) {
            return this.endvisit((ForEachStatement)node);
        }
        return true;
    }

    public boolean visit(Expression node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.visit(node);
            ++n2;
        }
        if (node instanceof Assignment) {
            return this.visit((Assignment)node);
        }
        if (node instanceof ListVariable) {
            return this.visit((ListVariable)node);
        }
        if (node instanceof TypeReference) {
            return this.visit((TypeReference)node);
        }
        if (node instanceof Include) {
            return this.visit((Include)node);
        }
        if (node instanceof PHPCallExpression) {
            return this.visit((PHPCallExpression)node);
        }
        if (node instanceof LambdaFunctionDeclaration) {
            return this.visit((LambdaFunctionDeclaration)node);
        }
        return true;
    }

    public boolean endvisit(Expression node) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(node);
            ++n2;
        }
        if (node instanceof Assignment) {
            return this.endvisit((Assignment)node);
        }
        if (node instanceof ListVariable) {
            return this.endvisit((ListVariable)node);
        }
        if (node instanceof LambdaFunctionDeclaration) {
            return this.endvisit((LambdaFunctionDeclaration)node);
        }
        return true;
    }

    public boolean endvisit(ModuleDeclaration declaration) throws Exception {
        PHPSourceElementRequestorExtension[] pHPSourceElementRequestorExtensionArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            PHPSourceElementRequestorExtension visitor = pHPSourceElementRequestorExtensionArray[n2];
            visitor.endvisit(declaration);
            ++n2;
        }
        while (this.deferredDeclarations != null && !this.deferredDeclarations.isEmpty()) {
            ASTNode[] declarations = this.deferredDeclarations.toArray(new ASTNode[this.deferredDeclarations.size()]);
            this.deferredDeclarations.clear();
            ASTNode[] aSTNodeArray = declarations;
            int n3 = declarations.length;
            n = 0;
            while (n < n3) {
                ASTNode deferred = aSTNodeArray[n];
                deferred.traverse((ASTVisitor)this);
                ++n;
            }
        }
        this.fLastUseParts.clear();
        return super.endvisit(declaration);
    }
}

