/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ForEachStatement
extends Statement {
    private final Expression expression;
    private final Expression key;
    private final Expression value;
    private final Statement statement;

    public ForEachStatement(int start, int end, Expression expression, Expression key, Expression value, Statement statement) {
        super(start, end);
        assert (expression != null && value != null && statement != null);
        this.expression = expression;
        this.key = key;
        this.value = value;
        this.statement = statement;
    }

    public ForEachStatement(int start, int end, Expression expression, Expression value, Statement statement) {
        this(start, end, expression, null, value, statement);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            this.expression.traverse(visitor);
            if (this.key != null) {
                this.key.traverse(visitor);
            }
            this.value.traverse(visitor);
            this.statement.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 26;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Expression getKey() {
        return this.key;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Expression getValue() {
        return this.value;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

