/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.AddSourceFolderWizard;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.internal.ui.wizards.buildpath.newsourcepage.ConfigureBuildPathAction;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ConfigurePHPIncludePathAction;
import org.eclipse.php.internal.ui.actions.RemoveFromIncludepathAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateIncludePathActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.php.ui.includepath.menu";
    public static final String GROUP_INCLUDEPATH = "includepathGroup";
    public static final String GROUP_FILTER = "filterGroup";
    public static final String GROUP_CUSTOMIZE = "customizeGroup";
    private Action fNoActionAvailable = new NoActionAvailable();
    private IWorkbenchSite fSite;
    private List fActions;
    private String fGroupName = "group.reorganize";

    public GenerateIncludePathActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateIncludePathActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateIncludePathActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fActions = new ArrayList();
        RemoveFromIncludepathAction remove = new RemoveFromIncludepathAction(site);
        this.fActions.add(remove);
        ConfigurePHPIncludePathAction configure = new ConfigurePHPIncludePathAction(site);
        this.fActions.add(configure);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        for (Action action : this.fActions) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.canOperateOnSelection()) {
            return;
        }
        String menuText = PHPUIMessages.IncludePathActionGroup_label;
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GenerateIncludePathActionGroup.this.fillViewSubMenu(manager);
            }
        });
        subMenu.setRemoveAllWhenShown(true);
        subMenu.add((IAction)new ConfigureBuildPathAction(this.fSite));
        menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
    }

    private void fillViewSubMenu(IMenuManager source) {
        int added = 0;
        int i = 0;
        for (Action action : this.fActions) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (i == 2) {
                source.add((IContributionItem)new Separator(GROUP_INCLUDEPATH));
            } else if (i == 8) {
                source.add((IContributionItem)new Separator(GROUP_FILTER));
            } else if (i == 10) {
                source.add((IContributionItem)new Separator(GROUP_CUSTOMIZE));
            }
            added += this.addAction(source, (IAction)action);
            ++i;
        }
        if (added == 0) {
            source.add((IAction)this.fNoActionAvailable);
        }
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean canOperateOnSelection() {
        ISelection sel = this.fSite.getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            IProject project;
            if (element instanceof IProject && !(project = (IProject)element).isAccessible()) {
                return false;
            }
            if (!(element instanceof IWorkingSet)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.fActions != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            for (Action action : this.fActions) {
                if (!(action instanceof ISelectionChangedListener)) continue;
                provider.removeSelectionChangedListener((ISelectionChangedListener)action);
            }
        }
        this.fActions = null;
        super.dispose();
    }

    public static class CreateLinkedSourceFolderAction
    extends CreateSourceFolderAction {
        public CreateLinkedSourceFolderAction() {
            super(true);
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip);
            this.setImageDescriptor(DLTKPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder);
        }
    }

    public static class CreateLocalSourceFolderAction
    extends CreateSourceFolderAction {
        public CreateLocalSourceFolderAction() {
            super(false);
            this.setText(ActionMessages.OpenNewSourceFolderWizardAction_text2);
            this.setDescription(ActionMessages.OpenNewSourceFolderWizardAction_description);
            this.setToolTipText(ActionMessages.OpenNewSourceFolderWizardAction_tooltip);
            this.setImageDescriptor(DLTKPluginImages.DESC_TOOL_NEWPACKROOT);
            if (DLTKCore.DEBUG) {
                System.err.println("Add help support here...");
            }
        }
    }

    private static abstract class CreateSourceFolderAction
    extends OpenPHPIncludePathWizardAction {
        private AddSourceFolderWizard fAddSourceFolderWizard;
        private IScriptProject fSelectedProject;
        private final boolean fIsLinked;

        public CreateSourceFolderAction(boolean isLinked) {
            this.fIsLinked = isLinked;
        }

        protected INewWizard createWizard() throws CoreException {
            BPListElement newEntrie = new BPListElement(this.fSelectedProject, 3, false);
            BPListElement[] existing = BPListElement.createFromExisting((IScriptProject)this.fSelectedProject);
            boolean isProjectSrcFolder = BPListElement.isProjectSourceFolder((BPListElement[])existing, (IScriptProject)this.fSelectedProject);
            this.fAddSourceFolderWizard = new AddSourceFolderWizard(existing, newEntrie, this.fIsLinked, false, false, isProjectSrcFolder, isProjectSrcFolder);
            return this.fAddSourceFolderWizard;
        }

        public boolean selectionChanged(IStructuredSelection selection) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof IScriptProject) {
                this.fSelectedProject = (IScriptProject)selection.getFirstElement();
                return true;
            }
            return false;
        }

        public List getBPListElements() {
            return this.fAddSourceFolderWizard.getExistingEntries();
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(NewWizardMessages.GenerateBuildPathActionGroup_no_action_available);
        }
    }

    private static abstract class OpenPHPIncludePathWizardAction
    extends AbstractOpenWizardAction
    implements ISelectionChangedListener {
        private OpenPHPIncludePathWizardAction() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.setEnabled(this.selectionChanged((IStructuredSelection)selection));
            } else {
                this.setEnabled(this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY));
            }
        }

        public abstract boolean selectionChanged(IStructuredSelection var1);
    }
}

