/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.documentation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Display;

public class PHPElementLinks {
    public static final String OPEN_LINK_SCHEME = "eclipse-open";
    public static final String PHPDOC_SCHEME = "eclipse-phpdoc";
    private static final char LINK_BRACKET_REPLACEMENT = '\u2603';
    private static final char LINK_SEPARATOR = '\u2602';

    private PHPElementLinks() {
    }

    public static LocationListener createLocationListener(final ILinkHandler handler) {
        return new LocationAdapter(){

            public void changing(LocationEvent event) {
                IModelElement linkTarget;
                URI uri;
                String loc = event.location;
                if ("about:blank".equals(loc)) {
                    handler.handleTextSet();
                    return;
                }
                event.doit = false;
                if (loc.startsWith("about:")) {
                    return;
                }
                try {
                    uri = new URI(loc);
                }
                catch (URISyntaxException e) {
                    File file = new File(loc);
                    if (!file.exists()) {
                        PHPUiPlugin.log(e);
                        return;
                    }
                    uri = file.toURI();
                    loc = uri.toASCIIString();
                }
                String scheme = uri.getScheme();
                if (PHPElementLinks.PHPDOC_SCHEME.equals(scheme)) {
                    linkTarget = PHPElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleInlineLink(linkTarget);
                } else if (PHPElementLinks.OPEN_LINK_SCHEME.equals(scheme)) {
                    linkTarget = PHPElementLinks.parseURI(uri);
                    if (linkTarget == null) {
                        return;
                    }
                    handler.handleDeclarationLink(linkTarget);
                } else {
                    try {
                        if (handler.handleExternalLink(new URL(loc), event.display)) {
                            return;
                        }
                        event.doit = true;
                    }
                    catch (MalformedURLException e) {
                        PHPUiPlugin.log(e);
                    }
                }
            }
        };
    }

    protected static IModelElement parseURI(URI uri) {
        String ssp = uri.getSchemeSpecificPart();
        String[] segments = ssp.split(String.valueOf('\u2602'), -1);
        IModelElement element = DLTKCore.create((String)segments[1].replace('\u2603', '['));
        if (segments.length > 2 && element instanceof IMember) {
            IMember member = (IMember)element;
            String refTypeName = segments[2];
            IType[] types = null;
            try {
                int offset = member.getSourceRange() != null ? member.getSourceRange().getOffset() : 0;
                types = PHPModelUtils.getTypes((String)refTypeName, (ISourceModule)member.getSourceModule(), (int)offset, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            if (types != null && types.length > 0) {
                void type = types[0];
                if (segments.length > 3) {
                    String refMemberName = segments[3];
                    IMethod method = type.getMethod(refMemberName);
                    if (method != null) {
                        return method;
                    }
                    return type.getField(refMemberName);
                }
                return type;
            }
        }
        return element;
    }

    public static String createURI(String scheme, IModelElement element) throws URISyntaxException {
        return PHPElementLinks.createURI(scheme, element, null, null, null);
    }

    public static String createURI(String scheme, IModelElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
        StringBuffer ssp = new StringBuffer(60);
        ssp.append('\u2602');
        ssp.append(element.getHandleIdentifier().replace('[', '\u2603'));
        if (refTypeName != null) {
            ssp.append('\u2602');
            ssp.append(refTypeName);
            if (refMemberName != null) {
                ssp.append('\u2602');
                ssp.append(refMemberName);
                if (refParameterTypes != null) {
                    ssp.append('\u2602');
                    int i = 0;
                    while (i < refParameterTypes.length) {
                        ssp.append(refParameterTypes[i]);
                        if (i != refParameterTypes.length - 1) {
                            ssp.append('\u2602');
                        }
                        ++i;
                    }
                }
            }
        }
        return new URI(scheme, ssp.toString(), null).toASCIIString();
    }

    public static interface ILinkHandler {
        public void handleInlineLink(IModelElement var1);

        public void handleDeclarationLink(IModelElement var1);

        public boolean handleExternalLink(URL var1, Display var2);

        public void handleTextSet();
    }
}

