/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.ui.editor.SemanticHighlighting;
import org.eclipse.php.internal.ui.editor.SemanticToken;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightings {
    public static final String STATIC_FINAL_FIELD = "staticFinalField";
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    public static final String STATIC_METHOD_INVOCATION = "staticMethodInvocation";
    public static final String INHERITED_METHOD_INVOCATION = "inheritedMethodInvocation";
    public static final String ANNOTATION_ELEMENT_REFERENCE = "annotationElementReference";
    public static final String ABSTRACT_METHOD_INVOCATION = "abstractMethodInvocation";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String NULL_VALUE = "nullValue";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String DEPRECATED_MEMBER = "deprecatedMember";
    public static final String TYPE_VARIABLE = "typeParameter";
    public static final String METHOD = "method";
    public static final String AUTOBOXING = "autoboxing";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String INTERFACE = "interface";
    public static final String ANNOTATION = "annotation";
    public static final String TYPE_ARGUMENT = "typeArgument";
    public static final String NUMBER = "number";
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new NullHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            SemanticHighlightings.setDefaultAndFireEvent(store, SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), semanticHighlighting.isUnderlineByDefault());
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
            ++i;
        }
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        String relevantKey = null;
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]))) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        boolean enable = false;
        int i = 0;
        while (i < highlightings.length) {
            String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!store.getBoolean(enabledKey)) {
                enable = true;
                break;
            }
            ++i;
        }
        return enable;
    }

    private static boolean conditionalReset(IPreferenceStore store, String oldKey, String newKey) {
        if (!store.isDefault(oldKey)) {
            if (store.isDefault(newKey)) {
                store.setValue(newKey, store.getString(oldKey));
            }
            store.setToDefault(oldKey);
            return true;
        }
        return false;
    }

    private static void setDefaultAndFireEvent(IPreferenceStore store, String key, RGB newValue) {
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private SemanticHighlightings() {
    }

    private static final class NullHighlighting
    extends SemanticHighlighting {
        private NullHighlighting() {
        }

        public boolean consumesLiteral(SemanticToken token) {
            Expression node = token.getLiteral();
            return node.isNullExpression();
        }

        public String getPreferenceKey() {
            return SemanticHighlightings.NULL_VALUE;
        }

        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        public boolean isBoldByDefault() {
            return true;
        }

        public boolean isItalicByDefault() {
            return true;
        }

        public boolean isEnabledByDefault() {
            return true;
        }

        public String getDisplayName() {
            return "";
        }

        public boolean consumes(SemanticToken token) {
            return false;
        }
    }
}

