/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.IPHPCompletionProposalExtension;
import org.eclipse.php.internal.ui.editor.contentassist.PHPOverrideCompletionProposal;
import org.eclipse.php.internal.ui.text.template.contentassist.PositionBasedCompletionProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public final class ParameterGuessingProposal
extends PHPOverrideCompletionProposal
implements IPHPCompletionProposalExtension {
    private static final String PARENS = "()";
    private static final char[] NO_TRIGGERS = new char[0];
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String COMMA = ", ";
    protected static final String SPACE = " ";
    private CompletionProposal fProposal;
    private IMethod method;
    private final boolean fFillBestGuess;
    private boolean fReplacementStringComputed = false;
    private Object extraInfo;
    private boolean fReplacementLengthComputed;
    private String alias = null;
    private IDocument document = null;
    private IScriptProject sProject = null;
    private ICompletionProposal[][] fChoices;
    private Position[] fPositions;
    private IRegion fSelectedRegion;
    private IPositionUpdater fUpdater;

    public ParameterGuessingProposal(CompletionProposal proposal, IScriptProject jproject, ISourceModule cu, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal, boolean fillBestGuess, Object extraInfo, IDocument document) {
        super(jproject, cu, methodName, paramTypes, start, length, displayName, completionProposal);
        this.fProposal = proposal;
        this.method = (IMethod)this.fProposal.getModelElement();
        this.fFillBestGuess = fillBestGuess;
        this.extraInfo = extraInfo;
        this.document = document;
        this.sProject = jproject;
    }

    private IMethod getProperMethod(IMethod modelElement) {
        if (modelElement instanceof FakeConstructor) {
            IType type;
            IMethod[] ctors;
            FakeConstructor fc = (FakeConstructor)modelElement;
            if (fc.getParent() instanceof AliasType) {
                AliasType aliasType = (AliasType)fc.getParent();
                this.alias = aliasType.getAlias();
                fc = FakeConstructor.createFakeConstructor(null, (IType)((IType)aliasType.getParent()), (boolean)false);
            }
            if ((ctors = FakeConstructor.getConstructors((IType)(type = fc.getDeclaringType()), (boolean)fc.isEnclosingClass())) != null && ctors.length == 2 && ctors[0] != null && ctors[1] != null) {
                return ctors[0];
            }
            return fc;
        }
        return modelElement;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            this.dealSuffix(document, offset);
            super.apply(document, trigger, offset);
            int baseOffset = this.getReplacementOffset();
            String replacement = this.getReplacementString();
            if (this.fPositions != null && this.fPositions.length > 0 && this.getTextViewer() != null) {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i < this.fPositions.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    int positionOffset = this.fPositions[i].getOffset();
                    int positionLength = this.fPositions[i].getLength();
                    if (this.fChoices[i].length < 2) {
                        group.addPosition(new LinkedPosition(document, positionOffset, positionLength, -1));
                    } else {
                        this.ensurePositionCategoryInstalled(document, model);
                        document.addPosition(this.getCategory(), this.fPositions[i]);
                        group.addPosition((LinkedPosition)new ProposalPosition(document, positionOffset, positionLength, -1, this.fChoices[i]));
                    }
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacement.length(), 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_WHEN_NO_PARENT);
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            } else {
                this.fSelectedRegion = new Region(baseOffset + this.getCursorPosition(), 0);
            }
        }
        catch (BadLocationException e) {
            this.ensurePositionCategoryRemoved(document);
            PHPUiPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
        catch (BadPositionCategoryException e) {
            this.ensurePositionCategoryRemoved(document);
            PHPUiPlugin.log(e);
            this.openErrorDialog((Exception)((Object)e));
        }
    }

    private void dealSuffix(IDocument document, int offset) {
        String replacement;
        boolean toggleEating = this.isToggleEating();
        boolean instertCompletion = this.insertCompletion();
        if (instertCompletion && toggleEating) {
            this.setReplacementLength(this.getReplacementLength() + 1);
        }
        if ((replacement = this.getReplacementString()).endsWith(RPAREN)) {
            if (instertCompletion && toggleEating) {
                if (this.cursorInBrackets(document, this.getReplacementOffset() + this.getReplacementLength() + 1)) {
                    this.setReplacementLength(this.getReplacementLength() + 2);
                }
            } else if (this.cursorInBrackets(document, offset + 1)) {
                this.setReplacementLength(this.getReplacementLength() + 2);
            }
        } else if (this.insertCompletion() && !this.cursorInBrackets(document, offset + 1)) {
            replacement = String.valueOf(replacement) + PARENS;
            this.setReplacementString(replacement);
        }
    }

    private boolean cursorInBrackets(IDocument document, int offset) {
        String nextWord = null;
        try {
            nextWord = document.get(offset - 1, 2);
        }
        catch (BadLocationException badLocationException) {}
        return PARENS.equals(nextWord);
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return super.getReplacementLength();
    }

    public final void setReplacementLength(int replacementLength) {
        this.fReplacementLengthComputed = true;
        super.setReplacementLength(replacementLength);
    }

    protected boolean needsLinkedMode() {
        return false;
    }

    public String getReplacementString() {
        String prefix;
        block9: {
            prefix = "";
            try {
                if (!this.method.isConstructor()) break block9;
                IType type = this.method.getDeclaringType();
                try {
                    int flags = type.getFlags();
                    IType currentNamespace = PHPModelUtils.getCurrentNamespace((ISourceModule)this.fSourceModule, (int)this.getReplacementOffset());
                    IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)type);
                    if (!PHPFlags.isNamespace((int)flags) && namespace == null && currentNamespace != null && !ProjectOptions.getPhpVersion((IProject)this.sProject.getProject()).isLessThan(PHPVersion.PHP5_3) && this.document.getChar(this.getReplacementOffset() - 1) != '\\') {
                        prefix = String.valueOf(prefix) + '\\';
                    }
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
                catch (BadLocationException e) {
                    PHPUiPlugin.log(e);
                }
            }
            catch (ModelException modelException) {}
        }
        if (ProposalExtraInfo.isMethodOnly((Object)this.extraInfo)) {
            this.setReplacementString(String.valueOf(prefix) + this.method.getElementName());
            return super.getReplacementString();
        }
        boolean fileArgumentNames = Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistFillMethodArguments", true, null);
        if (fileArgumentNames && !this.fReplacementStringComputed) {
            this.setReplacementString(String.valueOf(prefix) + this.computeReplacementString());
        }
        if (!fileArgumentNames) {
            this.setReplacementString(String.valueOf(prefix) + super.getReplacementString());
        }
        return super.getReplacementString();
    }

    private String computeReplacementString() {
        this.fReplacementStringComputed = true;
        try {
            this.method = this.getProperMethod(this.method);
            if (this.alias != null || this.hasParameters() && this.hasArgumentList()) {
                return this.computeGuessingCompletion();
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return super.getReplacementString();
    }

    protected boolean hasArgumentList() {
        if (10 == this.fProposal.getKind()) {
            return false;
        }
        Preferences preferenceStore = PHPCorePlugin.getDefault().getPluginPreferences();
        boolean noOverwrite = preferenceStore.getBoolean("contentAssistInsertCompletion") ^ this.isToggleEating();
        char[] completion = this.fProposal.getCompletion().toCharArray();
        return !this.isInScriptdoc() && completion.length > 0 && (noOverwrite || completion[completion.length - 1] == ')');
    }

    protected boolean isValidPrefix(String prefix) {
        this.initAlias();
        String replacementString = null;
        replacementString = this.alias != null ? this.getAlias() : super.getReplacementString();
        return this.isPrefix(prefix, replacementString);
    }

    public String getAlias() {
        return String.valueOf(this.alias) + LPAREN + RPAREN;
    }

    private void initAlias() {
        FakeConstructor fc;
        if (this.method instanceof FakeConstructor && (fc = (FakeConstructor)this.method).getParent() instanceof AliasType) {
            this.alias = ((AliasType)fc.getParent()).getAlias();
        }
    }

    private boolean hasParameters() throws ModelException {
        return this.method.getParameters() != null && this.hasNondefaultValues(this.method.getParameters());
    }

    private boolean hasNondefaultValues(IParameter[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            IParameter parameter = parameters[i];
            if (parameter.getDefaultValue() == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String computeGuessingCompletion() throws ModelException {
        StringBuffer buffer = new StringBuffer();
        this.appendMethodNameReplacement(buffer);
        this.setCursorPosition(buffer.length());
        IParameter[] parameters = this.method.getParameters();
        ArrayList<String> paramList = new ArrayList<String>();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                IParameter parameter = parameters[i];
                if (parameter.getDefaultValue() == null) {
                    paramList.add(parameter.getName());
                }
                ++i;
            }
        }
        char[][] parameterNames = new char[paramList.size()][];
        int i = 0;
        while (i < paramList.size()) {
            parameterNames[i] = ((String)paramList.get(i)).toCharArray();
            ++i;
        }
        this.fChoices = this.guessParameters(parameterNames);
        int count = this.fChoices.length;
        int replacementOffset = this.getReplacementOffset();
        int i2 = 0;
        while (i2 < count) {
            if (i2 != 0) {
                buffer.append(COMMA);
            }
            ICompletionProposal proposal = this.fChoices[i2][0];
            String argument = proposal.getDisplayString();
            Position position = this.fPositions[i2];
            position.setOffset(replacementOffset + buffer.length());
            position.setLength(argument.length());
            buffer.append(argument);
            ++i2;
        }
        buffer.append(RPAREN);
        return buffer.toString();
    }

    protected void appendMethodNameReplacement(StringBuffer buffer) {
        if (this.alias != null) {
            buffer.append(this.alias);
            buffer.append(LPAREN);
        } else {
            buffer.append(this.fProposal.getName());
            buffer.append(LPAREN);
        }
    }

    private ICompletionProposal[][] guessParameters(char[][] parameterNames) throws ModelException {
        int count = parameterNames.length;
        this.fPositions = new Position[count];
        this.fChoices = new ICompletionProposal[count][];
        IParameter[] parameters = this.method.getParameters();
        int i = count - 1;
        while (i >= 0) {
            String paramName = new String(parameterNames[i]);
            Position position = new Position(0, 0);
            ICompletionProposal[] argumentProposals = this.parameterProposals(parameters[i].getDefaultValue(), paramName, position, this.fFillBestGuess);
            this.fPositions[i] = position;
            this.fChoices[i] = argumentProposals;
            --i;
        }
        return this.fChoices;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(Exception e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)"Error guessing parameters", (String)e.getMessage());
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        if (!document.containsPositionCategory(this.getCategory())) {
            document.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    ParameterGuessingProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.getCategory())) {
            try {
                document.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            document.removePositionUpdater(this.fUpdater);
        }
    }

    private String getCategory() {
        return "ParameterGuessingProposal_" + this.toString();
    }

    public ICompletionProposal[] parameterProposals(String initialValue, String paramName, Position pos, boolean fillBestGuess) throws ModelException {
        ArrayList<String> typeMatches = new ArrayList<String>();
        if (initialValue != null) {
            typeMatches.add(initialValue);
        }
        ICompletionProposal[] ret = new ICompletionProposal[typeMatches.size()];
        int i = 0;
        int replacementLength = 0;
        for (String name : typeMatches) {
            if (i == 0) {
                replacementLength = name.length();
            }
            char[] triggers = new char[1];
            triggers[triggers.length - 1] = 59;
            ret[i++] = new PositionBasedCompletionProposal(name, pos, replacementLength, this.getImage(), name, null, null, triggers);
        }
        if (!fillBestGuess) {
            ICompletionProposal[] extended = new ICompletionProposal[ret.length + 1];
            System.arraycopy(ret, 0, extended, 1, ret.length);
            extended[0] = new PositionBasedCompletionProposal(paramName, pos, replacementLength, null, paramName, null, null, NO_TRIGGERS);
            return extended;
        }
        return ret;
    }

    public void setReplacementOffset(int replacementOffset) {
        int oldReplacementOffset = this.getReplacementOffset();
        if (this.fPositions != null && this.fPositions.length > 0) {
            Position[] positionArray = this.fPositions;
            int n = this.fPositions.length;
            int n2 = 0;
            while (n2 < n) {
                Position position = positionArray[n2];
                position.offset += replacementOffset - oldReplacementOffset;
                ++n2;
            }
        }
        super.setReplacementOffset(replacementOffset);
    }

    public Object getExtraInfo() {
        return this.extraInfo;
    }
}

