/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;

public class FunctionHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new FunctionApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setItalicByDefault(true);
    }

    public String getDisplayName() {
        return "Functions";
    }

    protected class FunctionApply
    extends AbstractSemanticApply {
        protected FunctionApply() {
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration.getParent().getType() != 42) {
                FunctionHighlighting.this.highlight((ASTNode)functionDeclaration.getFunctionName());
            }
            return true;
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Expression functionName = functionInvocation.getFunctionName().getName();
            int invocationParent = functionInvocation.getParent().getType();
            if (invocationParent != 43 && invocationParent != 53) {
                this.highlightFunctionName(functionName);
            }
            return true;
        }

        private void highlightFunctionName(Expression functionName) {
            if (functionName instanceof NamespaceName) {
                List segments = ((NamespaceName)functionName).segments();
                Identifier segment = (Identifier)segments.get(segments.size() - 1);
                FunctionHighlighting.this.highlight((ASTNode)segment);
            } else {
                FunctionHighlighting.this.highlight((ASTNode)functionName);
            }
        }
    }
}

