/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.compare.MergeSourceViewer;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.text.correction.AssistContext;
import org.eclipse.php.internal.ui.text.correction.IInvocationContext;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.php.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.php.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;

public class QuickAssistLightBulbUpdater {
    private final Annotation fAnnotation;
    private boolean fIsAnnotationShown;
    private ITextEditor fEditor;
    private ITextViewer fViewer;
    private ISelectionListenerWithAST fListener;
    private IPropertyChangeListener fPropertyChangeListener;

    public QuickAssistLightBulbUpdater(ITextEditor part, ITextViewer viewer) {
        this.fEditor = part;
        this.fViewer = viewer;
        this.fAnnotation = new AssistAnnotation();
        this.fIsAnnotationShown = false;
        this.fPropertyChangeListener = null;
    }

    public boolean isSetInPreferences() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.php.quickassist.lightbulb");
    }

    private void installSelectionListener() {
        this.fListener = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, Program astRoot) {
                QuickAssistLightBulbUpdater.this.doSelectionChanged(selection.getOffset(), selection.getLength(), astRoot);
            }
        };
        if (this.fEditor != null) {
            SelectionListenerWithASTManager.getDefault().addListener(this.fEditor, this.fListener);
        }
    }

    private void uninstallSelectionListener() {
        IAnnotationModel model;
        if (this.fListener != null && this.fEditor != null) {
            SelectionListenerWithASTManager.getDefault().removeListener(this.fEditor, this.fListener);
            this.fListener = null;
        }
        if ((model = this.getAnnotationModel()) != null) {
            this.removeLightBulb(model);
        }
    }

    public void install() {
        if (this.isSetInPreferences()) {
            this.installSelectionListener();
        }
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    QuickAssistLightBulbUpdater.this.doPropertyChanged(event.getProperty());
                }
            };
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void uninstall() {
        this.uninstallSelectionListener();
        if (this.fPropertyChangeListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
    }

    protected void doPropertyChanged(String property) {
        if (property.equals("org.eclipse.php.quickassist.lightbulb")) {
            if (this.isSetInPreferences()) {
                ISourceModule cu = this.getCompilationUnit();
                if (cu != null) {
                    this.installSelectionListener();
                    Point point = this.fViewer.getSelectedRange();
                    Program astRoot = null;
                    try {
                        astRoot = SharedASTProvider.getAST(cu, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
                    }
                    catch (ModelException e) {
                        PHPUiPlugin.log(e);
                    }
                    catch (IOException e) {
                        PHPUiPlugin.log(e);
                    }
                    if (astRoot != null) {
                        this.doSelectionChanged(point.x, point.y, astRoot);
                    }
                }
            } else {
                this.uninstallSelectionListener();
            }
        }
    }

    private ISourceModule getCompilationUnit() {
        ISourceModule elem;
        if (this.fEditor != null && (elem = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)this.fEditor.getEditorInput())) instanceof ISourceModule) {
            return elem;
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        if (this.fEditor != null) {
            return DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        }
        if (this.fViewer instanceof MergeSourceViewer) {
            return ((MergeSourceViewer)this.fViewer).getAnnotationModel();
        }
        return null;
    }

    private IDocument getDocument() {
        if (this.fEditor != null) {
            return DLTKUIPlugin.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        }
        if (this.fViewer instanceof MergeSourceViewer) {
            return ((MergeSourceViewer)this.fViewer).getDocument();
        }
        return null;
    }

    private void doSelectionChanged(int offset, int length, Program astRoot) {
        IAnnotationModel model = this.getAnnotationModel();
        ISourceModule cu = this.getCompilationUnit();
        if (model == null || cu == null) {
            return;
        }
        AssistContext context = new AssistContext(cu, offset, length);
        context.setASTRoot(astRoot);
        boolean hasQuickFix = this.hasQuickFixLightBulb(model, context.getSelectionOffset());
        if (hasQuickFix) {
            this.removeLightBulb(model);
            return;
        }
        this.calculateLightBulb(model, context);
    }

    private void calculateLightBulb(IAnnotationModel model, IInvocationContext context) {
        boolean needsAnnotation = PHPCorrectionProcessor.hasAssists(context);
        if (this.fIsAnnotationShown) {
            model.removeAnnotation(this.fAnnotation);
        }
        if (needsAnnotation) {
            model.addAnnotation(this.fAnnotation, new Position(context.getSelectionOffset(), context.getSelectionLength()));
        }
        this.fIsAnnotationShown = needsAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLightBulb(IAnnotationModel model) {
        QuickAssistLightBulbUpdater quickAssistLightBulbUpdater = this;
        synchronized (quickAssistLightBulbUpdater) {
            if (this.fIsAnnotationShown) {
                model.removeAnnotation(this.fAnnotation);
                this.fIsAnnotationShown = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasQuickFixLightBulb(IAnnotationModel model, int offset) {
        try {
            int startLine;
            Position pos;
            Annotation annot;
            IDocument document = this.getDocument();
            if (document == null) {
                return false;
            }
            int currLine = document.getLineOfOffset(offset);
            Iterator iter = model.getAnnotationIterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while (!PHPCorrectionProcessor.isQuickFixableType(annot = (Annotation)iter.next()) || (pos = model.getPosition(annot)) == null || (startLine = document.getLineOfOffset(pos.getOffset())) != currLine || !PHPCorrectionProcessor.hasCorrections(annot));
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        return false;
    }

    public static class AssistAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private static final int LAYER;
        private Image fImage;

        static {
            Annotation annotation = new Annotation("org.eclipse.dltk.ui.warning", false, null);
            AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
            LAYER = preference != null ? preference.getPresentationLayer() - 1 : 0;
        }

        public int getLayer() {
            return LAYER;
        }

        private Image getImage() {
            if (this.fImage == null) {
                this.fImage = DLTKPluginImages.get((String)"org.eclipse.dltk.ui.quickassist_obj.gif");
            }
            return this.fImage;
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            ImageUtilities.drawImage((Image)this.getImage(), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }
    }
}

