/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceDeclaration
extends TypeDeclaration {
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(InterfaceDeclaration.class, "name", Identifier.class, true, false);
    public static final ChildListPropertyDescriptor INTERFACES_PROPERTY = new ChildListPropertyDescriptor(InterfaceDeclaration.class, "interfaces", Identifier.class, false);
    public static final ChildPropertyDescriptor BODY_PROPERTY = new ChildPropertyDescriptor(InterfaceDeclaration.class, "body", Block.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(3);
        propertyList.add(NAME_PROPERTY);
        propertyList.add(INTERFACES_PROPERTY);
        propertyList.add(BODY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    @Override
    protected ChildPropertyDescriptor getBodyProperty() {
        return BODY_PROPERTY;
    }

    @Override
    protected ChildListPropertyDescriptor getInterfacesProperty() {
        return INTERFACES_PROPERTY;
    }

    @Override
    protected ChildPropertyDescriptor getNameProperty() {
        return NAME_PROPERTY;
    }

    private InterfaceDeclaration(int start, int end, AST ast, Identifier interfaceName, Identifier[] interfaces, Block body) {
        super(start, end, ast, interfaceName, interfaces, body);
    }

    public InterfaceDeclaration(int start, int end, AST ast, Identifier interfaceName, List interfaces, Block body) {
        this(start, end, ast, interfaceName, interfaces.toArray(new Identifier[interfaces.size()]), body);
    }

    public InterfaceDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.getName().accept(visitor);
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.accept(visitor);
        }
        this.getBody().accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.getName().traverseTopDown(visitor);
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.traverseTopDown(visitor);
        }
        this.getBody().traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.getName().traverseBottomUp(visitor);
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.traverseBottomUp(visitor);
        }
        this.getBody().traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<InterfaceDeclaration");
        this.appendInterval(buffer);
        buffer.append(">\n");
        buffer.append(tab).append("\t").append("<InterfaceName>\n");
        this.getName().toString(buffer, "\t\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("\t").append("</InterfaceName>\n");
        buffer.append(tab).append("\t").append("<Interfaces>\n");
        List<Identifier> interfaes = this.interfaces();
        for (Identifier node : interfaes) {
            ASTNode inter = node;
            inter.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("\t").append("</Interfaces>\n");
        this.getBody().toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</InterfaceDeclaration>");
    }

    @Override
    public int getType() {
        return 40;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Identifier name = ASTNode.copySubtree(target, this.getName());
        Block body = ASTNode.copySubtree(target, this.getBody());
        List interfaces = ASTNode.copySubtrees(target, this.interfaces());
        InterfaceDeclaration result = new InterfaceDeclaration(this.getStart(), this.getEnd(), target, name, interfaces, body);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

