/* The following code was generated by JFlex 1.4.1 on 10/9/12 8:55 AM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.compiler.ast.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTagKinds;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 10/9/12 8:55 AM from the specification file
 * <tt>documentor_compiler_ast_scanner.flex</tt>
 */
public class DocumentorLexer implements IDocumentorLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_IN_TAGS = 6;
  public static final int YYINITIAL = 0;
  public static final int ST_IN_SHORT_DESC = 2;
  public static final int ST_IN_LONG_DESC = 4;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  3,  4,  5,  6, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\11\0\1\4\2\0"+
    "\1\37\1\6\1\5\20\0\1\7\1\10\1\11\1\15\1\26\1\16"+
    "\1\32\1\22\1\20\1\25\1\0\1\34\1\31\1\30\1\33\1\21"+
    "\1\24\1\0\1\14\1\12\1\13\1\17\1\35\1\36\1\27\1\23"+
    "\7\0\1\10\1\11\1\15\1\26\1\16\1\32\1\22\1\20\1\25"+
    "\1\0\1\34\1\31\1\30\1\33\1\21\1\24\1\0\1\14\1\12"+
    "\1\13\1\17\1\35\1\36\1\27\1\23\1\0\1\40\1\0\1\41"+
    "\uff82\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\3\0\1\1\1\0\1\1\1\0\1\1\3\2\2\3"+
    "\3\2\2\4\4\2\2\5\1\2\2\1\2\2\2\1"+
    "\2\2\3\0\1\6\1\7\2\6\2\1\2\0\1\1"+
    "\1\10\23\0\1\11\1\1\2\0\1\12\2\0\1\1"+
    "\21\0\1\13\70\0\2\13\4\0\1\14\30\0\1\15"+
    "\6\0\1\16\30\0\1\17\12\0\1\20\4\0\1\21"+
    "\6\0\1\22\3\0\1\23\2\0\1\24\12\0\1\25"+
    "\4\0\1\26\6\0\1\27\3\0\1\30\2\0\1\31"+
    "\7\0\1\32\7\0\1\33\10\0\1\34\10\0\1\35"+
    "\7\0\1\36\10\0\1\37\4\0\1\40\1\41\1\42"+
    "\2\0\1\43\1\44\3\0\1\45\2\0\1\46\2\0"+
    "\1\47\6\0\1\50\1\51\1\52\2\0\1\53\1\54"+
    "\3\0\1\55\2\0\1\56\2\0\1\57\13\0\1\60"+
    "\1\61\3\0\1\62\2\0\1\63\7\0\1\64\1\65"+
    "\3\0\1\66\2\0\1\67\1\0\1\70\2\0\1\71"+
    "\1\72\1\0\1\73\1\74\4\0\1\75\2\0\1\76"+
    "\1\77\1\0\1\100\1\101\4\0\1\102\1\0\1\103"+
    "\3\0\1\104\1\0\1\105\1\0\1\106\3\0\1\107"+
    "\1\0\1\110\2\0\1\111\1\112\1\0\1\113\2\0"+
    "\1\114\1\115\11\0\1\116\2\0\1\117\1\120\1\0"+
    "\1\121\1\0\1\122\1\123";

  private static int [] zzUnpackAction() {
    int [] result = new int[473];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\42\0\104\0\146\0\210\0\252\0\314\0\356"+
    "\0\u0110\0\u0132\0\u0154\0\u0110\0\u0176\0\u0198\0\u01ba\0\u01dc"+
    "\0\u0110\0\u01fe\0\u0220\0\u0242\0\u0264\0\u0286\0\u0110\0\u02a8"+
    "\0\u02ca\0\u02ec\0\u030e\0\u0330\0\u0352\0\u0374\0\u0396\0\u03b8"+
    "\0\u03da\0\u03fc\0\u0154\0\u0198\0\u0110\0\u0110\0\u041e\0\u0440"+
    "\0\u01dc\0\u0220\0\u0242\0\u0264\0\u0462\0\u0110\0\u0484\0\u04a6"+
    "\0\u04c8\0\u04ea\0\u050c\0\u052e\0\u0550\0\u0572\0\u0594\0\u05b6"+
    "\0\u05d8\0\u05fa\0\u061c\0\u063e\0\u0660\0\u0682\0\u06a4\0\u0286"+
    "\0\u02ca\0\u0110\0\u06c6\0\u0330\0\u0352\0\u0110\0\u03b8\0\u03da"+
    "\0\u06e8\0\u070a\0\u072c\0\u074e\0\u0770\0\u0792\0\u07b4\0\u07d6"+
    "\0\u07f8\0\u081a\0\u083c\0\u085e\0\u0880\0\u08a2\0\u08c4\0\u08e6"+
    "\0\u0908\0\u092a\0\u094c\0\u096e\0\u0990\0\u09b2\0\u09d4\0\u09f6"+
    "\0\u0a18\0\u0a3a\0\u0a5c\0\u0a7e\0\u0aa0\0\u0ac2\0\u0ae4\0\u0b06"+
    "\0\u0b28\0\u0b4a\0\u0b6c\0\u0b8e\0\u0bb0\0\u0bd2\0\u0bf4\0\u0c16"+
    "\0\u0c38\0\u0c5a\0\u0c7c\0\u0c9e\0\u0cc0\0\u0ce2\0\u0d04\0\u0d26"+
    "\0\u0d48\0\u0d6a\0\u0d8c\0\u0dae\0\u0dd0\0\u0df2\0\u0e14\0\u0e36"+
    "\0\u0e58\0\u0e7a\0\u0e9c\0\u0ebe\0\u0ee0\0\u0f02\0\u0f24\0\u0f46"+
    "\0\u0f68\0\u0f8a\0\u0fac\0\u0fce\0\u0ff0\0\u1012\0\u1034\0\u1056"+
    "\0\u1078\0\u109a\0\u10bc\0\u0110\0\u10de\0\u1100\0\u1122\0\u1144"+
    "\0\u1166\0\u0110\0\u1188\0\u11aa\0\u11cc\0\u11ee\0\u1210\0\u1232"+
    "\0\u1254\0\u1276\0\u1298\0\u12ba\0\u12dc\0\u12fe\0\u1320\0\u1342"+
    "\0\u1364\0\u1386\0\u13a8\0\u13ca\0\u13ec\0\u140e\0\u1430\0\u1452"+
    "\0\u1474\0\u1496\0\u0110\0\u14b8\0\u14da\0\u14fc\0\u151e\0\u1540"+
    "\0\u1562\0\u0110\0\u1584\0\u15a6\0\u15c8\0\u15ea\0\u160c\0\u162e"+
    "\0\u1650\0\u1672\0\u1694\0\u16b6\0\u16d8\0\u16fa\0\u171c\0\u173e"+
    "\0\u1760\0\u1782\0\u17a4\0\u17c6\0\u17e8\0\u180a\0\u182c\0\u184e"+
    "\0\u1870\0\u1892\0\u0110\0\u18b4\0\u18d6\0\u18f8\0\u191a\0\u193c"+
    "\0\u195e\0\u1980\0\u19a2\0\u19c4\0\u19e6\0\u0110\0\u1a08\0\u1a2a"+
    "\0\u1a4c\0\u1a6e\0\u0110\0\u1a90\0\u1ab2\0\u1ad4\0\u1af6\0\u1b18"+
    "\0\u1b3a\0\u0110\0\u1b5c\0\u1b7e\0\u1ba0\0\u0110\0\u1bc2\0\u1be4"+
    "\0\u1c06\0\u1c28\0\u1c4a\0\u1c6c\0\u1c8e\0\u1cb0\0\u1cd2\0\u1cf4"+
    "\0\u1d16\0\u1d38\0\u1d5a\0\u0110\0\u1d7c\0\u1d9e\0\u1dc0\0\u1de2"+
    "\0\u0110\0\u1e04\0\u1e26\0\u1e48\0\u1e6a\0\u1e8c\0\u1eae\0\u0110"+
    "\0\u1ed0\0\u1ef2\0\u1f14\0\u0110\0\u1f36\0\u1f58\0\u1f7a\0\u1f9c"+
    "\0\u1fbe\0\u1fe0\0\u2002\0\u2024\0\u2046\0\u2068\0\u0110\0\u208a"+
    "\0\u20ac\0\u20ce\0\u20f0\0\u2112\0\u2134\0\u2156\0\u0110\0\u2178"+
    "\0\u219a\0\u21bc\0\u21de\0\u2200\0\u2222\0\u2244\0\u2266\0\u0110"+
    "\0\u2288\0\u22aa\0\u22cc\0\u22ee\0\u2310\0\u2332\0\u2354\0\u2376"+
    "\0\u0110\0\u2398\0\u23ba\0\u23dc\0\u23fe\0\u2420\0\u2442\0\u2464"+
    "\0\u0110\0\u2486\0\u24a8\0\u24ca\0\u24ec\0\u250e\0\u2530\0\u2552"+
    "\0\u2574\0\u0110\0\u2596\0\u25b8\0\u25da\0\u25fc\0\u0110\0\u0110"+
    "\0\u261e\0\u2640\0\u2662\0\u0110\0\u0110\0\u2684\0\u26a6\0\u26c8"+
    "\0\u0110\0\u26ea\0\u270c\0\u0110\0\u272e\0\u2750\0\u0110\0\u2772"+
    "\0\u2794\0\u27b6\0\u27d8\0\u27fa\0\u281c\0\u0110\0\u0110\0\u283e"+
    "\0\u2860\0\u2882\0\u0110\0\u0110\0\u28a4\0\u28c6\0\u28e8\0\u0110"+
    "\0\u290a\0\u292c\0\u0110\0\u294e\0\u2970\0\u0110\0\u2992\0\u29b4"+
    "\0\u29d6\0\u29f8\0\u2a1a\0\u2a3c\0\u2a5e\0\u2a80\0\u2aa2\0\u2ac4"+
    "\0\u2ae6\0\u0110\0\u0110\0\u2b08\0\u2b2a\0\u2b4c\0\u0110\0\u2b6e"+
    "\0\u2b90\0\u0110\0\u2bb2\0\u2bd4\0\u2bf6\0\u2c18\0\u2c3a\0\u2c5c"+
    "\0\u2c7e\0\u0110\0\u0110\0\u2ca0\0\u2cc2\0\u2ce4\0\u0110\0\u2d06"+
    "\0\u2d28\0\u0110\0\u2d4a\0\u0110\0\u2d6c\0\u2d8e\0\u0110\0\u0110"+
    "\0\u2db0\0\u2dd2\0\u0110\0\u2df4\0\u2e16\0\u2e38\0\u2e5a\0\u0110"+
    "\0\u2e7c\0\u2e9e\0\u0110\0\u0110\0\u2ec0\0\u2ee2\0\u0110\0\u2f04"+
    "\0\u2f26\0\u2f48\0\u2f6a\0\u0110\0\u2f8c\0\u0110\0\u2fae\0\u2fd0"+
    "\0\u2ff2\0\u0110\0\u3014\0\u0110\0\u3036\0\u0110\0\u3058\0\u307a"+
    "\0\u309c\0\u0110\0\u30be\0\u0110\0\u30e0\0\u3102\0\u0110\0\u0110"+
    "\0\u3124\0\u0110\0\u3146\0\u3168\0\u0110\0\u0110\0\u318a\0\u31ac"+
    "\0\u31ce\0\u31f0\0\u3212\0\u3234\0\u3256\0\u3278\0\u329a\0\u0110"+
    "\0\u32bc\0\u32de\0\u0110\0\u0110\0\u3300\0\u0110\0\u3322\0\u0110"+
    "\0\u0110";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[473];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\47\11\1\12\35\11\1\13\1\14\1\15\1\16\1\11"+
    "\1\17\34\11\1\20\1\21\1\22\1\23\1\11\1\17"+
    "\1\24\30\11\1\25\2\11\1\26\1\27\1\30\1\31"+
    "\36\11\1\32\1\27\1\30\1\33\2\11\1\24\30\11"+
    "\1\25\2\11\1\34\1\27\1\30\1\35\36\11\1\36"+
    "\1\27\1\30\1\37\2\11\1\40\30\11\1\41\1\11"+
    "\46\0\1\42\36\0\1\43\2\0\1\44\1\0\1\45"+
    "\35\0\1\14\44\0\1\46\35\0\1\47\1\45\1\50"+
    "\37\0\1\51\1\21\1\22\1\52\1\0\1\45\1\53"+
    "\30\0\1\54\3\0\1\21\40\0\1\55\1\21\1\22"+
    "\1\0\1\56\1\0\1\53\30\0\1\54\11\0\1\57"+
    "\1\0\1\60\1\61\1\62\1\63\1\64\1\65\2\0"+
    "\1\66\1\0\1\67\1\70\1\71\1\0\1\72\1\73"+
    "\1\74\1\75\1\0\1\76\13\0\1\77\33\0\1\100"+
    "\2\0\1\101\37\0\1\27\44\0\1\102\35\0\1\32"+
    "\2\0\1\33\2\0\1\53\30\0\1\54\2\0\1\103"+
    "\3\0\1\102\1\0\1\53\30\0\1\54\2\0\1\104"+
    "\2\0\1\105\42\0\1\106\35\0\1\36\2\0\1\37"+
    "\2\0\1\107\30\0\1\110\2\0\1\111\3\0\1\106"+
    "\1\0\1\107\30\0\1\110\11\0\1\112\1\0\1\113"+
    "\1\114\1\115\1\116\1\117\1\120\2\0\1\121\1\0"+
    "\1\122\1\123\1\124\1\0\1\125\1\126\1\127\1\130"+
    "\1\0\1\131\13\0\1\132\36\0\1\133\36\0\1\47"+
    "\42\0\1\45\40\0\1\55\1\21\1\22\3\0\1\53"+
    "\30\0\1\54\12\0\1\134\3\0\1\135\1\0\1\136"+
    "\35\0\1\137\2\0\1\140\1\141\5\0\1\142\33\0"+
    "\1\143\1\144\1\145\36\0\1\146\33\0\1\147\10\0"+
    "\1\150\47\0\1\151\24\0\1\152\60\0\1\153\20\0"+
    "\1\154\3\0\1\155\47\0\1\156\10\0\1\157\24\0"+
    "\1\160\41\0\1\161\50\0\1\162\41\0\1\163\24\0"+
    "\1\164\41\0\1\165\5\0\1\166\50\0\1\167\15\0"+
    "\1\103\5\0\1\53\30\0\1\54\2\0\1\111\5\0"+
    "\1\107\30\0\1\110\12\0\1\170\3\0\1\171\1\0"+
    "\1\172\35\0\1\173\2\0\1\174\1\175\5\0\1\176"+
    "\33\0\1\177\1\200\1\201\36\0\1\202\33\0\1\203"+
    "\10\0\1\204\47\0\1\205\24\0\1\206\60\0\1\207"+
    "\20\0\1\210\3\0\1\211\47\0\1\212\10\0\1\213"+
    "\24\0\1\214\41\0\1\215\50\0\1\216\41\0\1\217"+
    "\24\0\1\220\41\0\1\221\5\0\1\222\50\0\1\223"+
    "\15\0\1\133\1\224\1\225\50\0\1\226\44\0\1\227"+
    "\37\0\1\230\36\0\1\231\47\0\1\232\34\0\1\233"+
    "\63\0\1\234\21\0\1\235\42\0\1\236\53\0\1\237"+
    "\26\0\1\240\41\0\1\241\52\0\1\242\25\0\1\243"+
    "\47\0\1\244\44\0\1\245\34\0\1\246\1\247\45\0"+
    "\1\250\53\0\1\251\21\0\1\252\40\0\1\253\11\0"+
    "\1\254\30\0\1\255\43\0\1\256\15\0\1\257\37\0"+
    "\1\260\1\0\1\261\36\0\1\262\25\0\1\263\41\0"+
    "\1\264\60\0\1\265\20\0\1\266\44\0\1\267\37\0"+
    "\1\270\36\0\1\271\47\0\1\272\34\0\1\273\63\0"+
    "\1\274\21\0\1\275\42\0\1\276\53\0\1\277\26\0"+
    "\1\300\41\0\1\301\52\0\1\302\25\0\1\303\47\0"+
    "\1\304\44\0\1\305\34\0\1\306\1\307\45\0\1\310"+
    "\53\0\1\311\21\0\1\312\40\0\1\313\11\0\1\314"+
    "\30\0\1\315\43\0\1\316\15\0\1\317\37\0\1\320"+
    "\1\0\1\321\36\0\1\322\25\0\1\323\41\0\1\324"+
    "\60\0\1\325\10\0\1\224\52\0\1\326\44\0\1\327"+
    "\43\0\1\330\34\0\1\331\52\0\1\332\32\0\1\333"+
    "\45\0\1\334\41\0\1\335\41\0\1\336\37\0\1\337"+
    "\40\0\1\340\46\0\1\341\46\0\1\342\23\0\1\343"+
    "\40\0\1\344\40\0\1\345\65\0\1\346\31\0\1\347"+
    "\36\0\1\350\36\0\1\351\40\0\1\352\40\0\1\353"+
    "\45\0\1\354\37\0\1\355\57\0\1\356\23\0\1\357"+
    "\33\0\1\360\47\0\1\361\35\0\1\362\47\0\1\363"+
    "\34\0\1\364\44\0\1\365\43\0\1\366\34\0\1\367"+
    "\52\0\1\370\32\0\1\371\45\0\1\372\41\0\1\373"+
    "\41\0\1\374\37\0\1\375\40\0\1\376\46\0\1\377"+
    "\46\0\1\u0100\23\0\1\u0101\40\0\1\u0102\40\0\1\u0103"+
    "\65\0\1\u0104\31\0\1\u0105\36\0\1\u0106\36\0\1\u0107"+
    "\40\0\1\u0108\40\0\1\u0109\45\0\1\u010a\37\0\1\u010b"+
    "\57\0\1\u010c\23\0\1\u010d\33\0\1\u010e\47\0\1\u010f"+
    "\35\0\1\u0110\47\0\1\u0111\35\0\1\u0112\37\0\1\u0113"+
    "\50\0\1\u0114\45\0\1\u0115\24\0\1\u0116\47\0\1\u0117"+
    "\37\0\1\u0118\63\0\1\u0119\17\0\1\u011a\47\0\1\u011b"+
    "\33\0\1\u011c\51\0\1\u011d\25\0\1\u011e\61\0\1\u011f"+
    "\21\0\1\u0120\47\0\1\u0121\37\0\1\u0122\41\0\1\u0123"+
    "\43\0\1\u0124\44\0\1\u0125\53\0\1\u0126\20\0\1\u0127"+
    "\60\0\1\u0128\22\0\1\u0129\54\0\1\u012a\32\0\1\u012b"+
    "\37\0\1\u012c\37\0\1\u012d\50\0\1\u012e\45\0\1\u012f"+
    "\24\0\1\u0130\47\0\1\u0131\37\0\1\u0132\63\0\1\u0133"+
    "\17\0\1\u0134\47\0\1\u0135\33\0\1\u0136\51\0\1\u0137"+
    "\25\0\1\u0138\61\0\1\u0139\21\0\1\u013a\47\0\1\u013b"+
    "\37\0\1\u013c\41\0\1\u013d\43\0\1\u013e\44\0\1\u013f"+
    "\53\0\1\u0140\20\0\1\u0141\60\0\1\u0142\22\0\1\u0143"+
    "\54\0\1\u0144\32\0\1\u0145\33\0\1\u0146\43\0\1\u0147"+
    "\43\0\1\u0148\42\0\1\u0149\41\0\1\u014a\51\0\1\u014b"+
    "\26\0\1\u014c\62\0\1\u014d\27\0\1\u014e\45\0\1\u014f"+
    "\45\0\1\u0150\41\0\1\u0151\32\0\1\u0152\33\0\1\u0153"+
    "\43\0\1\u0154\56\0\1\u0155\23\0\1\u0156\52\0\1\u0157"+
    "\25\0\1\u0158\50\0\1\u0159\44\0\1\u015a\36\0\1\u015b"+
    "\34\0\1\u015c\35\0\1\u015d\43\0\1\u015e\43\0\1\u015f"+
    "\42\0\1\u0160\41\0\1\u0161\51\0\1\u0162\26\0\1\u0163"+
    "\62\0\1\u0164\27\0\1\u0165\45\0\1\u0166\45\0\1\u0167"+
    "\41\0\1\u0168\32\0\1\u0169\33\0\1\u016a\43\0\1\u016b"+
    "\56\0\1\u016c\23\0\1\u016d\52\0\1\u016e\25\0\1\u016f"+
    "\50\0\1\u0170\44\0\1\u0171\36\0\1\u0172\34\0\1\u0173"+
    "\42\0\1\u0174\61\0\1\u0175\40\0\1\u0176\15\0\1\u0177"+
    "\45\0\1\u0178\47\0\1\u0179\35\0\1\u017a\41\0\1\u017b"+
    "\36\0\1\u017c\36\0\1\u017d\41\0\1\u017e\47\0\1\u017f"+
    "\42\0\1\u0180\32\0\1\u0181\64\0\1\u0182\33\0\1\u0183"+
    "\31\0\1\u0184\61\0\1\u0185\40\0\1\u0186\15\0\1\u0187"+
    "\45\0\1\u0188\47\0\1\u0189\35\0\1\u018a\41\0\1\u018b"+
    "\36\0\1\u018c\36\0\1\u018d\41\0\1\u018e\47\0\1\u018f"+
    "\42\0\1\u0190\32\0\1\u0191\64\0\1\u0192\33\0\1\u0193"+
    "\27\0\1\u0194\36\0\1\u0195\41\0\1\u0196\62\0\1\u0197"+
    "\33\0\1\u0198\36\0\1\u0199\44\0\1\u019a\47\0\1\u019b"+
    "\23\0\1\u019c\42\0\1\u019d\42\0\1\u019e\37\0\1\u019f"+
    "\41\0\1\u01a0\36\0\1\u01a1\41\0\1\u01a2\62\0\1\u01a3"+
    "\33\0\1\u01a4\36\0\1\u01a5\44\0\1\u01a6\47\0\1\u01a7"+
    "\23\0\1\u01a8\42\0\1\u01a9\42\0\1\u01aa\37\0\1\u01ab"+
    "\42\0\1\u01ac\47\0\1\u01ad\32\0\1\u01ae\65\0\1\u01af"+
    "\20\0\1\u01b0\40\0\1\u01b1\42\0\1\u01b2\51\0\1\u01b3"+
    "\27\0\1\u01b4\47\0\1\u01b5\32\0\1\u01b6\65\0\1\u01b7"+
    "\20\0\1\u01b8\40\0\1\u01b9\42\0\1\u01ba\51\0\1\u01bb"+
    "\31\0\1\u01bc\37\0\1\u01bd\21\0\1\u01be\31\0\1\u01bf"+
    "\31\0\1\u01c0\44\0\1\u01c1\36\0\1\u01c2\37\0\1\u01c3"+
    "\21\0\1\u01c4\31\0\1\u01c5\31\0\1\u01c6\44\0\1\u01c7"+
    "\36\0\1\u01c8\37\0\1\u01c9\42\0\1\u01ca\42\0\1\u01cb"+
    "\37\0\1\u01cc\42\0\1\u01cd\34\0\1\u01ce\56\0\1\u01cf"+
    "\55\0\1\u01d0\10\0\1\u01d1\56\0\1\u01d2\55\0\1\u01d3"+
    "\26\0\1\u01d4\26\0\1\u01d5\54\0\1\u01d6\26\0\1\u01d7"+
    "\44\0\1\u01d8\41\0\1\u01d9\23\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[13124];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\0\1\1\1\0\1\1\1\0\1\1\1\11\2\1"+
    "\1\11\4\1\1\11\5\1\1\11\12\1\3\0\2\11"+
    "\4\1\2\0\1\1\1\11\23\0\1\11\1\1\2\0"+
    "\1\11\2\0\1\1\21\0\1\1\70\0\1\11\1\1"+
    "\4\0\1\11\30\0\1\11\6\0\1\11\30\0\1\11"+
    "\12\0\1\11\4\0\1\11\6\0\1\11\3\0\1\11"+
    "\2\0\1\1\12\0\1\11\4\0\1\11\6\0\1\11"+
    "\3\0\1\11\2\0\1\1\7\0\1\11\7\0\1\11"+
    "\10\0\1\11\10\0\1\11\7\0\1\11\10\0\1\11"+
    "\4\0\2\11\1\1\2\0\2\11\3\0\1\11\2\0"+
    "\1\11\2\0\1\11\6\0\2\11\1\1\2\0\2\11"+
    "\3\0\1\11\2\0\1\11\2\0\1\11\13\0\2\11"+
    "\3\0\1\11\2\0\1\11\7\0\2\11\3\0\1\11"+
    "\2\0\1\11\1\0\1\11\2\0\2\11\1\0\1\1"+
    "\1\11\4\0\1\11\2\0\2\11\1\0\1\1\1\11"+
    "\4\0\1\11\1\0\1\11\3\0\1\11\1\0\1\11"+
    "\1\0\1\11\3\0\1\11\1\0\1\11\2\0\2\11"+
    "\1\0\1\11\2\0\2\11\11\0\1\11\2\0\2\11"+
    "\1\0\1\11\1\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[473];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private String shortDesc = null;
    private String longDesc = null;
    private ArrayList<PHPDocTag> tagList = null;
    private int currTagId = 0;
    private int tagPosition = 0;
    private StringBuffer sBuffer = null;
    private int numOfLines = 0;
    private int startPos = 0;
	private List<Scalar> textList;

	public PHPDocBlock parse() {
		int start = zzStartRead - zzPushbackPos;
		longDesc = "";
		tagList = new ArrayList<PHPDocTag>();
		textList = new ArrayList<Scalar>();
		sBuffer = new StringBuffer();
		numOfLines = 1;

		// start parsing
		try {
			next_token();
		} catch (IOException e) {
			Logger.logException(e);
		}
		if (!tagList.isEmpty() && !textList.isEmpty()) {
			// lastText is empty if the last line only contains '*/' and white
			// spaces
			Scalar lastText = textList.get(textList.size() - 1);
			PHPDocTag lastTag = tagList.get(tagList.size() - 1);
			if (lastText.sourceEnd() >= lastTag.sourceEnd()) {
				textList.remove(textList.size() - 1);
				if (!isBlank(lastText.getValue())) {
					lastTag.getTexts().add(lastText);
				}
			}
		}

		PHPDocTag[] tags = new PHPDocTag[tagList.size()];
		tagList.toArray(tags);

		PHPDocBlock rv = new PHPDocBlock(start, zzMarkedPos - zzPushbackPos,
				shortDesc, longDesc, tags, textList);

		return rv;

	}

	private boolean isBlank(String value) {
		char[] line = value.toCharArray();
		for (int i = 0; i < line.length; i++) {
			char c = line[i];
			if (c != '\t' && c != ' ') {
				return false;
			}
		}
		return true;
	}

	private void startTagsState(int firstState) {
		updateStartPos();
		hendleDesc();
		currTagId = firstState;
		tagPosition = findTagPosition();
		sBuffer = new StringBuffer();
		yybegin(ST_IN_TAGS);
	}

	private int findTagPosition() {
		for (int i = zzStartRead; i < zzMarkedPos; i++) {
			if (zzBuffer[i] == '@') {
				return i - zzPushbackPos;
			}
		}
		return -1;
	}

	private void setNewTag(int newTag) {
		updateStartPos();
		setTagValue();

		sBuffer = new StringBuffer();
		currTagId = newTag;
		tagPosition = findTagPosition();
	}

	private void setTagValue() {
		String value = sBuffer.toString();
		// special case for backward compatibility
		if (currTagId == PHPDocTagKinds.DESC) {
			shortDesc = shortDesc + value;
			return;
		}

		PHPDocTag basicPHPDocTag = new PHPDocTag(tagPosition, zzStartRead
				- zzPushbackPos, currTagId, value, getTexts(tagPosition,
				zzStartRead, true));
		tagList.add(basicPHPDocTag);
	}

	private List<Scalar> getTexts(int start, int end, boolean remove) {
		List<Scalar> result = new ArrayList<Scalar>();
		for (Iterator iterator = textList.iterator(); iterator.hasNext();) {
			Scalar scalar = (Scalar) iterator.next();
			if (scalar.sourceStart() >= start && scalar.sourceEnd() <= end) {
				result.add(scalar);
				if (remove) {
					iterator.remove();
				}
			}
		}
		// Scalar[] texts = new Scalar[result.size()];
		// result.toArray(texts);
		return result;
	}

	private void appendText() {
		if (oldString != null) {
			sBuffer.append(oldString);
		}
		StringBuffer sb = new StringBuffer();
		sb.append(zzBuffer, startPos, zzMarkedPos - startPos);
		addText(sb.toString());
		sBuffer.append(sb);
		updateStartPos();
	}

	private void addText(String string) {
		textList.add(new Scalar(startPos, startPos + string.length(), string,
				Scalar.TYPE_STRING));
	}

    private void hendleDesc() {
        if(zzLexicalState == ST_IN_SHORT_DESC){
            shortDesc = sBuffer.toString().trim();
        }
        else{
            longDesc = sBuffer.toString().trim();
        }

        sBuffer = new StringBuffer();
    }

	private void startLongDescState(boolean withNewLine) {
		hendleDesc();
		updateStartPos();
		if (!withNewLine) {
			addText("");
		}
		yybegin(ST_IN_LONG_DESC);
	}

	private void hendleNewLine() {
		appendText();
		if (numOfLines == 4) {
			int firstLineEnd = sBuffer.indexOf("\n", 1);
			shortDesc = sBuffer.substring(0, firstLineEnd);
			shortDesc = shortDesc.trim();
			sBuffer.delete(0, firstLineEnd);
			yybegin(ST_IN_LONG_DESC);
		} else {
			numOfLines++;
		}
	}
	private void appendLastText() {
		StringBuffer sb = new StringBuffer();
		sb.append(zzBuffer, startPos, zzMarkedPos - startPos - 2);
		addText(sb.toString());
		sBuffer.append(sb);
		updateStartPos();
	}

    int maxNumberofLines = 4;

    private void handleDocEnd_shortDesc() {
        appendLastText();
        if(numOfLines==maxNumberofLines){
            int firstLineEnd = sBuffer.indexOf("\n",1);
            shortDesc = sBuffer.substring(0,firstLineEnd);
            shortDesc = shortDesc.trim();
            sBuffer.delete(0,firstLineEnd);
            longDesc = sBuffer.toString().trim();
        }
        else{
            shortDesc = sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
       appendLastText();
       longDesc = sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        appendLastText();
        setTagValue();
    }


    private void updateStartPos(){
        startPos = zzMarkedPos;
        oldString = null;
    }
    
    public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
    	this.zzReader = reader;
    	this.zzBuffer = buffer;
    	this.zzMarkedPos = parameters[0];
    	this.zzPushbackPos = parameters[1];
    	this.zzCurrentPos = parameters[2];
    	this.zzStartRead = parameters[3];
    	this.zzEndRead = parameters[4];
    	this.yyline = parameters[5];  
    }
    
    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline, zzLexicalState};
    }
    
    public char[] getBuffer(){
    	return zzBuffer;
    }
    


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DocumentorLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 142) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


    /* The following fields are added in order to support the change in zzRefill */
    
     String oldString=null;
    
 /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
	
	oldString = new String(zzBuffer, startPos, zzMarkedPos-startPos);

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      startPos = 0;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzEndReadL = zzEndRead;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 16: 
          { startTagsState(PHPDocTagKinds.TODO);
          }
        case 84: break;
        case 44: 
          { setNewTag(PHPDocTagKinds.RETURN);
          }
        case 85: break;
        case 51: 
          { startTagsState(PHPDocTagKinds.VERSION);
          }
        case 86: break;
        case 45: 
          { setNewTag(PHPDocTagKinds.GLOBAL);
          }
        case 87: break;
        case 68: 
          { startTagsState(PHPDocTagKinds.NAMESPACE);
          }
        case 88: break;
        case 73: 
          { startTagsState(PHPDocTagKinds.DEPRECATED);
          }
        case 89: break;
        case 32: 
          { startTagsState(PHPDocTagKinds.ACCESS);
          }
        case 90: break;
        case 13: 
          { startTagsState(PHPDocTagKinds.VAR);
          }
        case 91: break;
        case 70: 
          { setNewTag(PHPDocTagKinds.COPYRIGHT);
          }
        case 92: break;
        case 15: 
          { setNewTag(PHPDocTagKinds.VAR);
          }
        case 93: break;
        case 42: 
          { setNewTag(PHPDocTagKinds.STATIC);
          }
        case 94: break;
        case 59: 
          { startTagsState(PHPDocTagKinds.PROPERTY);
          }
        case 95: break;
        case 18: 
          { startTagsState(PHPDocTagKinds.DESC);
          }
        case 96: break;
        case 63: 
          { setNewTag(PHPDocTagKinds.CATEGORY);
          }
        case 97: break;
        case 12: 
          { startTagsState(PHPDocTagKinds.SEE);
          }
        case 98: break;
        case 14: 
          { setNewTag(PHPDocTagKinds.SEE);
          }
        case 99: break;
        case 50: 
          { startTagsState(PHPDocTagKinds.LICENSE);
          }
        case 100: break;
        case 21: 
          { setNewTag(PHPDocTagKinds.TODO);
          }
        case 101: break;
        case 43: 
          { setNewTag(PHPDocTagKinds.THROWS);
          }
        case 102: break;
        case 65: 
          { setNewTag(PHPDocTagKinds.INTERNAL);
          }
        case 103: break;
        case 20: 
          { startTagsState(PHPDocTagKinds.NAME);
          }
        case 104: break;
        case 19: 
          { startTagsState(PHPDocTagKinds.LINK);
          }
        case 105: break;
        case 17: 
          { startTagsState(PHPDocTagKinds.USES);
          }
        case 106: break;
        case 23: 
          { setNewTag(PHPDocTagKinds.DESC);
          }
        case 107: break;
        case 52: 
          { setNewTag(PHPDocTagKinds.EXAMPLE);
          }
        case 108: break;
        case 9: 
          { handleDocEnd_longDesc();return -1;
          }
        case 109: break;
        case 29: 
          { setNewTag(PHPDocTagKinds.SINCE);
          }
        case 110: break;
        case 31: 
          { setNewTag(PHPDocTagKinds.FINAL);
          }
        case 111: break;
        case 83: 
          { setNewTag(PHPDocTagKinds.PROPERTY_WRITE);
          }
        case 112: break;
        case 47: 
          { setNewTag(PHPDocTagKinds.METHOD);
          }
        case 113: break;
        case 55: 
          { setNewTag(PHPDocTagKinds.VERSION);
          }
        case 114: break;
        case 38: 
          { startTagsState(PHPDocTagKinds.IGNORE);
          }
        case 115: break;
        case 67: 
          { startTagsState(PHPDocTagKinds.COPYRIGHT);
          }
        case 116: break;
        case 36: 
          { startTagsState(PHPDocTagKinds.RETURN);
          }
        case 117: break;
        case 69: 
          { setNewTag(PHPDocTagKinds.STATICVAR);
          }
        case 118: break;
        case 58: 
          { startTagsState(PHPDocTagKinds.CATEGORY);
          }
        case 119: break;
        case 82: 
          { startTagsState(PHPDocTagKinds.PROPERTY_WRITE);
          }
        case 120: break;
        case 49: 
          { startTagsState(PHPDocTagKinds.PACKAGE);
          }
        case 121: break;
        case 37: 
          { startTagsState(PHPDocTagKinds.GLOBAL);
          }
        case 122: break;
        case 25: 
          { setNewTag(PHPDocTagKinds.NAME);
          }
        case 123: break;
        case 26: 
          { startTagsState(PHPDocTagKinds.SINCE);
          }
        case 124: break;
        case 24: 
          { setNewTag(PHPDocTagKinds.LINK);
          }
        case 125: break;
        case 41: 
          { setNewTag(PHPDocTagKinds.AUTHOR);
          }
        case 126: break;
        case 22: 
          { setNewTag(PHPDocTagKinds.USES);
          }
        case 127: break;
        case 60: 
          { startTagsState(PHPDocTagKinds.INTERNAL);
          }
        case 128: break;
        case 77: 
          { setNewTag(PHPDocTagKinds.FILESOURCE);
          }
        case 129: break;
        case 61: 
          { setNewTag(PHPDocTagKinds.ABSTRACT);
          }
        case 130: break;
        case 62: 
          { setNewTag(PHPDocTagKinds.TUTORIAL);
          }
        case 131: break;
        case 54: 
          { setNewTag(PHPDocTagKinds.LICENSE);
          }
        case 132: break;
        case 11: 
          { updateStartPos();
        yybegin(ST_IN_SHORT_DESC);
          }
        case 133: break;
        case 30: 
          { setNewTag(PHPDocTagKinds.PARAM);
          }
        case 134: break;
        case 3: 
          { hendleNewLine();
          }
        case 135: break;
        case 1: 
          { updateStartPos();
          }
        case 136: break;
        case 28: 
          { startTagsState(PHPDocTagKinds.FINAL);
          }
        case 137: break;
        case 79: 
          { setNewTag(PHPDocTagKinds.INHERITDOC);
          }
        case 138: break;
        case 35: 
          { startTagsState(PHPDocTagKinds.THROWS);
          }
        case 139: break;
        case 40: 
          { setNewTag(PHPDocTagKinds.ACCESS);
          }
        case 140: break;
        case 6: 
          { appendText();
    startLongDescState(true);
          }
        case 141: break;
        case 34: 
          { startTagsState(PHPDocTagKinds.STATIC);
          }
        case 142: break;
        case 71: 
          { setNewTag(PHPDocTagKinds.NAMESPACE);
          }
        case 143: break;
        case 4: 
          { startLongDescState(false);
          }
        case 144: break;
        case 75: 
          { setNewTag(PHPDocTagKinds.SUBPACKAGE);
          }
        case 145: break;
        case 5: 
          { appendText();
          }
        case 146: break;
        case 81: 
          { setNewTag(PHPDocTagKinds.PROPERTY_READ);
          }
        case 147: break;
        case 66: 
          { startTagsState(PHPDocTagKinds.STATICVAR);
          }
        case 148: break;
        case 39: 
          { startTagsState(PHPDocTagKinds.METHOD);
          }
        case 149: break;
        case 27: 
          { startTagsState(PHPDocTagKinds.PARAM);
          }
        case 150: break;
        case 53: 
          { setNewTag(PHPDocTagKinds.PACKAGE);
          }
        case 151: break;
        case 56: 
          { startTagsState(PHPDocTagKinds.ABSTRACT);
          }
        case 152: break;
        case 57: 
          { startTagsState(PHPDocTagKinds.TUTORIAL);
          }
        case 153: break;
        case 76: 
          { setNewTag(PHPDocTagKinds.DEPRECATED);
          }
        case 154: break;
        case 74: 
          { startTagsState(PHPDocTagKinds.FILESOURCE);
          }
        case 155: break;
        case 33: 
          { startTagsState(PHPDocTagKinds.AUTHOR);
          }
        case 156: break;
        case 80: 
          { startTagsState(PHPDocTagKinds.PROPERTY_READ);
          }
        case 157: break;
        case 78: 
          { startTagsState(PHPDocTagKinds.INHERITDOC);
          }
        case 158: break;
        case 7: 
          { maxNumberofLines = 4;
    handleDocEnd_shortDesc();
    return -1;
          }
        case 159: break;
        case 46: 
          { setNewTag(PHPDocTagKinds.IGNORE);
          }
        case 160: break;
        case 64: 
          { setNewTag(PHPDocTagKinds.PROPERTY);
          }
        case 161: break;
        case 10: 
          { handleDocEnd_inTags();return -1;
          }
        case 162: break;
        case 72: 
          { startTagsState(PHPDocTagKinds.SUBPACKAGE);
          }
        case 163: break;
        case 48: 
          { startTagsState(PHPDocTagKinds.EXAMPLE);
          }
        case 164: break;
        case 2: 
          { 
          }
        case 165: break;
        case 8: 
          { maxNumberofLines = 5;
    handleDocEnd_shortDesc();
    return -1;
          }
        case 166: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        try {
          scanner = new DocumentorLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
