/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.actions.OpenActionUtil;
import org.eclipse.dltk.internal.ui.browsing.LogicalPackage;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.Messages;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.IUpdate;

public class OpenTypeHierarchyAction
extends SelectionDispatchAction
implements IUpdate {
    private PHPStructuredEditor fEditor;
    private IModelElement lastSelectedElement;

    public OpenTypeHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(Messages.OpenTypeHierarchyAction_0);
        this.setToolTipText(Messages.OpenTypeHierarchyAction_0);
        this.setDescription(Messages.OpenTypeHierarchyAction_0);
    }

    public OpenTypeHierarchyAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(final ITextSelection selection) {
        IJobManager jobManager = Job.getJobManager();
        if (jobManager.find((Object)PHPUiPlugin.OPEN_TYPE_HIERARCHY_ACTION_FAMILY_NAME).length > 0) {
            jobManager.cancel((Object)PHPUiPlugin.OPEN_TYPE_HIERARCHY_ACTION_FAMILY_NAME);
        }
        Job job = new Job(PHPUiPlugin.OPEN_TYPE_HIERARCHY_ACTION_FAMILY_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                OpenTypeHierarchyAction.this.setEnabled(OpenTypeHierarchyAction.this.isEnabled(selection));
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return this.getName().equals(family);
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        job.schedule();
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection == null || selection.size() != 1) {
            this.setEnabled(false);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else if (selection instanceof ITreeSelection) {
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IMethod) {
                this.setEnabled(((IMethod)firstElement).getParent() instanceof IType);
            } else {
                this.setEnabled(firstElement instanceof IType || firstElement instanceof IField);
            }
        }
    }

    private boolean isEnabled(ITextSelection selection) {
        if (this.fEditor == null || selection == null) {
            return false;
        }
        if (this.fEditor.getModelElement() instanceof ISourceModule) {
            ISourceModule sourceModule = (ISourceModule)this.fEditor.getModelElement();
            IModelElement element = this.getSelectionModelElement(selection.getOffset(), selection.getLength(), sourceModule);
            if (element == null) {
                this.lastSelectedElement = null;
                return false;
            }
            switch (element.getElementType()) {
                case 5: 
                case 7: 
                case 8: 
                case 9: {
                    this.lastSelectedElement = element;
                    return true;
                }
            }
        }
        this.lastSelectedElement = null;
        return false;
    }

    protected IModelElement getSelectionModelElement(int offset, int length, ISourceModule sourceModule) {
        IModelElement element = null;
        try {
            IBinding binding;
            ASTNode selectedNode;
            Program ast = SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_NO, null);
            if (ast != null && (selectedNode = NodeFinder.perform((ASTNode)ast, (int)offset, (int)length)) != null && selectedNode.getType() == 33 && (binding = ((Identifier)selectedNode).resolveBinding()) != null) {
                element = binding.getPHPElement();
            }
        }
        catch (Exception exception) {}
        if (element == null) {
            try {
                IModelElement[] selected = sourceModule.codeSelect(offset, 1);
                if (selected.length > 0) {
                    element = selected[0];
                }
            }
            catch (ModelException modelException) {}
        }
        return element;
    }

    public void run(ITextSelection selection) {
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)true);
        if (input == null || !ActionUtil.isProcessable((Shell)this.getShell(), (Object)input) || !(input instanceof ISourceModule)) {
            return;
        }
        IModelElement selectionModelElement = this.getSelectionModelElement(selection.getOffset(), selection.getLength(), input);
        this.run(new IModelElement[]{selectionModelElement});
    }

    public void run(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            if (selection.size() != 1) {
                return;
            }
            Object input = selection.getFirstElement();
            if (input instanceof LogicalPackage) {
                IScriptFolder[] fragments = ((LogicalPackage)input).getFragments();
                if (fragments.length == 0) {
                    return;
                }
                input = fragments[0];
            }
            if (!(input instanceof IModelElement)) {
                IStatus status = OpenTypeHierarchyAction.createStatus(Messages.OpenTypeHierarchyAction_3);
                ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)"", (IStatus)status);
                return;
            }
            IModelElement element = (IModelElement)input;
            if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)element)) {
                return;
            }
            ArrayList result = new ArrayList(1);
            IStatus status = OpenTypeHierarchyAction.compileCandidates(result, element);
            if (status.isOK()) {
                this.run(result.toArray(new IModelElement[result.size()]));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)OpenTypeHierarchyAction.getDialogTitle(), (String)"", (IStatus)status);
            }
        }
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        OpenTypeHierarchyAction.open(elements, this.getSite().getWorkbenchWindow());
    }

    public static TypeHierarchyViewPart open(IModelElement[] candidates, IWorkbenchWindow window) {
        Assert.isNotNull((Object)candidates);
        Assert.isTrue((candidates.length != 0 ? 1 : 0) != 0);
        IModelElement input = null;
        if (candidates.length > 1) {
            String title = "";
            String message = "";
            input = OpenActionUtil.selectModelElement((IModelElement[])candidates, (Shell)window.getShell(), (String)title, (String)message);
        } else {
            input = candidates[0];
        }
        if (input == null) {
            return null;
        }
        return OpenTypeHierarchyAction.openInViewPart(window, input);
    }

    private static TypeHierarchyViewPart openInViewPart(IWorkbenchWindow window, IModelElement input) {
        IWorkbenchPage page = window.getActivePage();
        try {
            TypeHierarchyViewPart result = (TypeHierarchyViewPart)page.findView("org.eclipse.dltk.ui.TypeHierarchy");
            if (result != null) {
                result.clearNeededRefresh();
            }
            result = (TypeHierarchyViewPart)page.showView("org.eclipse.dltk.ui.TypeHierarchy");
            result.setInputElement(input);
            return result;
        }
        catch (CoreException e) {
            ExceptionHandler.handle((CoreException)e, (Shell)window.getShell(), (String)"", (String)e.getMessage());
            return null;
        }
    }

    private static String getDialogTitle() {
        return "";
    }

    private static IStatus createStatus(String message) {
        return new Status(1, PHPUiPlugin.getPluginId(), 10001, message, null);
    }

    public void update() {
        this.setEnabled(this.fEditor != null);
    }

    protected ITextSelection getCurrentSelection() {
        if (this.fEditor == null) {
            return null;
        }
        ISelectionProvider provider = this.fEditor.getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection selection = provider.getSelection();
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    private static IStatus compileCandidates(List result, IModelElement elem) {
        Status ok = new Status(0, PHPUiPlugin.getPluginId(), 0, "", null);
        try {
            switch (elem.getElementType()) {
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    result.add(elem);
                    return ok;
                }
                case 4: {
                    if (((IScriptFolder)elem).containsScriptResources()) {
                        result.add(elem);
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus("");
                }
                case 10: {
                    result.add(elem.getAncestor(4));
                    return ok;
                }
                case 5: {
                    AbstractSourceModule cu = (AbstractSourceModule)elem;
                    IType[] types = cu.getTypes();
                    if (types.length > 0) {
                        result.addAll(Arrays.asList(types));
                        return ok;
                    }
                    return OpenTypeHierarchyAction.createStatus("");
                }
            }
        }
        catch (ModelException e) {
            return e.getStatus();
        }
        return OpenTypeHierarchyAction.createStatus("");
    }
}

