/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.php.internal.ui.editor.hover.PHPSourceViewerInformationControl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;

public class PHPStructuredTextProjectionAnnotationHover
extends StructuredTextAnnotationHover
implements IAnnotationHoverExtension {
    private IInformationControlCreator fInformationControlCreator;

    public boolean canHandleMouseCursor() {
        return false;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInformationControlCreator == null) {
            this.fInformationControlCreator = new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new PHPSourceViewerInformationControl(parent);
                }
            };
        }
        return this.fInformationControlCreator;
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleLines) {
        return this.getProjectionTextAtLine(sourceViewer, lineRange.getStartLine(), visibleLines);
    }

    private String getProjectionTextAtLine(ISourceViewer viewer, int line, int visibleLines) {
        ISourceViewerExtension2 viewerExtension;
        IAnnotationModel visual;
        IAnnotationModel model = null;
        if (viewer instanceof ISourceViewerExtension2 && (visual = (viewerExtension = (ISourceViewerExtension2)viewer).getVisualAnnotationModel()) instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension modelExtension = (IAnnotationModelExtension)visual;
            model = modelExtension.getAnnotationModel(ProjectionSupport.PROJECTION);
        }
        if (model != null) {
            try {
                IDocument document = viewer.getDocument();
                Iterator e = model.getAnnotationIterator();
                while (e.hasNext()) {
                    Position position;
                    ProjectionAnnotation annotation = (ProjectionAnnotation)e.next();
                    if (!annotation.isCollapsed() || (position = model.getPosition((Annotation)annotation)) == null || !this.isCaptionLine(annotation, position, document, line)) continue;
                    return this.getText(document, position.getOffset(), position.getLength(), visibleLines);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private String getText(IDocument document, int offset, int length, int numberOfLines) throws BadLocationException {
        int endOffset = offset + length;
        try {
            int endLine = document.getLineOfOffset(offset) + Math.max(0, numberOfLines - 1);
            IRegion lineInfo = document.getLineInformation(endLine);
            endOffset = Math.min(endOffset, lineInfo.getOffset() + lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return document.get(offset, endOffset - offset);
    }

    private boolean isCaptionLine(ProjectionAnnotation annotation, Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int captionOffset = position instanceof IProjectionPosition ? ((IProjectionPosition)position).computeCaptionOffset(document) : 0;
                int startLine = document.getLineOfOffset(position.getOffset() + captionOffset);
                return line == startLine;
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }
}

