/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.templates.IScriptTemplateIndenter;
import org.eclipse.dltk.ui.templates.ScriptTemplateContext;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpTemplateContext
extends ScriptTemplateContext {
    private static final String DOLLAR = "dollar";
    private static final String DOLLAR_SIGN = "$";
    public static final char BLANK = ' ';
    public static final char TAB = '\t';
    private String fLineDelimiter;

    public PhpTemplateContext(ScriptTemplateContextType phpTemplateContextType, IDocument document, int offset, int length, ISourceModule sourceModule) {
        super((TemplateContextType)phpTemplateContextType, document, offset, length, sourceModule);
    }

    public PhpTemplateContext(ScriptTemplateContextType phpTemplateContextType, IDocument document, Position position, ISourceModule sourceModule) {
        super((TemplateContextType)phpTemplateContextType, document, position, sourceModule);
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        boolean useTab = this.getPreferences().getBoolean("org.eclipse.php.core", "org.eclipse.php.core.phpForamtterUseTabs");
        if (!useTab) {
            String lengthString = this.getPreferences().getString("org.eclipse.php.core", "org.eclipse.php.core.phpForamtterIndentationSize");
            int length = FormatPreferencesSupport.getInstance().getIndentationSize(null);
            if (lengthString != null && lengthString.trim().length() != 0) {
                try {
                    length = Integer.parseInt(lengthString);
                }
                catch (Exception exception) {}
            }
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length) {
                sb.append(" ");
                ++i;
            }
            String newPattern = TextUtils.replace((String)template.getPattern(), (char)'\t', (String)sb.toString());
            template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), newPattern, template.isAutoInsertable());
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        String[] lines = TextUtils.splitLines((CharSequence)template.getPattern());
        if (lines.length > 1) {
            String delimeter = this.fLineDelimiter == null ? TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()) : this.fLineDelimiter;
            String indent = PhpTemplateContext.calculateIndent((IDocument)this.getDocument(), (int)this.getStart());
            IScriptTemplateIndenter indenter = this.getIndenter();
            StringBuffer buffer = new StringBuffer(lines[0]);
            int i = 1;
            while (i < lines.length) {
                buffer.append(delimeter);
                indenter.indentLine(buffer, indent, lines[i]);
                ++i;
            }
            template = new Template(template.getName(), template.getDescription(), template.getContextTypeId(), buffer.toString(), template.isAutoInsertable());
        }
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        TemplateBuffer result = buffer;
        TemplateVariable[] variables = result.getVariables();
        TemplateVariable dollarVariable = null;
        ArrayList<TemplateVariable> nonDollarVariables = new ArrayList<TemplateVariable>();
        int i = 0;
        while (i < variables.length) {
            if (this.isDollar(variables[i])) {
                dollarVariable = variables[i];
            } else {
                nonDollarVariables.add(variables[i]);
            }
            ++i;
        }
        ArrayList<TemplateVariable> templateVariables = new ArrayList<TemplateVariable>();
        if (dollarVariable != null) {
            HashSet<Integer> dollarOffsetSet = new HashSet<Integer>();
            int i2 = 0;
            while (i2 < dollarVariable.getOffsets().length) {
                dollarOffsetSet.add(dollarVariable.getOffsets()[i2]);
                ++i2;
            }
            for (TemplateVariable templateVariable : nonDollarVariables) {
                if (templateVariable.getOffsets().length > 0 && this.isbehind(templateVariable, dollarOffsetSet)) {
                    String name;
                    int[] offsets = new int[templateVariable.getOffsets().length];
                    int i3 = 0;
                    while (i3 < templateVariable.getOffsets().length) {
                        dollarOffsetSet.remove(templateVariable.getOffsets()[i3] - 1);
                        offsets[i3] = templateVariable.getOffsets()[i3] - 1;
                        ++i3;
                    }
                    String defaultValue = name = DOLLAR_SIGN + templateVariable.getName();
                    if (templateVariable.getDefaultValue() != null) {
                        defaultValue = DOLLAR_SIGN + templateVariable.getDefaultValue();
                    }
                    templateVariable = new TemplateVariable(templateVariable.getVariableType(), name, defaultValue, offsets);
                }
                templateVariables.add(templateVariable);
            }
            if (!dollarOffsetSet.isEmpty()) {
                templateVariables.add(dollarVariable);
            }
            result.setContent(result.getString(), templateVariables.toArray(new TemplateVariable[templateVariables.size()]));
        }
        return result;
    }

    private boolean isbehind(TemplateVariable templateVariable, Set<Integer> dollarOffsetSet) {
        int i = 0;
        while (i < templateVariable.getOffsets().length) {
            if (!dollarOffsetSet.contains(templateVariable.getOffsets()[i] - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isDollar(TemplateVariable templateVariable) {
        return templateVariable.isUnambiguous() && DOLLAR.equals(templateVariable.getType());
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.fLineDelimiter = lineDelimiter;
    }
}

