/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.scanner.AstLexer;
import org.eclipse.php.internal.core.ast.scanner.php5.PhpAstLexer;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class CommentMapperTests
extends TestCase {
    public CommentMapperTests(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(CommentMapperTests.class);
    }

    public void testVariable() throws Exception {
        String str = "<?php \r\n// comment of $a\r\n$a; ?>";
        this.parseAndCompare(str);
    }

    public void testVariableTwoComments() throws Exception {
        String str = "<?php \r\n// comment of $a\r\n// comment of $a\r\n$a; ?>";
        this.parseAndCompare(str);
    }

    public void testVariableMultiple() throws Exception {
        String str = "<?php \r\n/** \r\ncomment of $a */\r\n$a; ?>";
        this.parseAndCompare(str);
    }

    public void testFunction() throws Exception {
        String str = "<?php \r\n// comment of foo()\r\nfunction foo() {\r\n   }; ?>";
        this.parseAndCompare(str);
    }

    public void testClass() throws Exception {
        String str = "<?php \r\n// comment of A\r\nclass A {\r\n}; ?>";
        this.parseAndCompare(str);
    }

    public void testMethod() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of method foo()\r\n public function foo() {  }  \r\n} ?>";
        this.parseAndCompareInner(str, 0);
    }

    public void testField() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of field $a \r\n public $a = 5;\r\n } ?>";
        this.parseAndCompareInner(str, 0);
    }

    public void testMethodSecond() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of method foo()\r\n public function foo() {  }  \r\n \r\n // comment of method bar()\r\n public function bar() {  } \r\n } ?>";
        this.parseAndCompareInner(str, 1);
    }

    public void testFieldSecond() throws Exception {
        String str = "<?php \r\n class A {\r\n // comment of field $a \r\n public $a = 5;\r\n \r\n/** \r\n * comment of field $a */ \r\n public $b = 5;\r\n } ?>";
        this.parseAndCompareInner(str, 1);
    }

    public void parseAndCompare(String programStr) throws Exception {
        Document document = new Document(programStr);
        StringReader reader = new StringReader(programStr);
        Program program = ASTParser.newParser((Reader)reader, (PHPVersion)PHPVersion.PHP5, (boolean)ProjectOptions.useShortTags(null)).createAST((IProgressMonitor)new NullProgressMonitor());
        program.initCommentMapper((IDocument)document, (AstLexer)new PhpAstLexer((Reader)reader));
        Statement node = (Statement)program.statements().get(0);
        int extendedLength = program.getExtendedLength((ASTNode)node);
        assert (extendedLength > node.getLength());
    }

    public void parseAndCompareInner(String programStr, int index) throws Exception {
        Document document = new Document(programStr);
        StringReader reader = new StringReader(programStr);
        Program program = ASTParser.newParser((Reader)reader, (PHPVersion)PHPVersion.PHP5, (boolean)ProjectOptions.useShortTags(null)).createAST((IProgressMonitor)new NullProgressMonitor());
        program.initCommentMapper((IDocument)document, (AstLexer)new PhpAstLexer((Reader)reader));
        ClassDeclaration node = (ClassDeclaration)program.statements().get(0);
        Statement statement = (Statement)node.getBody().statements().get(index);
        int extendedLength = program.getExtendedLength((ASTNode)statement);
        assert (extendedLength > statement.getLength());
    }
}

