/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.communication;

import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.handlers.IDebugRequestHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.core.util.BlockingQueue;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.launching.PHPProcess;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationAdministrator;
import org.eclipse.php.internal.debug.core.zend.communication.CommunicationClient;
import org.eclipse.php.internal.debug.core.zend.communication.ResponseHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugMessagesRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugMessageImpl;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionStartedNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.OutputNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartRequest;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestController;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugConnectionThread
implements Runnable {
    protected static int startMessageId = new DebugSessionStartedNotification().getType();
    private Socket socket;
    private DataInputStream connectionIn;
    private DataOutputStream connectionOut;
    protected boolean validProtocol;
    private boolean isInitialized;
    private InputMessageHandler inputMessageHandler;
    private CommunicationClient communicationClient;
    private CommunicationAdministrator administrator;
    private IDebugMessage CONNECTION_CLOSED_MSG = new DummyDebugMessage();
    private IntHashtable requestsTable;
    private IntHashtable responseTable;
    private Hashtable<Integer, ResponseHandler> responseHandlers;
    private InputManager inputManager;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private DataOutputStream dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
    private int lastRequestID = 1000;
    protected int debugResponseTimeout;
    protected PHPDebugTarget debugTarget;
    private Thread theThread;
    private Map<Integer, IDebugMessageHandler> messageHandlers;

    public DebugConnectionThread(Socket socket) {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        this.debugResponseTimeout = prefs.getInt(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT);
        this.socket = socket;
        this.requestsTable = new IntHashtable();
        this.responseTable = new IntHashtable();
        this.responseHandlers = new Hashtable();
        this.messageHandlers = new HashMap<Integer, IDebugMessageHandler>();
        this.theThread = new Thread((Runnable)this, "PHP Debug Conection");
        this.theThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.socket.setTcpNoDelay(true);
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
            DataInputStream dataInputStream = in;
            synchronized (dataInputStream) {
                this.connectionIn = in;
                this.connectionOut = out;
                this.restartInputMessageHandler(out);
                this.restartInputManager(in);
                this.isInitialized = true;
            }
        }
        catch (Exception exc) {
            PHPDebugPlugin.log(exc);
        }
    }

    public void setCommunicationClient(CommunicationClient client) {
        this.communicationClient = client;
    }

    public CommunicationClient getCommunicationClient() {
        return this.communicationClient;
    }

    public void setCommunicationAdministrator(CommunicationAdministrator admin) {
        this.administrator = admin;
    }

    public CommunicationAdministrator getCommunicationAdministrator() {
        return this.administrator;
    }

    private IDebugMessageHandler createMessageHandler(IDebugMessage message) {
        if (!this.messageHandlers.containsKey(message.getType())) {
            IDebugMessageHandler requestHandler = DebugMessagesRegistry.getHandler(message);
            this.messageHandlers.put(message.getType(), requestHandler);
        }
        return this.messageHandlers.get(message.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNotification(Object msg) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.byteArrayOutputStream;
            synchronized (byteArrayOutputStream) {
                this.byteArrayOutputStream.reset();
                ((IDebugMessage)msg).serialize(this.dataOutputStream);
                DataOutputStream dataOutputStream = this.connectionOut;
                synchronized (dataOutputStream) {
                    this.connectionOut.writeInt(this.byteArrayOutputStream.size());
                    this.byteArrayOutputStream.writeTo(this.connectionOut);
                    this.connectionOut.flush();
                }
            }
        }
        catch (SocketException se) {
            if (PHPDebugPlugin.DEBUG) {
                Logger.log(2, se.getMessage(), se);
            }
        }
        catch (Exception exc) {
            PHPDebugPlugin.log(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendRequest(Object request) throws Exception {
        if (PHPDebugPlugin.DEBUG) {
            System.out.println("Sending syncrhonic request: " + request);
        }
        try {
            IDebugRequestMessage theMsg = (IDebugRequestMessage)request;
            ByteArrayOutputStream byteArrayOutputStream = this.byteArrayOutputStream;
            synchronized (byteArrayOutputStream) {
                this.byteArrayOutputStream.reset();
                theMsg.setID(this.lastRequestID++);
                theMsg.serialize(this.dataOutputStream);
                int messageSize = this.byteArrayOutputStream.size();
                DataOutputStream dataOutputStream = this.connectionOut;
                synchronized (dataOutputStream) {
                    this.requestsTable.put(theMsg.getID(), (Object)theMsg);
                    this.connectionOut.writeInt(messageSize);
                    this.byteArrayOutputStream.writeTo(this.connectionOut);
                    this.connectionOut.flush();
                }
            }
            IDebugResponseMessage response = null;
            int timeoutTick = 500;
            int waitedTime = 0;
            while (response == null && this.isConnected()) {
                Object object = request;
                synchronized (object) {
                    response = (IDebugResponseMessage)this.responseTable.remove(theMsg.getID());
                    if (response == null) {
                        if (PHPDebugPlugin.DEBUG) {
                            System.out.println("Response is null. Waiting " + waitedTime + " milliseconds");
                        }
                        if (waitedTime > this.debugResponseTimeout / 4) {
                            PHPLaunchUtilities.showWaitForDebuggerMessage(this);
                        }
                        request.wait(timeoutTick);
                    }
                }
                if (response == null) {
                    response = (IDebugResponseMessage)this.responseTable.remove(theMsg.getID());
                }
                if (response != null || !this.isConnected()) continue;
                if (PHPDebugPlugin.DEBUG) {
                    System.out.println("Communication problems (response is null)");
                }
                if (waitedTime < this.debugResponseTimeout - timeoutTick) {
                    waitedTime += timeoutTick;
                    this.handlePeerResponseTimeout();
                } else {
                    this.closeConnection();
                    PHPLaunchUtilities.hideWaitForDebuggerMessage();
                    PHPLaunchUtilities.showLaunchErrorMessage();
                }
                if (!this.isConnected()) break;
            }
            PHPLaunchUtilities.hideWaitForDebuggerMessage();
            if (PHPDebugPlugin.DEBUG) {
                System.out.println("Received response: " + response);
            }
            return response;
        }
        catch (IOException e) {
            PHPDebugPlugin.log(e);
        }
        catch (InterruptedException e) {
            PHPDebugPlugin.log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(Object request, ResponseHandler responseHandler) {
        if (PHPDebugPlugin.DEBUG) {
            System.out.println("Sending asynchronic request: " + request);
        }
        int msgId = this.lastRequestID++;
        IDebugRequestMessage theMsg = (IDebugRequestMessage)request;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            theMsg.setID(msgId);
            theMsg.serialize(dataOutputStream);
            int messageSize = byteArrayOutputStream.size();
            DataOutputStream dataOutputStream2 = this.connectionOut;
            synchronized (dataOutputStream2) {
                this.requestsTable.put(msgId, request);
                this.responseHandlers.put(new Integer(msgId), responseHandler);
                this.connectionOut.writeInt(messageSize);
                byteArrayOutputStream.writeTo(this.connectionOut);
                this.connectionOut.flush();
            }
        }
        catch (Exception exc) {
            System.out.println("Exception for request no." + theMsg.getType() + exc.toString());
            responseHandler.handleResponse(request, null);
            this.responseHandlers.remove(new Integer(msgId));
        }
    }

    public boolean isConnected() {
        if (this.connectionIn != null) {
            try {
                this.connectionIn.available();
                return true;
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    public synchronized void closeConnection() {
        Logger.debugMSG("DebugConnectionThread: Clean socket");
        this.cleanSocket();
        if (this.theThread.isAlive()) {
            Logger.debugMSG("DebugConnectionThread: Thread interrupt");
            this.theThread.interrupt();
        }
        if (this.socket != null) {
            try {
                if (!this.socket.isClosed()) {
                    Logger.debugMSG("DebugConnectionThread: closing the socket");
                    this.socket.close();
                }
            }
            catch (Exception exc) {
                PHPDebugPlugin.log(exc);
            }
            this.socket = null;
        }
    }

    protected void restartInputMessageHandler(DataOutputStream out) {
        if (this.inputMessageHandler == null) {
            this.inputMessageHandler = new InputMessageHandler(out);
            this.inputMessageHandler.start();
        } else {
            this.inputMessageHandler.waitForStart(out, true);
        }
    }

    protected void restartInputManager(DataInputStream in) {
        try {
            if (this.inputManager == null) {
                this.inputManager = new InputManager(in);
                this.inputManager.start();
            } else {
                this.inputManager.waitForStart(in);
            }
        }
        catch (Exception exc) {
            PHPDebugPlugin.log(exc);
        }
    }

    protected short getMessageType(DataInputStream in) throws IOException {
        return in.readShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanSocket() {
        DataOutputStream dataOutputStream;
        if (!this.isInitialized) {
            return;
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (Exception exception) {}
            try {
                this.socket.shutdownOutput();
            }
            catch (Exception exception) {}
        }
        if (this.connectionOut != null) {
            try {
                dataOutputStream = this.connectionOut;
                synchronized (dataOutputStream) {
                    this.connectionOut.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
        if (this.connectionIn != null) {
            try {
                this.connectionIn.close();
            }
            catch (Exception exception) {}
        }
        this.socket = null;
        this.connectionIn = null;
        if (this.connectionOut != null) {
            dataOutputStream = this.connectionOut;
            synchronized (dataOutputStream) {
                this.connectionOut = null;
            }
        }
    }

    private void handlePeerResponseTimeout() {
        this.getCommunicationClient().handlePeerResponseTimeout();
    }

    protected int getSessionID(String query) {
        int indx = query.lastIndexOf("debug_session_id=");
        if (indx < 0) {
            return -1;
        }
        indx += "debug_session_id".length() + 1;
        if ((indx = (query = query.substring(indx)).indexOf(38)) > -1) {
            return Integer.parseInt(query.substring(0, indx));
        }
        return Integer.parseInt(query.trim());
    }

    public boolean hookDebugSession(DebugSessionStartedNotification debugSessionStartedNotification) throws CoreException {
        int n;
        ILaunch launch;
        String query = debugSessionStartedNotification.getQuery();
        int sessionID = this.getSessionID(query);
        if (sessionID == 0) {
            sessionID = this.getSessionID(debugSessionStartedNotification.getOptions());
        }
        if ((launch = PHPSessionLaunchMapper.get(sessionID)) == null) {
            ILaunch[] launchs;
            ILaunch[] iLaunchArray = launchs = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            n = launchs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch aLaunch = iLaunchArray[n2];
                String debugType = aLaunch.getAttribute("debugPages");
                if (aLaunch.isTerminated() && ("debugAllPages".equals(debugType) || "debugFrom".equals(debugType))) {
                    launch = aLaunch;
                    break;
                }
                ++n2;
            }
        }
        if (launch != null) {
            IDebugTarget[] debugTargets = launch.getDebugTargets();
            IProcess[] processes = launch.getProcesses();
            IDebugTarget[] iDebugTargetArray = debugTargets;
            int n3 = debugTargets.length;
            n = 0;
            while (n < n3) {
                IDebugTarget element = iDebugTargetArray[n];
                if (!element.isTerminated()) {
                    return true;
                }
                launch.removeDebugTarget(element);
                ++n;
            }
            iDebugTargetArray = processes;
            n3 = processes.length;
            n = 0;
            while (n < n3) {
                IDebugTarget element = iDebugTargetArray[n];
                if (element.isTerminated()) {
                    launch.removeProcess((IProcess)element);
                }
                ++n;
            }
            if (Boolean.toString(true).equals(launch.getAttribute("webServerDebugger"))) {
                this.hookServerDebug(launch, debugSessionStartedNotification);
            } else {
                this.hookPHPExeDebug(launch, debugSessionStartedNotification);
            }
            return true;
        }
        return this.handleHookError("No session id");
    }

    protected boolean handleHookError(Object cause) {
        if (cause != null) {
            Logger.log(4, cause.toString());
        } else {
            Logger.log(4, "Debug hook error");
        }
        return false;
    }

    protected void hookServerDebug(final ILaunch launch, DebugSessionStartedNotification startedNotification) throws CoreException {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        IProject project = this.getProject(launchConfiguration);
        this.inputManager.setTransferEncoding(launchConfiguration.getAttribute("debugTransferEncoding", ""));
        this.inputManager.setOutputEncoding(launchConfiguration.getAttribute("debugOutputEncoding", ""));
        String URL2 = this.getURL(launchConfiguration);
        boolean stopAtFirstLine = project == null ? true : PHPProjectPreferences.getStopAtFirstLine(project);
        int requestPort = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
        boolean runWithDebug = launchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (launch.getLaunchMode().equals("debug")) {
            runWithDebug = false;
        }
        PHPProcess process = new PHPProcess(launch, URL2);
        this.debugTarget = (PHPDebugTarget)this.createDebugTraget(this, launch, URL2, requestPort, process, runWithDebug, stopAtFirstLine, project);
        launch.addDebugTarget((IDebugTarget)this.debugTarget);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LaunchManager manager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                manager.fireUpdate(new ILaunch[]{launch}, 0);
                manager.fireUpdate(new ILaunch[]{launch}, 2);
            }
        });
    }

    protected IDebugTarget createDebugTraget(DebugConnectionThread thread, ILaunch launch, String url, int requestPort, PHPProcess process, boolean runWithDebug, boolean stopAtFirstLine, IProject project) throws CoreException {
        return new PHPDebugTarget(thread, launch, url, requestPort, process, runWithDebug, stopAtFirstLine, project);
    }

    protected IDebugTarget createDebugTarget(DebugConnectionThread thread, ILaunch launch, String phpExeString, String debugFileName, int requestPort, PHPProcess process, boolean runWithDebugInfo, boolean stopAtFirstLine, IProject project) throws CoreException {
        return new PHPDebugTarget(thread, launch, phpExeString, debugFileName, requestPort, (IProcess)process, runWithDebugInfo, stopAtFirstLine, project);
    }

    protected void hookPHPExeDebug(final ILaunch launch, DebugSessionStartedNotification startedNotification) throws CoreException {
        IResource resource;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        this.inputManager.setTransferEncoding(launchConfiguration.getAttribute("debugTransferEncoding", ""));
        this.inputManager.setOutputEncoding(launchConfiguration.getAttribute("debugOutputEncoding", ""));
        String phpExeString = launchConfiguration.getAttribute("ATTR_LOCATION", null);
        String fileNameString = launchConfiguration.getAttribute("ATTR_FILE", null);
        boolean runWithDebugInfo = launchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = null;
        String file = launchConfiguration.getAttribute("ATTR_FILE", null);
        if (file != null && (resource = workspaceRoot.findMember(file)) != null) {
            project = resource.getProject();
        }
        if (launch.getLaunchMode().equals("debug")) {
            runWithDebugInfo = false;
        }
        String debugFileName = fileNameString;
        Path filePath = new Path(fileNameString);
        IResource res = workspaceRoot.findMember((IPath)filePath);
        if (res != null) {
            IFile fileToDebug = (IFile)res;
            debugFileName = fileToDebug.getName();
        }
        boolean stopAtFirstLine = PHPProjectPreferences.getStopAtFirstLine(project);
        int requestPort = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
        Path phpExe = new Path(phpExeString);
        PHPProcess process = new PHPProcess(launch, phpExe.toOSString());
        this.debugTarget = (PHPDebugTarget)this.createDebugTarget(this, launch, phpExeString, debugFileName, requestPort, process, runWithDebugInfo, stopAtFirstLine, project);
        launch.addDebugTarget((IDebugTarget)this.debugTarget);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LaunchManager manager = (LaunchManager)DebugPlugin.getDefault().getLaunchManager();
                manager.fireUpdate(new ILaunch[]{launch}, 0);
            }
        });
    }

    protected boolean verifyProtocolID(int serverProtocolID) {
        if (serverProtocolID < 2012121702) {
            return this.setProtocol(2012121702);
        }
        return true;
    }

    protected boolean setProtocol(int protocolID) {
        SetProtocolRequest request = new SetProtocolRequest();
        request.setProtocolID(protocolID);
        try {
            int responceProtocolID;
            Object response = this.sendRequest(request);
            if (response != null && response instanceof SetProtocolResponse && (responceProtocolID = ((SetProtocolResponse)response).getProtocolID()) == protocolID) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return false;
    }

    protected IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
        if (projectName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected String getURL(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("base_url", "");
    }

    static /* synthetic */ Socket access$5(DebugConnectionThread debugConnectionThread) {
        return debugConnectionThread.socket;
    }

    static /* synthetic */ IDebugMessageHandler access$6(DebugConnectionThread debugConnectionThread, IDebugMessage iDebugMessage) {
        return debugConnectionThread.createMessageHandler(iDebugMessage);
    }

    private class DummyDebugMessage
    extends DebugMessageImpl {
        private DummyDebugMessage() {
        }

        public void deserialize(DataInputStream in) throws IOException {
        }

        public int getType() {
            return 0;
        }

        public void serialize(DataOutputStream out) throws IOException {
        }
    }

    private class InputManager
    implements Runnable {
        private DataInputStream in;
        private boolean inWork = false;
        private boolean isAlive = true;
        private Thread theThread;
        private Object READY_FOR_RESTART_LOCK = new Object();
        private String transferEncoding;
        private String outputEncoding;

        public void setTransferEncoding(String transferEncoding) {
            this.transferEncoding = transferEncoding;
        }

        public void setOutputEncoding(String outputEncoding) {
            this.outputEncoding = outputEncoding;
        }

        InputManager(DataInputStream in) {
            this.in = in;
            this.inWork = true;
            this.isAlive = true;
        }

        public void start() {
            this.theThread = new Thread((Runnable)this, "PHP Debug Message Reader");
            this.theThread.start();
        }

        public synchronized void start(DataInputStream in) {
            this.stop();
            this.in = in;
            this.inWork = true;
            this.notifyAll();
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(DataInputStream in) {
            if (this.inWork) {
                Object object = this.READY_FOR_RESTART_LOCK;
                synchronized (object) {
                    try {
                        this.READY_FOR_RESTART_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.start(in);
        }

        public synchronized void stop() {
            if (!this.inWork) {
                return;
            }
            this.inWork = false;
            this.isAlive = true;
            this.theThread.interrupt();
        }

        public synchronized void terminate() {
            this.inWork = false;
            this.isAlive = false;
            this.theThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl87
            {
                block35: {
                    try {
                        var1_1 = this;
                        synchronized (var1_1) {
                            var2_4 = this.READY_FOR_RESTART_LOCK;
                            synchronized (var2_4) {
                                this.READY_FOR_RESTART_LOCK.notify();
                            }
                            this.wait();
                            v1 = this.in;
                            ** synchronized (v1)
lbl16:
                            // 1 sources

                        }
                    }
                    catch (InterruptedException v3) {
                        if (!PHPDebugPlugin.DEBUG) break block35;
                        System.out.println("interrupted: inWork = " + this.inWork + ", isAlive = " + this.isAlive);
                    }
                }
                do {
                    if (!this.inWork && this.isAlive) continue block18;
                    try {
                        if (!this.isAlive) break block18;
                        num = this.in.readInt();
                        if (num < 0) {
                            this.shutDown();
                            if (PHPDebugPlugin.DEBUG) {
                                System.out.println("Socket error (length is negative): possibly Server is SSL, Client is not.");
                            }
                            Logger.log(4, "Socket error (length is negative): possibly Server is SSL, Client is not.");
                        }
                        var2_4 = this;
                        synchronized (var2_4) {
                            messageType = DebugConnectionThread.this.getMessageType(this.in);
                            if (!DebugConnectionThread.this.validProtocol && messageType != DebugConnectionThread.startMessageId) {
                                errorMessage = MessageFormat.format((String)PHPDebugCoreMessages.Debugger_Incompatible_Protocol, (Object[])new Object[]{String.valueOf(2012121702)});
                                status = new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, null);
                                DebugPlugin.log((IStatus)status);
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debugger Error", (String)errorMessage);
                                    }
                                });
                                this.shutDown();
                                return;
                            }
                            DebugConnectionThread.this.validProtocol = true;
                            message = DebugMessagesRegistry.getMessage(messageType);
                            if (message != null) {
                                if (message instanceof OutputNotification) {
                                    message.setTransferEncoding(this.outputEncoding);
                                } else {
                                    message.setTransferEncoding(this.transferEncoding);
                                }
                            }
                            if (message instanceof IDebugNotificationMessage) {
                                message.deserialize(this.in);
                                DebugConnectionThread.access$7(DebugConnectionThread.this).queueIn(message);
                            } else if (message instanceof IDebugResponseMessage) {
                                message.deserialize(this.in);
                                idd = ((IDebugResponseMessage)message).getID();
                                handler = (ResponseHandler)DebugConnectionThread.access$4(DebugConnectionThread.this).get(new Integer(idd));
                                if (handler == null) {
                                    DebugConnectionThread.access$3(DebugConnectionThread.this).put(idd, (Object)message);
                                    req = (IDebugRequestMessage)DebugConnectionThread.access$2(DebugConnectionThread.this).remove(idd);
                                    if (req != null) {
                                        var8_11 = req;
                                        synchronized (var8_11) {
                                            req.notifyAll();
                                        }
                                    } else {
                                        DebugConnectionThread.access$3(DebugConnectionThread.this).remove(idd);
                                    }
                                } else {
                                    DebugConnectionThread.access$7(DebugConnectionThread.this).queueIn(message);
                                }
                            } else if (message instanceof IDebugRequestMessage) {
                                message.deserialize(this.in);
                                DebugConnectionThread.access$7(DebugConnectionThread.this).queueIn(message);
                            }
                        }
                    }
                    catch (IOException v6) {
                        this.shutDown();
                    }
                    catch (Exception e) {
                        PHPDebugPlugin.log(e);
                    }
lbl87:
                    // 8 sources

                } while (this.isAlive);
            }
        }

        private void shutDown() {
            this.terminate();
            DebugConnectionThread.this.cleanSocket();
            DebugConnectionThread.this.inputMessageHandler.connectionClosed();
        }
    }

    private class InputMessageHandler
    implements Runnable {
        private BlockingQueue inputMessageQueue = new BlockingQueue(100);
        private boolean shouldExit = false;
        private boolean isAlive = true;
        private boolean inWork = true;
        private Thread theThread;
        private DataOutputStream out;
        private DummyDebugMessage STOP_MSG;
        private ByteArrayOutputStream byteArray;
        private DataOutputStream outArray;
        private Object WAIT;
        private Object READY_FOR_RESTART_LOCK;

        public InputMessageHandler(DataOutputStream out) {
            this.STOP_MSG = new DummyDebugMessage();
            this.byteArray = new ByteArrayOutputStream();
            this.outArray = new DataOutputStream(this.byteArray);
            this.WAIT = new Object();
            this.READY_FOR_RESTART_LOCK = new Object();
            this.out = out;
            this.isAlive = true;
            this.inWork = true;
            this.shouldExit = false;
        }

        public void start() {
            this.theThread = new Thread((Runnable)this, "PHP Debug Message Handler");
            this.theThread.setPriority(1);
            this.theThread.start();
        }

        public synchronized void start(DataOutputStream out, boolean clearQueue) {
            if (clearQueue) {
                this.inputMessageQueue.clear();
            }
            this.out = out;
            this.ensureStarted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForStart(DataOutputStream out, boolean clearQueue) {
            if (this.inWork) {
                Object object = this.READY_FOR_RESTART_LOCK;
                synchronized (object) {
                    try {
                        this.READY_FOR_RESTART_LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.start(out, clearQueue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void ensureStarted() {
            Object object = this.WAIT;
            synchronized (object) {
                this.inWork = true;
                this.isAlive = true;
                this.shouldExit = false;
                this.WAIT.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void stopImmediately(boolean clearQueue) {
            if (!this.inWork) {
                return;
            }
            this.inWork = false;
            this.isAlive = true;
            this.inputMessageQueue.releaseReaders();
            if (clearQueue) {
                this.inputMessageQueue.clear();
            }
            Object object = this.WAIT;
            synchronized (object) {
                this.WAIT.notifyAll();
            }
        }

        public void terminate() {
            this.inWork = false;
            this.isAlive = false;
            DebugConnectionThread.this.validProtocol = false;
            this.inputMessageQueue.releaseReaders();
            this.inputMessageQueue.clear();
            this.theThread.interrupt();
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void queueIn(IDebugMessage m) {
            this.inputMessageQueue.queueIn((Object)m);
        }

        public synchronized void connectionClosed() {
            this.ensureStarted();
            this.queueIn(DebugConnectionThread.this.CONNECTION_CLOSED_MSG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void resetCommunication() {
            if (DebugConnectionThread.this.inputManager != null) {
                DebugConnectionThread.this.inputManager.stop();
            }
            this.stopImmediately(true);
            IntHashtable intHashtable = DebugConnectionThread.this.requestsTable;
            synchronized (intHashtable) {
                Iterator i = DebugConnectionThread.this.requestsTable.values().iterator();
                while (i.hasNext()) {
                    IDebugRequestMessage r;
                    IDebugRequestMessage iDebugRequestMessage = r = (IDebugRequestMessage)i.next();
                    synchronized (iDebugRequestMessage) {
                        r.notifyAll();
                    }
                }
            }
            DebugConnectionThread.this.requestsTable.clear();
            DebugConnectionThread.this.responseTable.clear();
            DebugConnectionThread.this.responseHandlers.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl96
            {
                try {
                    var1_1 = this.WAIT;
                    synchronized (var1_1) {
                        var2_3 = this.READY_FOR_RESTART_LOCK;
                        synchronized (var2_3) {
                            this.READY_FOR_RESTART_LOCK.notify();
                        }
                        this.WAIT.wait();
                    }
                }
                catch (InterruptedException v2) {}
                do {
                    if (!this.inWork && this.isAlive) continue block21;
                    if (!this.isAlive) break block21;
                    try {
                        newInputMessage = (IDebugMessage)this.inputMessageQueue.queueOut();
                        if (PHPDebugPlugin.DEBUG) {
                            System.out.println("New message received: " + newInputMessage);
                        }
                        var2_3 = this;
                        synchronized (var2_3) {
                            block37: {
                                try {
                                    isDebugConnectionTest = false;
                                    if (newInputMessage instanceof DebugSessionStartedNotification) {
                                        sessionStartedMessage = (DebugSessionStartedNotification)newInputMessage;
                                        isDebugConnectionTest = this.isDebugConnectionTest(sessionStartedMessage);
                                        if (isDebugConnectionTest) {
                                            sourceHost = DebugConnectionThread.access$5(DebugConnectionThread.this).getInetAddress().getHostAddress();
                                            if (DebugConnectionThread.this.verifyProtocolID(sessionStartedMessage.getServerProtocolID())) {
                                                DebugConnectionThread.this.sendRequest(new StartRequest());
                                                DebugServerTestController.getInstance().notifyTestListener(new DebugServerTestEvent(sourceHost, 0));
                                            } else {
                                                DebugServerTestController.getInstance().notifyTestListener(new DebugServerTestEvent(sourceHost, 2));
                                            }
                                        } else {
                                            DebugConnectionThread.this.hookDebugSession((DebugSessionStartedNotification)newInputMessage);
                                        }
                                    }
                                    if (DebugConnectionThread.this.debugTarget != null) {
                                        messageHandler = DebugConnectionThread.access$6(DebugConnectionThread.this, newInputMessage);
                                        if (messageHandler != null) {
                                            if (PHPDebugPlugin.DEBUG) {
                                                System.out.println("Creating message handler: " + messageHandler.getClass().getName().replaceFirst(".*\\.", ""));
                                            }
                                            messageHandler.handle(newInputMessage, DebugConnectionThread.this.debugTarget);
                                            if (!(messageHandler instanceof IDebugRequestHandler)) break block37;
                                            response = ((IDebugRequestHandler)messageHandler).getResponseMessage();
                                            this.byteArray.reset();
                                            response.serialize(this.outArray);
                                            var6_8 = this.out;
                                            synchronized (var6_8) {
                                                this.out.writeInt(this.byteArray.size());
                                                this.byteArray.writeTo(this.out);
                                                this.out.flush();
                                                break block37;
                                            }
                                        }
                                        if (newInputMessage instanceof IDebugResponseMessage) {
                                            r = (IDebugResponseMessage)newInputMessage;
                                            requestId = r.getID();
                                            req = (IDebugRequestMessage)DebugConnectionThread.access$2(DebugConnectionThread.this).remove(requestId);
                                            handler = (ResponseHandler)DebugConnectionThread.access$4(DebugConnectionThread.this).remove(new Integer(requestId));
                                            handler.handleResponse(req, r);
                                            break block37;
                                        }
                                        if (newInputMessage == this.STOP_MSG) {
                                            var5_7 = this.STOP_MSG;
                                            synchronized (var5_7) {
                                                this.inWork = false;
                                                this.STOP_MSG.notifyAll();
                                                if (this.shouldExit) {
                                                    this.isAlive = false;
                                                    this.inputMessageQueue.releaseReaders();
                                                }
                                                break block37;
                                            }
                                        }
                                        if (newInputMessage == DebugConnectionThread.access$0(DebugConnectionThread.this)) {
                                            this.handleConnectionClosed();
                                        }
                                        break block37;
                                    }
                                    this.handleConnectionClosed();
                                }
                                catch (Exception e) {
                                    PHPDebugPlugin.log(e);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        PHPDebugPlugin.log(e);
                    }
lbl96:
                    // 3 sources

                } while (this.isAlive);
            }
        }

        private boolean isDebugConnectionTest(DebugSessionStartedNotification inputMessage) {
            return inputMessage.getQuery().indexOf("testConnection=true") != -1;
        }

        private void handleConnectionClosed() {
            this.resetCommunication();
            if (DebugConnectionThread.this.getCommunicationAdministrator() != null) {
                DebugConnectionThread.this.getCommunicationAdministrator().connectionClosed();
            }
            this.terminate();
            DebugConnectionThread.this.closeConnection();
        }
    }
}

