/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.php.internal.server.ui.Activator;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ServersPluginImages {
    private static final String NAME_PREFIX = "org.eclipse.php.server.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.php.server.ui.".length();
    private static URL fgIconBaseURL = null;
    private static ImageRegistry fgImageRegistry;
    private static HashMap fgAvoidSWTErrorMap;
    private static final String T_OBJ = "obj16";
    private static final String T_WIZBAN = "wizban";
    public static final String IMG_SERVER = "org.eclipse.php.server.ui.server.gif";
    public static final String IMG_WIZ_SERVER = "org.eclipse.php.server.ui.server_wiz.gif";
    public static final ImageDescriptor DESC_SERVER;
    public static final ImageDescriptor DESC_WIZ_SERVER;

    static {
        fgIconBaseURL = Activator.getDefault().getBundle().getEntry("/icons/full/");
        fgImageRegistry = null;
        fgAvoidSWTErrorMap = null;
        DESC_SERVER = ServersPluginImages.createManaged(T_OBJ, IMG_SERVER);
        DESC_WIZ_SERVER = ServersPluginImages.createManaged(T_WIZBAN, IMG_WIZ_SERVER);
    }

    public static Image get(String key) {
        return ServersPluginImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        ServersPluginImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        ServersPluginImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            for (String key : fgAvoidSWTErrorMap.keySet()) {
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)ServersPluginImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        ImageDescriptor descriptor = ServersPluginImages.create("e" + type, relPath);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        return ServersPluginImages.createManaged(prefix, name, 0, null);
    }

    private static ImageDescriptor createManaged(String prefix, String name, int flags, Point size) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)ServersPluginImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (fgAvoidSWTErrorMap == null) {
                fgAvoidSWTErrorMap = new HashMap();
            }
            fgAvoidSWTErrorMap.put(name, result);
            if (fgImageRegistry != null) {
                Logger.log(4, "Image registry already defined");
            }
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)ServersPluginImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

