/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.buildpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildPathUtils {
    public static void addEntriesToBuildPath(IScriptProject scriptProject, List<IBuildpathEntry> entries) throws ModelException {
        IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
        HashSet<IBuildpathEntry> newRawBuildpath = new HashSet<IBuildpathEntry>();
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            newRawBuildpath.add(buildpathEntry);
            ++n2;
        }
        for (IBuildpathEntry buildpathEntry : entries) {
            newRawBuildpath.add(buildpathEntry);
        }
        scriptProject.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newRawBuildpath.size()]), null);
    }

    public static void addNonDupEntriesToBuildPath(IScriptProject scriptProject, List<IBuildpathEntry> entries) throws ModelException {
        IBuildpathEntry[] rawBuildpath;
        HashSet<IBuildpathEntry> newRawBuildpath = new HashSet<IBuildpathEntry>();
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath = scriptProject.getRawBuildpath();
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            newRawBuildpath.add(buildpathEntry);
            ++n2;
        }
        for (IBuildpathEntry buildpathEntry : entries) {
            if (BuildPathUtils.buildpathContains(newRawBuildpath.toArray(new IBuildpathEntry[newRawBuildpath.size()]), buildpathEntry)) continue;
            newRawBuildpath.add(buildpathEntry);
        }
        scriptProject.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newRawBuildpath.size()]), null);
    }

    public static boolean buildpathContains(IBuildpathEntry[] list, IBuildpathEntry entry) {
        int i = 0;
        while (i < list.length) {
            IBuildpathEntry other = list[i];
            if (other.getContentKind() == entry.getContentKind() && other.getEntryKind() == entry.getEntryKind() && other.isExported() == entry.isExported() && other.getPath().equals((Object)entry.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void removeEntryFromBuildPath(IScriptProject scriptProject, IBuildpathEntry buildpathEntry) throws ModelException {
        IBuildpathEntry[] rawBuildpath = scriptProject.getRawBuildpath();
        ArrayList<IBuildpathEntry> newRawBuildpath = new ArrayList<IBuildpathEntry>();
        IBuildpathEntry[] iBuildpathEntryArray = rawBuildpath;
        int n = rawBuildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (!entry.getPath().equals((Object)buildpathEntry.getPath())) {
                newRawBuildpath.add(entry);
            }
            ++n2;
        }
        scriptProject.setRawBuildpath(newRawBuildpath.toArray(new IBuildpathEntry[newRawBuildpath.size()]), null);
    }

    public static boolean isContainedInBuildpath(IPath resourcePath, IScriptProject project) {
        boolean result = false;
        if (resourcePath == null) {
            return false;
        }
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getRawBuildpath();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        IBuildpathEntry[] iBuildpathEntryArray = buildpath;
        int n = buildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath buildPathEntryPath;
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            if (buildpathEntry.getEntryKind() == 3 && ((buildPathEntryPath = buildpathEntry.getPath()).isPrefixOf(resourcePath) || resourcePath.toString().equals(buildPathEntryPath.toString()))) {
                result = true;
            }
            ++n2;
        }
        return result;
    }

    public static boolean isInBuildpath(IPath resourcePath, IScriptProject project) {
        boolean result = false;
        if (resourcePath == null) {
            return false;
        }
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getRawBuildpath();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
        IBuildpathEntry[] iBuildpathEntryArray = buildpath;
        int n = buildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            if (buildpathEntry.getEntryKind() == 3) {
                IPath buildPathEntryPath = buildpathEntry.getPath();
                if (resourcePath.toString().equals(buildPathEntryPath.toString())) {
                    result = true;
                }
            }
            ++n2;
        }
        return result;
    }

    public static List<IBuildpathEntry> getContainedBuildpathes(IPath resourcePath, IScriptProject project) {
        if (resourcePath == null) {
            return Collections.EMPTY_LIST;
        }
        IBuildpathEntry[] buildpath = null;
        try {
            buildpath = project.getRawBuildpath();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList<IBuildpathEntry> result = new ArrayList<IBuildpathEntry>();
        IBuildpathEntry[] iBuildpathEntryArray = buildpath;
        int n = buildpath.length;
        int n2 = 0;
        while (n2 < n) {
            IPath buildPathEntryPath;
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            if (buildpathEntry.getEntryKind() == 3 && (resourcePath.isPrefixOf(buildPathEntryPath = buildpathEntry.getPath()) || resourcePath.toString().equals(buildPathEntryPath.toString()))) {
                result.add(buildpathEntry);
            }
            ++n2;
        }
        return result;
    }
}

