/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;

public class MethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public MethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        MethodElementReturnTypeGoal goal = (MethodElementReturnTypeGoal)this.getGoal();
        String methodName = goal.getMethodName();
        final LinkedList subGoals = new LinkedList();
        AbstractMethodReturnTypeEvaluator.MethodsAndTypes mat = this.getMethodsAndTypes();
        int i = 0;
        while (i < mat.methods.length) {
            IMethod method;
            block9: {
                MethodDeclaration decl;
                ModuleDeclaration module;
                ISourceModule sourceModule;
                block8: {
                    method = mat.methods[i];
                    sourceModule = method.getSourceModule();
                    module = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                    decl = null;
                    try {
                        decl = PHPModelUtils.getNodeByMethod(module, method);
                    }
                    catch (ModelException e) {
                        if (!DLTKCore.DEBUG) break block8;
                        e.printStackTrace();
                    }
                }
                if (decl != null) {
                    final IContext innerContext = ASTUtils.findContext(sourceModule, module, (ASTNode)decl);
                    if (innerContext instanceof MethodContext) {
                        MethodContext mc = (MethodContext)innerContext;
                        mc.setCurrentType(mat.types[i]);
                    }
                    ASTVisitor visitor = new ASTVisitor(){

                        public boolean visitGeneral(ASTNode node) throws Exception {
                            if (node instanceof ReturnStatement) {
                                ReturnStatement statement = (ReturnStatement)node;
                                Expression expr = statement.getExpr();
                                if (expr == null) {
                                    MethodReturnTypeEvaluator.this.evaluated.add(PHPSimpleTypes.VOID);
                                } else {
                                    subGoals.add(new ExpressionTypeGoal(innerContext, (ASTNode)expr));
                                }
                            }
                            return super.visitGeneral(node);
                        }
                    };
                    try {
                        decl.traverse(visitor);
                    }
                    catch (Exception e) {
                        if (!DLTKCore.DEBUG) break block9;
                        e.printStackTrace();
                    }
                }
            }
            if (method != null) {
                this.resolveMagicMethodDeclaration(method, methodName);
            }
            ++i;
        }
        return subGoals.toArray(new IGoal[subGoals.size()]);
    }

    private void resolveMagicMethodDeclaration(IMethod method, String methodName) {
        IModelElement parent = method.getParent();
        if (parent.getElementType() != 7) {
            return;
        }
        IType type = (IType)parent;
        PHPDocBlock docBlock = PHPModelUtils.getDocBlock(type);
        if (docBlock != null) {
            PHPDocTag[] pHPDocTagArray = docBlock.getTags();
            int n = pHPDocTagArray.length;
            int n2 = 0;
            while (n2 < n) {
                String typeName;
                PHPDocTag tag = pHPDocTagArray[n2];
                int tagKind = tag.getTagKind();
                if (tagKind == 33 && (typeName = this.getTypeBinding(methodName, tag)) != null) {
                    Object resolved = PHPSimpleTypes.fromString(typeName);
                    if (resolved == null) {
                        resolved = new PHPClassType(typeName);
                    }
                    this.evaluated.add((IEvaluatedType)resolved);
                }
                ++n2;
            }
        }
    }

    private String getTypeBinding(String methodName, PHPDocTag docTag) {
        String[] split = docTag.getValue().trim().split("\\s+");
        if (split.length < 2) {
            return null;
        }
        if (split[1].equals(methodName)) {
            return split[0];
        }
        if (split[1].length() > 2 && split[1].endsWith("()")) {
            String substring = split[1].substring(0, split[1].length() - 2);
            return substring.equals(methodName) ? split[0] : null;
        }
        return null;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }
}

