/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.php.internal.ui.editor.SemanticToken;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public abstract class SemanticHighlighting {
    public abstract String getPreferenceKey();

    public abstract RGB getDefaultDefaultTextColor();

    public RGB getDefaultTextColor() {
        return SemanticHighlighting.findRGB(this.getThemeColorKey(), this.getDefaultDefaultTextColor());
    }

    public abstract boolean isBoldByDefault();

    public abstract boolean isItalicByDefault();

    public boolean isStrikethroughByDefault() {
        return false;
    }

    public boolean isUnderlineByDefault() {
        return false;
    }

    public abstract boolean isEnabledByDefault();

    public abstract String getDisplayName();

    public abstract boolean consumes(SemanticToken var1);

    public boolean consumesLiteral(SemanticToken token) {
        return false;
    }

    private String getThemeColorKey() {
        return "org.eclipse.php.ui." + this.getPreferenceKey() + "Highlighting";
    }

    private static RGB findRGB(String key, RGB defaultRGB) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return defaultRGB;
        }
        ColorRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        RGB rgb = registry.getRGB(key);
        if (rgb != null) {
            return rgb;
        }
        return defaultRGB;
    }
}

