/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hyperlink;

import java.util.HashSet;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.ui.actions.OpenAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.compiler.ast.nodes.Include;
import org.eclipse.php.internal.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;

public class IncludeHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        PHPStructuredEditor editor = org.eclipse.php.internal.ui.util.EditorUtility.getPHPEditor(textViewer);
        if (editor == null) {
            return null;
        }
        ISourceModule input = EditorUtility.getEditorInputModelElement((IEditorPart)editor, (boolean)false);
        if (!(input instanceof ISourceModule)) {
            return null;
        }
        final int offset = region.getOffset();
        final String[] file = new String[1];
        final Region[] selectRegion = new Region[1];
        ISourceModule sourceModule = input;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        ASTVisitor visitor = new ASTVisitor(){
            boolean found = false;

            public boolean visit(Expression expr) throws ModelException {
                if (expr.sourceStart() < offset && expr.sourceEnd() > offset && expr instanceof Include) {
                    InfixExpression ie;
                    Expression fileExpr = ((Include)expr).getExpr();
                    if (fileExpr instanceof InfixExpression && (ie = (InfixExpression)fileExpr).getRight() instanceof Scalar) {
                        fileExpr = ie.getRight();
                    }
                    if (fileExpr instanceof Scalar) {
                        String value = ((Scalar)fileExpr).getValue();
                        file[0] = ASTUtils.stripQuotes((String)value);
                        file[0] = file[0].trim();
                        int startIdx = fileExpr.sourceStart() + value.indexOf(file[0]);
                        int length = file[0].length();
                        selectRegion[0] = new Region(startIdx, length);
                    }
                    this.found = true;
                    return false;
                }
                return !this.found;
            }

            public boolean visitGeneral(ASTNode n) {
                return !this.found;
            }
        };
        try {
            moduleDeclaration.traverse(visitor);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
        if (file[0] != null) {
            if (!this.inclusive(region, selectRegion[0])) {
                return null;
            }
            HashSet<String> set = new HashSet<String>();
            set.add(sourceModule.getResource().getLocation().toOSString());
            ISourceModule includedSourceModule = FileNetworkUtility.findSourceModule((ISourceModule)sourceModule, (String)file[0], set);
            if (includedSourceModule != null) {
                return new IHyperlink[]{new ModelElementHyperlink((IRegion)selectRegion[0], (Object)includedSourceModule, new OpenAction((IEditorPart)editor))};
            }
        }
        return null;
    }

    private boolean inclusive(IRegion region1, Region region2) {
        return region1.getOffset() >= region2.getOffset() && region1.getOffset() + region1.getLength() <= region2.getOffset() + region2.getLength();
    }
}

