/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.php.internal.ui.util.StatusUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class BasicPHPWizardPage
extends WizardPage {
    private IStatus fCurrStatus;
    private boolean fPageVisible;

    protected BasicPHPWizardPage(String pageName) {
        super(pageName);
    }

    protected Button createButton(Composite composite, int style, String message, GridData gd) {
        Button button = new Button(composite, style);
        button.setText(message);
        button.setLayoutData((Object)gd);
        return button;
    }

    protected GridLayout createGridLayout(int columns) {
        return new GridLayout(columns, false);
    }

    protected GridData createGridData(int flag, int hspan, int vspan, int indent) {
        GridData gd = new GridData(flag);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = hspan;
        gd.verticalSpan = vspan;
        return gd;
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData gd = new GridData(flag);
        gd.horizontalIndent = indent;
        gd.horizontalSpan = hspan;
        return gd;
    }

    protected GridData createGridData(int hspan) {
        GridData gd = new GridData();
        gd.horizontalSpan = hspan;
        return gd;
    }

    protected void createSeparator(Composite composite, int horizontalSpan) {
        Label line = new Label(composite, 258);
        GridData gridData = new GridData(768);
        if (horizontalSpan > 0) {
            gridData.horizontalSpan = horizontalSpan;
        }
        line.setLayoutData((Object)gridData);
    }

    protected Label createLabel(Composite composite, int style, String message, GridData gd) {
        Label label = new Label(composite, style);
        label.setText(message);
        label.setLayoutData((Object)gd);
        return label;
    }

    protected Text createText(Composite composite, int style, String message, GridData gd) {
        Text text = new Text(composite, style);
        if (message != null) {
            text.setText(message);
        }
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Combo createCombo(Composite composite, int style, String message, GridData gd) {
        Combo combo = new Combo(composite, style);
        if (message != null) {
            combo.setText(message);
        }
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected void handleFileBrowseButtonPressed(Text text, String[] extensions, String title) {
        String selectedDirectory;
        File path;
        FileDialog dialog = new FileDialog(text.getShell());
        dialog.setText(title);
        dialog.setFilterExtensions(extensions);
        String dirName = text.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            text.setText(selectedDirectory);
        }
    }

    protected void handleFileBrowseButtonPressed(Combo text, String[] extensions, String title) {
        String selectedDirectory;
        File path;
        FileDialog dialog = new FileDialog(text.getShell());
        dialog.setText(title);
        dialog.setFilterExtensions(extensions);
        String dirName = text.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            text.add(selectedDirectory);
            text.select(text.indexOf(selectedDirectory));
            text.notifyListeners(24, new Event());
        }
    }

    protected void handleFileBrowseButtonPressed(Combo text, String[] extensions, String title, String fileName) {
        String selectedDirectory;
        File path;
        FileDialog dialog = new FileDialog(text.getShell(), 8192);
        dialog.setText(title);
        dialog.setFilterExtensions(extensions);
        dialog.setFileName(fileName);
        String dirName = text.getText();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(dirName);
        }
        if ((selectedDirectory = dialog.open()) != null) {
            text.add(selectedDirectory);
            text.select(text.indexOf(selectedDirectory));
            text.notifyListeners(24, new Event());
        }
    }

    protected String handleFolderBrowseButtonPressed(String dir, String title, String message) {
        File file;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(dir);
        dialog.setText(title);
        dialog.setMessage(message);
        String res = dialog.open();
        if (res != null && (file = new File(res)).isDirectory()) {
            return res;
        }
        return dir;
    }

    protected void updateStatus(IStatus status) {
        this.fCurrStatus = status;
        this.setPageComplete(!status.matches(4));
        if (this.fPageVisible) {
            StatusUtil.applyToStatusLine((DialogPage)this, status);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fPageVisible = visible;
        if (visible && this.fCurrStatus.matches(4)) {
            StatusInfo status = new StatusInfo();
            status.setError("");
            this.fCurrStatus = status;
        }
        this.updateStatus(this.fCurrStatus);
    }

    public ArrayList setComboItems(Combo combo, ArrayList arrItems) {
        arrItems.clear();
        arrItems.add(combo.getText());
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            String curr = items[i];
            if (!arrItems.contains(curr)) {
                arrItems.add(curr);
            }
            ++i;
        }
        return arrItems;
    }

    protected static class EnableSelectionAdapter
    extends SelectionAdapter {
        private Control[] fEnable;
        private Control[] fDisable;

        protected EnableSelectionAdapter(Control[] enable, Control[] disable) {
            this.fEnable = enable;
            this.fDisable = disable;
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < this.fEnable.length) {
                this.fEnable[i].setEnabled(true);
                ++i;
            }
            i = 0;
            while (i < this.fDisable.length) {
                this.fDisable[i].setEnabled(false);
                ++i;
            }
            this.validate();
        }

        public void validate() {
        }
    }

    protected static class ToggleSelectionAdapter
    extends SelectionAdapter {
        Control[] controls;

        protected ToggleSelectionAdapter(Control[] controls) {
            this.controls = controls;
        }

        public void widgetSelected(SelectionEvent e) {
            int i = 0;
            while (i < this.controls.length) {
                Control control;
                control.setEnabled(!(control = this.controls[i]).getEnabled());
                ++i;
            }
            this.validate();
        }

        public void validate() {
        }
    }
}

