/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.debug.core.model.DebugOutput;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPThread;
import org.eclipse.php.internal.debug.ui.views.DebugViewHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class DebugOutputView
extends AbstractDebugView
implements ISelectionListener {
    public static final String ID_PHPDebugOutput = "org.eclipse.debug.ui.PHPDebugOutput";
    private IPHPDebugTarget fTarget;
    private int fUpdateCount;
    private IDebugEventSetListener terminateListener;
    private DebugViewHelper debugViewHelper;
    private StructuredTextViewer fSourceViewer;

    protected Viewer createViewer(Composite parent) {
        int styles = 66306;
        this.fSourceViewer = new StructuredTextViewer(parent, null, null, false, styles);
        this.fSourceViewer.setEditable(false);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.getSite().setSelectionProvider(this.fSourceViewer.getSelectionProvider());
        this.setBackgroundColor();
        this.terminateListener = new IDebugEventSetListener(){
            IPHPDebugTarget target;

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        Object obj = events[i].getSource();
                        if ((obj instanceof IPHPDebugTarget || obj instanceof PHPThread) && (events[i].getKind() == 8 || events[i].getKind() == 2)) {
                            this.target = obj instanceof IPHPDebugTarget ? (IPHPDebugTarget)obj : (IPHPDebugTarget)((PHPThread)obj).getDebugTarget();
                            UIJob job = new UIJob("debug output"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    DebugOutputView.this.update(target);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.terminateListener);
        this.debugViewHelper = new DebugViewHelper();
        return this.fSourceViewer;
    }

    private void setBackgroundColor() {
        IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
        this.fSourceViewer.getTextWidget().setBackground(this.getBackgroundColor(store));
        IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                IPreferenceStore store = EditorsPlugin.getDefault().getPreferenceStore();
                String prop = event.getProperty();
                if (prop.equals("AbstractTextEditor.Color.Background.SystemDefault") || prop.equals("AbstractTextEditor.Color.Background")) {
                    DebugOutputView.this.fSourceViewer.getTextWidget().setBackground(DebugOutputView.this.getBackgroundColor(store));
                }
            }
        };
        store.addPropertyChangeListener(listener);
    }

    private Color getBackgroundColor(IPreferenceStore store) {
        RGB color;
        String useDefault = store.getString("AbstractTextEditor.Color.Background.SystemDefault");
        Color dflt = Display.getDefault().getSystemColor(25);
        if ("true".equalsIgnoreCase(useDefault)) {
            return dflt;
        }
        String bgColor = store.getString("AbstractTextEditor.Color.Background");
        if (bgColor == null || bgColor.equals("")) {
            return dflt;
        }
        String[] rgb = bgColor.split(",");
        try {
            color = new RGB(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        catch (Throwable throwable) {
            return dflt;
        }
        return new Color((Device)Display.getDefault(), color);
    }

    protected String getHelpContextId() {
        return "org.eclipse.php.help.debug_output_view";
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugPlugin.getDefault().removeDebugEventListener(this.terminateListener);
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IPHPDebugTarget target = this.debugViewHelper.getSelectionElement(selection);
        this.update(target);
    }

    private synchronized void update(IPHPDebugTarget target) {
        BasicStructuredDocument dd;
        IPHPDebugTarget oldTarget = this.fTarget;
        int oldcount = this.fUpdateCount;
        this.fTarget = target;
        HTMLDocumentLoader ss = new HTMLDocumentLoader();
        BasicStructuredDocument input = dd = (BasicStructuredDocument)ss.createNewStructuredDocument();
        if (this.fTarget != null) {
            if (this.fTarget.isSuspended() || this.fTarget.isTerminated() || this.fTarget.isWaiting()) {
                DebugOutput outputBuffer = this.fTarget.getOutputBuffer();
                this.fUpdateCount = outputBuffer.getUpdateCount();
                if (this.fTarget == oldTarget && this.fUpdateCount == oldcount) {
                    return;
                }
                String output = outputBuffer.toString();
                dd.setText((Object)this, output);
            } else {
                this.fTarget = oldTarget;
                return;
            }
        }
        try {
            this.fSourceViewer.setInput((Object)input);
        }
        catch (Exception exception) {}
        this.fSourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationHTML());
        this.fSourceViewer.refresh();
    }

    protected void createActions() {
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void updateObjects() {
        super.updateObjects();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IPHPDebugTarget target = this.debugViewHelper.getSelectionElement(null);
        this.update(target);
    }
}

