/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.typeinference;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.ContextFinder;

public class TypeInferenceTests
extends AbstractPDTTTest {
    protected static final int ENGINE_TIMEOUT = 100000;
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    private static PHPTypeInferencer typeInferenceEngine;
    private static IProject project;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/typeinference/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/typeinference/php5"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/typeinference/php5", "/workspace/typeinference/php54"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("TypeInferenceTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        typeInferenceEngine = new PHPTypeInferencer();
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
        typeInferenceEngine = null;
    }

    public TypeInferenceTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Type Inference Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = TypeInferenceTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    final String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        final String pruner = TypeInferenceTests.getPrunerType(pdttFile);
                        phpVerSuite.addTest((Test)new TypeInferenceTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                            }

                            protected void tearDown() throws Exception {
                            }

                            protected void runTest() throws Throwable {
                                String criteriaFunction = new File(fileName).getName().replaceAll("\\.pdtt", "");
                                String code = pdttFile.getFile();
                                IEvaluatedType evaluatedType = this.findEvaluatedType(code, criteriaFunction, pruner);
                                Assert.assertNotNull((String)("Can't evaluate type for: " + code), (Object)evaluatedType);
                                Assert.assertEquals((String)pdttFile.getExpected().trim(), (String)evaluatedType.getTypeName().trim());
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                TypeInferenceTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                TypeInferenceTests.tearDownSuite();
            }
        };
        return setup;
    }

    private static String getPrunerType(PdttFile pdttFile) {
        Map<String, String> config = pdttFile.getConfig();
        return config.get("prune");
    }

    protected IEvaluatedType findEvaluatedType(String code, String criteriaFunction, String pruner) throws Exception {
        ExpressionTypeGoal goal;
        IFile file;
        block15: {
            block14: {
                IEvaluatedType iEvaluatedType;
                file = project.getFile("dummy.php");
                if (file.exists()) {
                    file.setContents((InputStream)new ByteArrayInputStream(code.getBytes()), true, false, null);
                } else {
                    file.create((InputStream)new ByteArrayInputStream(code.getBytes()), true, null);
                }
                try {
                    project.build(6, null);
                    PHPCoreTests.waitForIndexer();
                    PHPCoreTests.waitForAutoBuild();
                    ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
                    ModuleDeclaration moduleDecl = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                    ASTNodeSearcher searcher = new ASTNodeSearcher(sourceModule, criteriaFunction);
                    moduleDecl.traverse((ASTVisitor)searcher);
                    Assert.assertNotNull((String)("Method call " + criteriaFunction + "() in code: " + code), (Object)searcher.getResult());
                    Assert.assertNotNull((String)("Can't find context for " + criteriaFunction + "() in code: " + code), (Object)searcher.getContext());
                    goal = new ExpressionTypeGoal(searcher.getContext(), searcher.getResult());
                    if (!"phpdocGoals".equals(pruner)) break block14;
                    iEvaluatedType = typeInferenceEngine.evaluateTypeHeavy((AbstractTypeGoal)goal, 100000);
                }
                catch (Throwable throwable) {
                    try {
                        file.delete(true, null);
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    file.delete(true, null);
                }
                catch (Exception exception) {}
                return iEvaluatedType;
            }
            if (!"heavyGoals".equals(pruner)) break block15;
            IEvaluatedType iEvaluatedType = typeInferenceEngine.evaluateTypePHPDoc((AbstractTypeGoal)goal, 100000);
            try {
                file.delete(true, null);
            }
            catch (Exception exception) {}
            return iEvaluatedType;
        }
        IEvaluatedType iEvaluatedType = typeInferenceEngine.evaluateType((AbstractTypeGoal)goal, 100000);
        try {
            file.delete(true, null);
        }
        catch (Exception exception) {}
        return iEvaluatedType;
    }

    class ASTNodeSearcher
    extends ContextFinder {
        private IContext context;
        private ASTNode result;
        private String criteriaFunction;

        public ASTNodeSearcher(ISourceModule sourceModule, String criteriaFunction) {
            super(sourceModule);
            this.criteriaFunction = criteriaFunction;
        }

        public boolean visit(Expression node) throws Exception {
            CallExpression callExpression;
            if (node instanceof CallExpression && this.criteriaFunction.equals((callExpression = (CallExpression)node).getName())) {
                this.result = (ASTNode)callExpression.getArgs().getChilds().get(0);
                this.context = (IContext)this.contextStack.peek();
                return false;
            }
            return true;
        }

        public ASTNode getResult() {
            return this.result;
        }

        public IContext getContext() {
            return this.context;
        }
    }
}

