/* The following code was generated by JFlex 1.4.1 on 7/31/12 11:47 AM */

/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/

package org.eclipse.php.internal.core.ast.scanner.php54;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.php.internal.core.ast.nodes.IDocumentorLexer;
import org.eclipse.php.internal.core.ast.nodes.Comment;
import java_cup.sym;
import org.eclipse.php.internal.core.ast.nodes.AST;
import java_cup.runtime.Symbol;
import org.eclipse.php.internal.core.ast.scanner.StateStack;
import org.eclipse.php.internal.core.PHPVersion;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 7/31/12 11:47 AM from the specification file
 * <tt>ast_scanner.flex</tt>
 */
public class PhpAstLexer implements org.eclipse.php.internal.core.ast.scanner.AstLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int ST_DOCBLOCK = 11;
  public static final int ST_IN_SCRIPTING = 1;
  public static final int ST_NOWDOC = 6;
  public static final int ST_LOOKING_FOR_PROPERTY = 7;
  public static final int ST_ONE_LINE_COMMENT = 12;
  public static final int ST_COMMENT = 10;
  public static final int ST_BACKQUOTE = 3;
  public static final int ST_DOUBLE_QUOTES = 2;
  public static final int YYINITIAL = 0;
  public static final int ST_VAR_OFFSET = 9;
  public static final int ST_LOOKING_FOR_VARNAME = 8;
  public static final int ST_HEREDOC = 4;
  public static final int ST_END_HEREDOC = 5;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\14\1\13\2\0\1\15\22\0\1\14\1\60\1\17\1\101"+
    "\1\16\1\64\1\65\1\100\1\52\1\53\1\62\1\4\1\70\1\46"+
    "\1\2\1\63\1\5\1\11\10\1\1\50\1\23\1\61\1\57\1\47"+
    "\1\74\1\75\1\7\1\10\1\32\1\26\1\3\1\27\1\43\1\37"+
    "\1\24\1\54\1\42\1\41\1\45\1\31\1\33\1\44\1\56\1\35"+
    "\1\34\1\25\1\30\1\51\1\40\1\6\1\36\1\12\1\71\1\20"+
    "\1\72\1\67\1\55\1\21\1\7\1\10\1\32\1\26\1\3\1\27"+
    "\1\43\1\37\1\24\1\54\1\42\1\41\1\45\1\31\1\33\1\44"+
    "\1\56\1\35\1\77\1\25\1\30\1\51\1\40\1\6\1\36\1\12"+
    "\1\22\1\66\1\76\1\73\201\12\uff00\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\4\0\1\1\10\0\2\2\1\3\1\4\1\5\1\6"+
    "\1\7\1\4\4\6\1\10\1\11\1\12\1\13\1\14"+
    "\1\15\1\16\16\6\1\17\1\20\1\21\1\6\1\22"+
    "\1\23\1\6\1\24\1\25\1\26\1\27\1\30\1\31"+
    "\1\32\1\33\1\34\1\35\1\36\1\37\1\40\1\41"+
    "\1\42\1\43\1\3\1\44\1\1\1\3\1\45\2\3"+
    "\1\1\2\3\1\46\1\3\3\1\3\3\1\47\3\3"+
    "\1\50\1\51\1\50\1\52\1\53\1\54\1\5\1\7"+
    "\1\54\1\55\1\56\1\57\1\60\1\17\1\20\1\21"+
    "\1\22\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\61\1\41\1\62\1\10\1\63\3\10"+
    "\3\64\2\63\1\0\1\65\1\66\1\2\1\67\1\0"+
    "\1\70\6\6\1\71\1\72\2\0\3\6\1\73\2\6"+
    "\2\0\1\74\2\0\1\75\2\0\1\76\7\6\1\77"+
    "\12\6\1\100\11\6\1\101\1\102\1\103\1\104\1\105"+
    "\1\106\1\6\12\0\1\6\1\107\1\110\2\111\1\112"+
    "\1\113\1\0\1\114\1\115\1\116\1\117\1\120\1\121"+
    "\1\122\1\123\1\124\1\125\1\126\4\0\1\74\2\127"+
    "\1\130\1\131\1\127\3\0\3\132\3\0\1\133\2\1"+
    "\2\127\3\0\1\134\2\0\1\135\1\136\2\0\1\137"+
    "\1\140\1\141\1\142\2\0\1\67\1\0\7\6\1\67"+
    "\1\143\1\144\1\6\1\145\2\6\1\0\6\6\1\146"+
    "\3\6\1\147\2\6\1\150\1\6\1\151\1\152\22\6"+
    "\1\153\1\154\12\0\7\6\1\155\1\156\1\157\3\0"+
    "\1\160\1\0\2\117\2\126\1\0\1\161\1\162\1\1"+
    "\1\163\1\0\2\136\2\0\6\6\1\164\1\165\1\6"+
    "\1\166\23\6\1\167\12\6\1\170\1\171\5\6\12\0"+
    "\10\6\4\0\1\172\4\0\1\6\1\173\5\6\1\174"+
    "\1\6\1\175\1\176\4\6\1\177\1\6\1\200\1\201"+
    "\3\6\1\202\2\6\1\203\1\6\1\204\2\6\1\205"+
    "\1\206\1\207\4\6\1\210\2\6\1\211\2\6\5\0"+
    "\1\212\6\0\10\6\2\213\4\0\1\214\2\215\1\0"+
    "\2\6\1\216\2\6\1\217\7\6\1\220\6\6\1\221"+
    "\1\222\1\223\1\6\1\224\1\225\2\6\4\0\1\226"+
    "\5\0\1\227\10\6\4\0\1\230\6\6\1\231\3\6"+
    "\1\232\1\233\1\6\1\234\3\6\1\235\1\236\1\6"+
    "\1\237\3\0\1\240\1\0\1\241\7\6\3\0\3\6"+
    "\1\242\1\243\5\6\1\244\1\6\1\245\1\246\2\6"+
    "\1\247\1\250\1\251\4\6\1\252\1\6\4\0\2\6"+
    "\1\253\1\254\1\6\1\255\2\6\1\256\1\6\1\257"+
    "\2\6\1\260\2\6\2\0\1\261\1\262\1\6\1\263"+
    "\1\264\4\6\1\265\4\0\5\6\1\0\1\266\1\0"+
    "\1\267\1\270\1\271\2\6\1\0\1\272\1\6\1\0"+
    "\1\6\1\0\1\273\14\0\1\66\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[690];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\102\0\204\0\306\0\u0108\0\u014a\0\u018c\0\u01ce"+
    "\0\u0210\0\u0252\0\u0294\0\u02d6\0\u0318\0\u035a\0\u039c\0\u03de"+
    "\0\u0420\0\u0462\0\u04a4\0\u04e6\0\u0528\0\u056a\0\u05ac\0\u05ee"+
    "\0\u0630\0\u0672\0\u06b4\0\u06f6\0\u03de\0\u03de\0\u03de\0\u03de"+
    "\0\u0738\0\u077a\0\u07bc\0\u07fe\0\u0840\0\u0882\0\u08c4\0\u0906"+
    "\0\u0948\0\u098a\0\u09cc\0\u0a0e\0\u0a50\0\u0a92\0\u0ad4\0\u0b16"+
    "\0\u0b58\0\u0b9a\0\u0bdc\0\u03de\0\u0c1e\0\u0c60\0\u0ca2\0\u0ce4"+
    "\0\u0d26\0\u0d68\0\u0daa\0\u0dec\0\u0e2e\0\u0e70\0\u03de\0\u03de"+
    "\0\u03de\0\u03de\0\u0eb2\0\u03de\0\u03de\0\u0ef4\0\u03de\0\u0f36"+
    "\0\u0f78\0\u03de\0\u0fba\0\u0ffc\0\u103e\0\u1080\0\u10c2\0\u03de"+
    "\0\u1104\0\u1146\0\u1188\0\u11ca\0\u120c\0\u124e\0\u1290\0\u03de"+
    "\0\u12d2\0\u1314\0\u1356\0\u03de\0\u1398\0\u13da\0\u03de\0\u141c"+
    "\0\u145e\0\u03de\0\u03de\0\u14a0\0\u03de\0\u03de\0\u03de\0\u03de"+
    "\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de"+
    "\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de"+
    "\0\u14e2\0\u1524\0\u03de\0\u1566\0\u15a8\0\u15ea\0\u03de\0\u162c"+
    "\0\u03de\0\u166e\0\u16b0\0\u16f2\0\u1734\0\u1776\0\u17b8\0\u17fa"+
    "\0\u03de\0\u183c\0\u187e\0\u18c0\0\u1902\0\u1944\0\u1986\0\u03de"+
    "\0\u03de\0\u19c8\0\u1a0a\0\u1a4c\0\u1a8e\0\u1ad0\0\u0630\0\u1b12"+
    "\0\u1b54\0\u1b96\0\u0ef4\0\u1bd8\0\u06f6\0\u1c1a\0\u03de\0\u1c5c"+
    "\0\u1c9e\0\u0630\0\u1ce0\0\u1d22\0\u1d64\0\u1da6\0\u1de8\0\u1e2a"+
    "\0\u1e6c\0\u0630\0\u1eae\0\u1ef0\0\u1f32\0\u1f74\0\u1fb6\0\u1ff8"+
    "\0\u203a\0\u207c\0\u20be\0\u2100\0\u0630\0\u2142\0\u2184\0\u21c6"+
    "\0\u2208\0\u224a\0\u228c\0\u22ce\0\u2310\0\u2352\0\u03de\0\u03de"+
    "\0\u03de\0\u2394\0\u03de\0\u03de\0\u23d6\0\u2418\0\u245a\0\u0bdc"+
    "\0\u249c\0\u24de\0\u2520\0\u2562\0\u25a4\0\u25e6\0\u2628\0\u266a"+
    "\0\u03de\0\u26ac\0\u26ee\0\u03de\0\u03de\0\u2730\0\u2772\0\u03de"+
    "\0\u03de\0\u27b4\0\u27f6\0\u03de\0\u03de\0\u03de\0\u03de\0\u03de"+
    "\0\u03de\0\u2838\0\u287a\0\u28bc\0\u0fba\0\u28fe\0\u2940\0\u28bc"+
    "\0\u03de\0\u03de\0\u03de\0\u28fe\0\u2982\0\u10c2\0\u29c4\0\u2982"+
    "\0\u03de\0\u29c4\0\u2a06\0\u124e\0\u2a48\0\u11ca\0\u2a8a\0\u2acc"+
    "\0\u2a06\0\u2a48\0\u12d2\0\u1356\0\u1314\0\u1356\0\u2b0e\0\u2b50"+
    "\0\u03de\0\u2b92\0\u2bd4\0\u2c16\0\u03de\0\u03de\0\u03de\0\u03de"+
    "\0\u2c58\0\u2c9a\0\u2cdc\0\u2cdc\0\u2d1e\0\u2d60\0\u2da2\0\u2de4"+
    "\0\u2e26\0\u2e68\0\u2eaa\0\u19c8\0\u1a0a\0\u0630\0\u2eec\0\u0630"+
    "\0\u2f2e\0\u2f70\0\u2fb2\0\u2ff4\0\u3036\0\u3078\0\u30ba\0\u30fc"+
    "\0\u313e\0\u0630\0\u3180\0\u31c2\0\u3204\0\u0630\0\u3246\0\u3288"+
    "\0\u32ca\0\u330c\0\u0630\0\u0630\0\u334e\0\u3390\0\u33d2\0\u3414"+
    "\0\u3456\0\u3498\0\u34da\0\u351c\0\u355e\0\u35a0\0\u35e2\0\u3624"+
    "\0\u3666\0\u36a8\0\u36ea\0\u372c\0\u376e\0\u37b0\0\u03de\0\u0630"+
    "\0\u37f2\0\u3834\0\u3876\0\u38b8\0\u38fa\0\u393c\0\u397e\0\u39c0"+
    "\0\u3a02\0\u3a44\0\u3a86\0\u3ac8\0\u3b0a\0\u3b4c\0\u3b8e\0\u3bd0"+
    "\0\u3c12\0\u03de\0\u03de\0\u03de\0\u3c54\0\u3c96\0\u3cd8\0\u3d1a"+
    "\0\u3d5c\0\u03de\0\u3d9e\0\u03de\0\u3de0\0\u3e22\0\u03de\0\u03de"+
    "\0\u3e64\0\u03de\0\u3ea6\0\u2bd4\0\u2c16\0\u3ee8\0\u3f2a\0\u3f6c"+
    "\0\u3fae\0\u3ff0\0\u4032\0\u4074\0\u40b6\0\u0630\0\u40f8\0\u413a"+
    "\0\u0630\0\u417c\0\u41be\0\u4200\0\u4242\0\u4284\0\u42c6\0\u4308"+
    "\0\u434a\0\u438c\0\u43ce\0\u4410\0\u4452\0\u4494\0\u44d6\0\u4518"+
    "\0\u455a\0\u459c\0\u45de\0\u4620\0\u0630\0\u4662\0\u46a4\0\u46e6"+
    "\0\u4728\0\u476a\0\u47ac\0\u47ee\0\u4830\0\u4872\0\u48b4\0\u0630"+
    "\0\u0630\0\u48f6\0\u4938\0\u497a\0\u49bc\0\u49fe\0\u4a40\0\u4a82"+
    "\0\u4ac4\0\u4b06\0\u4b48\0\u4b8a\0\u4bcc\0\u4c0e\0\u4c50\0\u4c92"+
    "\0\u4cd4\0\u4d16\0\u4d58\0\u4d9a\0\u4ddc\0\u4e1e\0\u4e60\0\u4ea2"+
    "\0\u4ee4\0\u4f26\0\u4f68\0\u4faa\0\u03de\0\u4fec\0\u502e\0\u5070"+
    "\0\u50b2\0\u50f4\0\u0630\0\u5136\0\u5178\0\u51ba\0\u51fc\0\u523e"+
    "\0\u0630\0\u5280\0\u0630\0\u0630\0\u52c2\0\u5304\0\u5346\0\u5388"+
    "\0\u0630\0\u53ca\0\u0630\0\u0630\0\u540c\0\u544e\0\u5490\0\u0630"+
    "\0\u54d2\0\u5514\0\u0630\0\u5556\0\u0630\0\u5598\0\u55da\0\u0630"+
    "\0\u0630\0\u0630\0\u561c\0\u565e\0\u56a0\0\u56e2\0\u0630\0\u5724"+
    "\0\u5766\0\u0630\0\u57a8\0\u57ea\0\u582c\0\u586e\0\u58b0\0\u58f2"+
    "\0\u5934\0\u03de\0\u5976\0\u59b8\0\u59fa\0\u5a3c\0\u5a7e\0\u5ac0"+
    "\0\u5b02\0\u5b44\0\u5b86\0\u5bc8\0\u5c0a\0\u5c4c\0\u5c8e\0\u5cd0"+
    "\0\u03de\0\u5d12\0\u5d54\0\u5d96\0\u5dd8\0\u5e1a\0\u03de\0\u03de"+
    "\0\u5e5c\0\u5e9e\0\u5ee0\0\u5f22\0\u5f64\0\u5fa6\0\u5fe8\0\u0630"+
    "\0\u602a\0\u606c\0\u60ae\0\u60f0\0\u6132\0\u6174\0\u61b6\0\u0630"+
    "\0\u61f8\0\u623a\0\u627c\0\u62be\0\u6300\0\u6342\0\u0630\0\u0630"+
    "\0\u0630\0\u6384\0\u0630\0\u0630\0\u63c6\0\u6408\0\u644a\0\u648c"+
    "\0\u64ce\0\u6510\0\u03de\0\u6552\0\u6594\0\u65d6\0\u6618\0\u665a"+
    "\0\u03de\0\u669c\0\u66de\0\u6720\0\u6762\0\u67a4\0\u67e6\0\u6828"+
    "\0\u686a\0\u68ac\0\u68ee\0\u6930\0\u6972\0\u0630\0\u69b4\0\u69f6"+
    "\0\u6a38\0\u6a7a\0\u6abc\0\u6afe\0\u6b40\0\u6b82\0\u6bc4\0\u6c06"+
    "\0\u0630\0\u0630\0\u6c48\0\u0630\0\u6c8a\0\u6ccc\0\u6d0e\0\u6d50"+
    "\0\u0630\0\u6d92\0\u03de\0\u6dd4\0\u6e16\0\u6e58\0\u03de\0\u6e9a"+
    "\0\u0630\0\u6edc\0\u6f1e\0\u6f60\0\u6fa2\0\u6fe4\0\u7026\0\u7068"+
    "\0\u70aa\0\u70ec\0\u712e\0\u7170\0\u71b2\0\u71f4\0\u0630\0\u0630"+
    "\0\u7236\0\u7278\0\u72ba\0\u72fc\0\u733e\0\u0630\0\u7380\0\u0630"+
    "\0\u0630\0\u73c2\0\u7404\0\u03de\0\u03de\0\u0630\0\u7446\0\u7488"+
    "\0\u74ca\0\u750c\0\u0630\0\u754e\0\u7590\0\u75d2\0\u7614\0\u7656"+
    "\0\u7698\0\u76da\0\u0630\0\u0630\0\u771c\0\u0630\0\u775e\0\u77a0"+
    "\0\u0630\0\u77e2\0\u0630\0\u7824\0\u7866\0\u0630\0\u78a8\0\u78ea"+
    "\0\u792c\0\u796e\0\u0630\0\u0630\0\u79b0\0\u0630\0\u0630\0\u79f2"+
    "\0\u7a34\0\u7a76\0\u7ab8\0\u0630\0\u7afa\0\u7b3c\0\u7b7e\0\u7bc0"+
    "\0\u7c02\0\u7c44\0\u7c86\0\u7cc8\0\u7d0a\0\u7d4c\0\u03de\0\u7d8e"+
    "\0\u0630\0\u0630\0\u0630\0\u7dd0\0\u7e12\0\u7e54\0\u0630\0\u7e96"+
    "\0\u7ed8\0\u7f1a\0\u7f5c\0\u0630\0\u7f9e\0\u7fe0\0\u8022\0\u8064"+
    "\0\u80a6\0\u80e8\0\u812a\0\u816c\0\u81ae\0\u81f0\0\u8232\0\u8274"+
    "\0\u03de\0\u82b6";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[690];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\61\16\1\17\20\16\1\20\1\21\1\22\1\23\1\24"+
    "\1\25\1\26\1\27\1\30\1\21\1\31\3\32\1\33"+
    "\1\34\1\35\1\36\1\37\1\40\1\41\1\42\1\43"+
    "\1\44\1\45\1\46\1\47\1\50\1\51\1\52\2\31"+
    "\1\53\1\54\1\31\1\55\1\56\1\31\1\57\1\60"+
    "\1\61\1\62\1\63\1\64\1\31\1\65\1\31\1\66"+
    "\1\67\1\70\1\71\1\72\1\73\1\74\1\75\1\76"+
    "\1\77\1\100\1\101\1\102\1\103\1\104\1\105\1\51"+
    "\1\106\1\107\16\110\1\111\1\112\1\113\1\110\1\114"+
    "\57\110\16\115\1\116\1\115\1\117\1\120\1\121\57\115"+
    "\3\122\1\123\2\122\3\123\1\122\1\123\1\124\1\122"+
    "\1\124\1\125\1\122\1\126\1\122\1\127\1\122\22\123"+
    "\3\122\1\123\2\122\3\123\20\122\1\123\2\122\102\130"+
    "\3\131\1\132\2\131\3\132\1\131\1\132\1\133\1\131"+
    "\1\133\6\131\22\132\3\131\1\132\2\131\3\132\20\131"+
    "\1\132\2\131\3\134\1\135\2\134\3\135\1\134\1\135"+
    "\3\32\6\134\22\135\1\136\2\134\1\135\2\134\3\135"+
    "\20\134\1\135\2\134\3\137\1\140\2\137\3\140\1\137"+
    "\1\140\11\137\22\140\3\137\1\140\2\137\3\140\20\137"+
    "\1\140\2\137\1\20\1\141\1\142\1\31\1\143\1\144"+
    "\3\31\1\141\1\31\3\145\1\33\1\146\1\145\1\147"+
    "\1\150\1\40\22\31\1\151\1\152\1\153\1\31\1\154"+
    "\1\64\3\31\1\155\1\156\1\157\1\160\1\161\1\162"+
    "\1\163\1\164\1\165\1\77\1\100\1\166\1\102\1\167"+
    "\1\104\1\170\1\31\2\145\62\171\1\172\17\171\15\173"+
    "\1\174\44\173\1\175\17\173\13\176\1\177\1\176\1\200"+
    "\31\176\1\201\14\176\1\202\7\176\1\202\5\176\61\16"+
    "\1\203\101\16\1\0\2\16\1\204\7\16\1\205\2\16"+
    "\1\206\2\16\103\0\1\21\1\207\1\210\1\0\1\21"+
    "\3\0\1\21\71\0\1\207\3\0\1\207\3\0\1\207"+
    "\45\0\1\211\23\0\1\31\1\0\1\31\1\0\1\31"+
    "\1\212\4\31\11\0\5\31\1\213\1\214\6\31\1\215"+
    "\3\31\1\216\3\0\1\217\2\0\3\31\20\0\1\31"+
    "\6\0\1\220\52\0\1\221\23\0\1\21\1\207\1\210"+
    "\1\0\1\21\1\222\1\0\1\223\1\21\71\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\7\31\1\224\12\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\3\31\1\225\2\31\11\0\5\31"+
    "\1\226\2\31\1\227\1\230\10\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\227\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\4\0\1\34\4\0\11\31\1\231\10\31\3\0"+
    "\1\31\2\0\3\31\2\0\1\232\15\0\1\31\1\233"+
    "\2\0\1\31\1\0\1\31\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\15\0\3\32"+
    "\67\0\1\234\2\0\3\234\1\0\1\234\11\0\22\234"+
    "\3\0\1\234\2\0\3\234\20\0\1\234\2\0\16\235"+
    "\1\236\1\237\1\240\1\235\1\241\57\235\1\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\3\31\1\242\1\31"+
    "\1\243\2\31\1\244\10\31\1\245\3\0\1\31\2\0"+
    "\3\31\20\0\1\244\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\11\31\1\246\1\31\1\247\6\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\250\1\0\6\31\11\0\1\251\6\31\1\252\12\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\1\253\3\31\1\254"+
    "\2\31\1\255\12\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\5\31\1\256\2\31\1\257\11\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\257\3\0\1\31\1\0\1\260\1\0"+
    "\2\31\1\261\3\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\2\31\1\262\3\31\11\0\7\31\1\263\5\31\1\264"+
    "\4\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\11\31\1\265"+
    "\10\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\31\1\266"+
    "\12\31\1\267\5\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\270\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\13\31\1\271"+
    "\6\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\272\21\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\7\31\1\273\5\31"+
    "\1\274\4\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\4\31"+
    "\1\275\4\31\1\276\10\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\50\0\1\277\1\300\7\0\1\301\71\0"+
    "\1\302\7\0\1\303\72\0\1\304\32\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\305\3\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\11\0\1\306\1\307"+
    "\3\0\1\310\7\0\1\311\1\0\1\312\1\313\1\314"+
    "\2\0\1\315\1\316\1\317\41\0\1\316\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\22\31\3\0\1\31"+
    "\2\0\1\31\1\320\1\31\20\0\1\31\51\0\1\321"+
    "\7\0\1\322\101\0\1\323\71\0\1\324\7\0\1\325"+
    "\1\0\1\326\1\0\1\327\75\0\1\330\101\0\1\331"+
    "\2\0\1\332\1\107\65\0\1\333\7\0\1\334\101\0"+
    "\1\335\5\0\1\336\73\0\1\337\6\0\1\340\72\0"+
    "\1\341\71\0\1\342\32\0\20\233\1\343\57\233\1\237"+
    "\1\233\16\110\1\344\1\0\1\345\1\110\1\346\62\110"+
    "\1\347\2\110\3\347\1\110\1\347\3\110\1\350\1\351"+
    "\1\345\1\110\1\352\1\110\22\347\3\110\1\347\2\110"+
    "\3\347\20\110\1\347\122\110\1\353\1\351\1\345\1\110"+
    "\1\354\57\110\16\115\1\355\1\115\1\356\1\0\1\357"+
    "\62\115\1\347\2\115\3\347\1\115\1\347\3\115\1\360"+
    "\1\115\1\356\1\361\1\352\1\115\22\347\3\115\1\347"+
    "\2\115\3\347\20\115\1\347\122\115\1\353\1\115\1\356"+
    "\1\361\1\362\57\115\13\122\1\124\1\122\1\124\1\363"+
    "\1\122\1\364\1\122\1\365\60\122\1\123\1\122\1\123"+
    "\1\122\6\123\1\366\1\122\1\366\1\363\1\122\1\364"+
    "\1\122\1\365\1\367\22\123\3\122\1\123\2\122\3\123"+
    "\20\122\1\123\5\122\1\370\2\122\3\370\1\122\1\370"+
    "\1\124\1\122\1\124\1\363\1\122\1\364\1\122\1\365"+
    "\1\122\22\370\3\122\1\370\2\122\3\370\20\122\1\370"+
    "\5\122\1\347\2\122\3\347\1\122\1\347\1\124\1\122"+
    "\1\124\1\371\1\122\1\364\1\122\1\352\1\122\22\347"+
    "\3\122\1\347\2\122\3\347\20\122\1\347\15\122\1\124"+
    "\1\122\1\124\77\122\1\124\1\122\1\124\1\353\1\122"+
    "\1\364\1\122\1\372\57\122\13\373\1\374\1\373\1\374"+
    "\65\373\1\375\1\373\1\375\1\373\6\375\1\376\1\373"+
    "\1\376\5\373\1\377\22\375\3\373\1\375\2\373\3\375"+
    "\20\373\1\375\5\373\1\u0100\2\373\3\u0100\1\373\1\u0100"+
    "\1\374\1\373\1\374\6\373\22\u0100\3\373\1\u0100\2\373"+
    "\3\u0100\20\373\1\u0100\2\373\1\0\1\135\1\0\1\135"+
    "\1\0\6\135\11\0\22\135\3\0\1\135\2\0\3\135"+
    "\20\0\1\135\51\0\1\u0101\33\0\1\140\1\0\1\140"+
    "\1\0\6\140\11\0\22\140\3\0\1\140\2\0\3\140"+
    "\20\0\1\140\3\0\1\141\3\0\1\141\3\0\1\141"+
    "\71\0\1\u0102\3\0\1\u0102\1\u0103\1\0\1\u0104\1\u0102"+
    "\70\0\62\171\1\0\17\171\63\0\1\u0105\31\0\1\173"+
    "\151\0\1\u0106\16\0\13\176\1\177\1\176\1\200\31\176"+
    "\1\177\14\176\1\177\7\176\1\177\5\176\13\0\1\177"+
    "\135\0\1\u0107\32\0\61\16\1\0\2\16\1\0\7\16"+
    "\1\0\2\16\1\0\2\16\57\0\1\u0108\66\0\1\u0109"+
    "\12\0\1\u0108\54\0\1\u010a\50\0\1\207\1\0\1\210"+
    "\1\0\1\207\3\0\1\207\71\0\1\u010b\2\0\1\u010c"+
    "\1\u010b\3\0\1\u010b\34\0\1\u010c\34\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\1\u010d\1\u010e\20\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\2\31\1\u010f\17\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\13\31\1\u0110\6\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\10\31\1\u0111\11\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\u0111\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\20\31\1\u0112\1\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\u0113\3\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\u0114\1\0"+
    "\1\u0114\1\0\1\u0114\1\0\3\u0114\14\0\2\u0114\2\0"+
    "\1\u0114\54\0\1\u0115\3\0\1\u0115\71\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\11\31\1\u0116\10\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\10\31\1\u0117\11\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\u0117\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\2\31\1\u0118\17\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\11\31\1\u0119\10\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u011a\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\63\0\1\u011b\21\0\1\234\1\0"+
    "\1\234\1\0\6\234\11\0\22\234\3\0\1\234\2\0"+
    "\3\234\20\0\1\234\2\0\3\235\1\0\2\235\3\0"+
    "\1\235\1\0\3\235\1\236\1\237\1\240\1\235\1\0"+
    "\1\235\22\0\3\235\1\0\2\235\3\0\20\235\1\0"+
    "\122\235\1\0\1\237\1\240\1\235\1\241\57\235\1\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\31\1\u011c"+
    "\4\31\1\u011d\1\31\1\u011e\11\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\u011e\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\10\31\1\u011f\11\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\u011f\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\20\31\1\u0120\1\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\2\31\1\u0121\3\31\11\0\12\31\1\u0122\7\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\11\31\1\u0123\10\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\3\31\1\u0124\2\31\1\u0125"+
    "\13\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u0126\1\0\6\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\5\31\1\u0127\14\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\5\31\1\u0128\14\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\11\31\1\u0129\10\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\10\31\1\u012a\11\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\u012a\3\0\1\31\1\0"+
    "\1\u012b\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\14\31\1\u012c\5\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\21\31\1\u012d\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\1\31\1\u012e\6\31\1\u012f\4\31\1\u0130\4\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\u012f\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u0131\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\2\31\1\u0132\3\31\11\0\7\31"+
    "\1\u0133\12\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\u0134\3\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\u0135"+
    "\21\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\31\1\u0136"+
    "\20\31\3\0\1\31\2\0\2\31\1\u0137\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\u0138"+
    "\21\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\10\31\1\u0139"+
    "\11\31\3\0\1\31\2\0\3\31\20\0\1\u0139\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\31\1\u013a"+
    "\20\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\7\31\1\u013b"+
    "\12\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\3\31\1\u013c\2\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\u013d\6\31"+
    "\1\u013e\12\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\61\0\1\u013f\23\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\11\31\1\u0140\10\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\37\0\1\u0141\70\0\1\u0142\6\0\1\u0143"+
    "\77\0\1\u0144\103\0\1\u0145\107\0\1\u0146\71\0\1\u0147"+
    "\60\0\1\u0148\116\0\1\u0149\57\0\1\u014a\77\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\2\31\1\u014b\1\u014c"+
    "\1\31\1\u014d\1\u014e\4\31\1\u014f\1\31\1\u0150\3\31"+
    "\1\u0151\3\0\1\31\2\0\3\31\20\0\1\31\61\0"+
    "\1\u0152\101\0\1\u0153\101\0\1\u0154\1\0\1\u0155\54\0"+
    "\1\u0156\42\0\1\u0156\15\0\3\u0157\44\0\1\u0158\12\0"+
    "\1\u0159\17\0\1\u015a\1\0\1\u015b\77\0\1\u015c\1\0"+
    "\1\u015d\64\0\102\233\3\110\1\0\2\110\3\0\1\110"+
    "\1\0\3\110\1\350\1\351\1\345\1\110\1\0\1\110"+
    "\22\0\3\110\1\0\2\110\3\0\20\110\1\0\20\110"+
    "\1\0\1\351\1\345\1\110\1\354\57\110\1\0\1\347"+
    "\1\0\1\347\1\0\6\347\11\0\22\347\1\u015e\2\0"+
    "\1\347\2\0\3\347\12\0\1\u015f\5\0\1\347\2\0"+
    "\3\115\1\0\2\115\3\0\1\115\1\0\3\115\1\360"+
    "\1\115\1\356\1\361\1\0\1\115\22\0\3\115\1\0"+
    "\2\115\3\0\20\115\1\0\20\115\1\0\1\115\1\356"+
    "\1\361\1\362\57\115\3\122\1\0\2\122\3\0\1\122"+
    "\1\0\1\124\1\122\1\124\1\371\1\122\1\364\1\122"+
    "\1\0\1\122\22\0\3\122\1\0\2\122\3\0\20\122"+
    "\1\0\15\122\1\124\1\122\1\124\1\0\1\122\1\364"+
    "\1\122\1\372\72\122\1\366\1\122\1\366\1\363\1\122"+
    "\1\364\1\122\1\365\60\122\1\370\1\122\1\370\1\122"+
    "\6\370\1\u0160\1\122\1\u0160\1\363\1\122\1\364\1\122"+
    "\1\365\1\u0161\22\370\3\122\1\370\2\122\3\370\20\122"+
    "\1\370\2\122\13\373\1\376\1\373\1\376\65\373\1\u0100"+
    "\1\373\1\u0100\1\373\6\u0100\1\u0162\1\373\1\u0162\5\373"+
    "\1\u0163\22\u0100\3\373\1\u0100\2\373\3\u0100\20\373\1\u0100"+
    "\2\373\1\0\1\u0102\3\0\1\u0102\3\0\1\u0102\71\0"+
    "\1\u0164\1\0\1\u0164\1\0\1\u0164\1\0\3\u0164\14\0"+
    "\2\u0164\2\0\1\u0164\54\0\1\u0165\3\0\1\u0165\127\0"+
    "\1\u0166\77\0\1\u0167\45\0\1\u010b\3\0\1\u010b\3\0"+
    "\1\u010b\71\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\31\1\u0126\20\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\u0168\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\u0169\1\31"+
    "\1\u016a\1\u016b\4\31\1\u016c\3\31\1\u016d\5\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\u016c\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\7\31\1\u016e\12\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u016f\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u0170\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\15\31\1\u0171\4\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u0172\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\2\31\1\u0173\3\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\2\31\1\u0174\3\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\63\0\1\u0155\21\0\1\31\1\0"+
    "\1\u0175\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\15\31\1\u0176\4\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u0177\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u0178\1\0"+
    "\6\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\15\31\1\u0179\4\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\u017a\21\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\7\31"+
    "\1\u017b\12\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\u017c\3\31"+
    "\11\0\1\u017d\21\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\15\31\1\u017e\4\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\2\31\1\u017f"+
    "\3\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\6\31\1\u0180\13\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\u0181\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u0182\1\0\6\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u0183\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\6\31\1\u0184\13\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u0185\1\0"+
    "\6\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\15\31\1\u0186\4\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\31\1\u0187\6\31\1\u0188\11\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\u0188\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\10\31\1\u0189\11\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\u0189\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\5\31\1\u018a\14\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u018b\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u018c\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\4\31\1\u018d\15\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\4\31\1\u018e\15\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\15\31\1\u018f\4\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u0190\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\7\31\1\u0191\12\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\1\u0192\2\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\15\31\1\u0193\4\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\5\31\1\u0194\14\31\3\0\1\u0195\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u0196\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\37\0\1\u0197\75\0\1\u0198\103\0"+
    "\1\u0199\73\0\1\u019a\104\0\1\u019b\104\0\1\u019c\102\0"+
    "\1\u019d\42\0\1\u019d\56\0\1\u019e\62\0\1\u019f\53\0"+
    "\1\u01a0\73\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\u01a1\21\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\u01a2"+
    "\3\31\1\u01a3\15\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\2\31\1\u01a4"+
    "\3\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\15\31\1\u01a5\4\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\2\31\1\u01a6"+
    "\3\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\u01a7\21\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\u01a8\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\5\0\1\u01a9"+
    "\2\0\3\u01a9\1\0\1\u01a9\1\0\1\u0155\2\0\1\u01aa"+
    "\4\0\22\u01a9\3\0\1\u01a9\2\0\3\u01a9\20\0\1\u01a9"+
    "\1\u01ab\33\0\1\u01ac\62\0\3\u0157\57\0\1\u0159\67\0"+
    "\1\u01ad\67\0\1\u01ae\43\0\1\u015a\101\0\1\u015c\135\0"+
    "\1\u01af\32\0\13\122\1\u0160\1\122\1\u0160\1\363\1\122"+
    "\1\364\1\122\1\365\57\122\13\373\1\u0162\1\373\1\u0162"+
    "\64\373\44\0\1\u01b0\61\0\1\u01b1\56\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\5\31\1\u01b2\14\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\3\31\1\u01b3\16\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u01b4\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\7\31\1\u01b5\12\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\14\31\1\u01b6\5\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\13\31\1\u01b7\6\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\u01b8\21\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\12\31\1\u01b9\7\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\11\31\1\u01ba\10\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\12\31\1\u01bb\7\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\16\31\1\u01bc\3\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\11\31\1\u01bd\10\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\4\31\1\u01be\15\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u01bf\1\0\2\31"+
    "\1\u01c0\3\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\1\31\1\u01c1\20\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u01c2\1\0\6\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u01c3\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\14\31"+
    "\1\u01c4\5\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\4\31"+
    "\1\u01c5\15\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\5\31"+
    "\1\u01c6\14\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\u01c7\3\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\15\31"+
    "\1\u01c8\4\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u01c9\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\u01ca\3\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u01cb\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\10\31"+
    "\1\u01cc\11\31\3\0\1\31\2\0\3\31\20\0\1\u01cc"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\13\31"+
    "\1\u01cd\6\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\u01ce\3\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\u01cf"+
    "\21\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\31\1\u01d0"+
    "\20\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\10\31\1\u01d1"+
    "\11\31\3\0\1\31\2\0\3\31\20\0\1\u01d1\3\0"+
    "\1\31\1\0\1\u01d2\1\0\6\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\1\u01d3\21\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\6\31\1\u01d4\13\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\11\31\1\u01d5\10\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\1\u01d6\21\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\u01d7\1\0"+
    "\6\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\2\31\1\u01d8"+
    "\3\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\u01d9\21\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u01da\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\2\31\1\u01db\3\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\u01dc\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\11\0\1\u01dd"+
    "\101\0\1\u01de\133\0\1\u01df\43\0\1\u01e0\10\0\1\u01e1"+
    "\36\0\1\u01e2\36\0\1\u01e3\100\0\1\u01e4\75\0\1\u01e5"+
    "\101\0\1\u01e6\122\0\1\u01e7\116\0\1\u01e8\41\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\11\31\1\u01e9\10\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\15\31\1\u01ea\4\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u01eb\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\21\31\1\u01ec\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\u01ed\3\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\15\31\1\u01ee\4\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\5\31\1\u01ef\14\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\1\31\1\u01f0\20\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\u01a9\1\0"+
    "\1\u01a9\1\0\6\u01a9\1\u01f1\1\0\1\u01f2\6\0\22\u01a9"+
    "\3\0\1\u01a9\2\0\3\u01a9\20\0\1\u01a9\5\0\1\u01f3"+
    "\2\0\3\u01f3\1\0\1\u01f3\11\0\22\u01f3\3\0\1\u01f3"+
    "\2\0\3\u01f3\20\0\1\u01f3\5\0\1\u01f4\2\0\3\u01f4"+
    "\1\0\1\u01f4\11\0\22\u01f4\3\0\1\u01f4\2\0\3\u01f4"+
    "\20\0\1\u01f4\37\0\1\u01f5\53\0\1\u01f6\75\0\1\u01f7"+
    "\2\0\3\u01f7\1\0\1\u01f7\11\0\22\u01f7\3\0\1\u01f7"+
    "\2\0\3\u01f7\20\0\1\u01f7\15\0\2\u01f8\1\u01f9\130\0"+
    "\1\u01fa\36\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\2\31\1\u01fb\17\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\6\31\1\u01fc\13\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\11\31\1\u01fd\10\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\1\u01fe\21\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\u01ff"+
    "\21\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\3\31\1\u0200"+
    "\16\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\2\31\1\u0201\3\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\3\31\1\u0202"+
    "\16\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\2\31\1\u0203"+
    "\17\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\2\31\1\u0204\3\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\5\31\1\u0205"+
    "\14\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\21\31\1\u0206"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\15\31\1\u0207\4\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u0208\1\0\6\31\11\0\22\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\11\31\1\u0209\10\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\1\u020a\21\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\6\31\1\u020b\13\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\20\31\1\u020c\1\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\3\31\1\u020d\2\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\5\31\1\u020e\14\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\6\31\1\u020f\13\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\13\31\1\u0210\6\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\5\31\1\u0211\14\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\11\31\1\u0212\10\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\15\31\1\u0213\4\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\6\31\1\u0214\13\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\1\31\1\u0215\20\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\6\31\1\u0216\13\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\40\0\1\u0217\100\0\1\u0218\47\0"+
    "\1\u0219\10\0\1\u021a\36\0\1\u021b\71\0\1\u021c\52\0"+
    "\1\u01e1\36\0\1\u01e2\67\0\1\u021d\65\0\1\u01e8\101\0"+
    "\1\u021e\106\0\1\u021f\100\0\1\u0220\64\0\1\u01e8\36\0"+
    "\1\u0221\27\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\1\31\1\u0222\1\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\u0223\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\6\31\1\u0224"+
    "\13\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u0225\1\0\6\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\10\31\1\u0226\11\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\u0226\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\1\31\1\u0227\20\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\u0228\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\13\31\1\u0229\6\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\15\0\1\u01f1\67\0\1\u01f3\1\0"+
    "\1\u01f3\1\0\6\u01f3\4\0\1\u022a\4\0\22\u01f3\3\0"+
    "\1\u01f3\2\0\3\u01f3\20\0\1\u01f3\3\0\1\u01f4\1\0"+
    "\1\u01f4\1\0\6\u01f4\11\0\22\u01f4\3\0\1\u01f4\2\0"+
    "\3\u01f4\20\0\1\u01f4\1\u022a\25\0\1\u022b\112\0\1\u022c"+
    "\57\0\1\u01f8\113\0\1\u022d\55\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\10\31\1\u022e\11\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\u022e\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\15\31\1\u022f\4\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\u0230"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\1\31\1\u0231\20\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\15\31\1\u0232\4\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\6\31\1\u0233\13\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\2\31"+
    "\1\u0234\3\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u0235\1\0\6\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\2\31"+
    "\1\u0236\17\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\6\31"+
    "\1\u0237\13\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\u0238\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\1\31\1\u0239\20\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u023a\1\0\6\31\11\0\22\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\7\31\1\u023b\12\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\13\31\1\u023c\6\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\2\31\1\u023d\3\31\11\0\22\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\15\31\1\u023e\4\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\4\31\1\u023f\15\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\u0240"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u0241\1\0\6\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u0242\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\16\0\1\u0217\36\0\1\u0243\64\0\1\u0244\52\0\1\u0245"+
    "\106\0\1\u021a\36\0\1\u021b\31\0\1\u0246\101\0\1\u01e8"+
    "\112\0\1\u021e\36\0\1\u0247\53\0\1\u0248\117\0\1\u0244"+
    "\37\0\1\31\1\0\1\31\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\1\31\1\u0249\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\1\31\1\u024a\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u024b\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\10\31"+
    "\1\u024c\11\31\3\0\1\31\2\0\3\31\20\0\1\u024c"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\10\31"+
    "\1\u024d\11\31\3\0\1\31\2\0\3\31\20\0\1\u024d"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\1\31\1\u024e\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\1\31\1\u024f\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\7\31"+
    "\1\u0250\12\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\15\0\1\u01f1\1\0\1\u01f2\130\0\1\u0251\50\0\3\u0252"+
    "\77\0\3\u0253\65\0\1\31\1\0\1\31\1\0\2\31"+
    "\1\u0254\3\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\2\31"+
    "\1\u0255\3\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\6\31\1\u0256\13\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u0257\1\0\6\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\1\31"+
    "\1\u0258\20\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\6\31"+
    "\1\u0259\13\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\1\31\1\u025a\1\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\31\1\0\6\31\11\0\7\31"+
    "\1\u025b\12\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\3\0\1\31\1\0\1\u025c\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u025d\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u025e\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\6\31\1\u025f\13\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u0260\1\0\6\31\11\0\22\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\u0261"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\22\31\3\0\1\31\2\0\1\31\1\u0262\1\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\u0263\1\0\6\31"+
    "\11\0\22\31\3\0\1\31\2\0\3\31\20\0\1\31"+
    "\16\0\1\u0244\36\0\1\u0264\57\0\1\u021a\105\0\1\u01e1"+
    "\60\0\1\u0248\36\0\1\u0265\27\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\1\31"+
    "\1\u0266\1\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\1\u0267\21\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\20\31\1\u0268\1\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\22\31\3\0\1\31\2\0\1\31\1\u0269"+
    "\1\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\6\31\1\u026a\13\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\22\31\3\0\1\31\2\0\1\31\1\u026b"+
    "\1\31\20\0\1\31\3\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\2\31\1\u026c\17\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\27\0\1\u026d\57\0\1\u026e\2\0"+
    "\3\u026e\1\0\1\u026e\3\u0252\1\u026f\5\0\22\u026e\3\0"+
    "\1\u026e\2\0\3\u026e\20\0\1\u026e\15\0\3\u0253\23\0"+
    "\1\u0270\41\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\11\31\1\u0271\10\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\6\31\1\u0272\13\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\13\31\1\u0273\6\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\u0274\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\7\31\1\u0275"+
    "\12\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\3\31\1\u0276"+
    "\16\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\7\31\1\u0277"+
    "\12\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\31\1\0\6\31\11\0\1\31\1\u0278"+
    "\20\31\3\0\1\31\2\0\3\31\20\0\1\31\3\0"+
    "\1\31\1\0\1\u0279\1\0\6\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\7\31\1\u027a\12\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\2\31\1\u027b\17\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\7\31\1\u027c\12\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\2\31\1\u027d\3\31\11\0\22\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\1\31\1\u027e\1\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\7\31\1\u027f\12\31\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\1\31\1\u0280\1\31\20\0\1\31\15\0\3\u026d\31\0"+
    "\1\342\33\0\1\u026e\1\0\1\u026e\1\0\6\u026e\3\u0281"+
    "\6\0\22\u026e\3\0\1\u026e\2\0\3\u026e\20\0\1\u026e"+
    "\5\0\1\u026e\2\0\3\u026e\1\0\1\u026e\11\0\22\u026e"+
    "\3\0\1\u026e\2\0\3\u026e\20\0\1\u026e\11\0\1\u0282"+
    "\73\0\1\31\1\0\1\u0283\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\13\31\1\u0284\6\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u0285\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\3\31\1\u0286\16\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\10\31\1\u0287\11\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\u0287\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u0288\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\5\31\1\u0289\14\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\6\31\1\u028a\13\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\31\1\0\6\31\11\0\21\31\1\u028b\3\0"+
    "\1\31\2\0\3\31\20\0\1\31\3\0\1\31\1\0"+
    "\1\31\1\0\6\31\11\0\22\31\3\0\1\31\2\0"+
    "\1\31\1\u028c\1\31\20\0\1\31\5\0\1\u028d\2\0"+
    "\3\u028d\1\0\1\u028d\3\u0281\2\0\1\u028e\3\0\22\u028d"+
    "\3\0\1\u028d\2\0\3\u028d\3\0\1\u028f\3\0\1\u028e"+
    "\10\0\1\u028d\33\0\1\u0290\51\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\6\31\1\u0291\13\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\6\31\1\u0292\13\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\1\31"+
    "\1\u0293\1\31\20\0\1\31\3\0\1\31\1\0\1\u0294"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\31\1\0\1\31\1\0\6\31"+
    "\11\0\20\31\1\u0295\1\31\3\0\1\31\2\0\3\31"+
    "\20\0\1\31\3\0\1\u028d\1\0\1\u028d\1\0\6\u028d"+
    "\3\u0296\2\0\1\u028e\3\0\22\u028d\3\0\1\u028d\2\0"+
    "\3\u028d\3\0\1\u028f\3\0\1\u028e\10\0\1\u028d\5\0"+
    "\1\u028d\2\0\3\u028d\1\0\1\u028d\3\u0296\2\0\1\u028e"+
    "\3\0\22\u028d\3\0\1\u028d\2\0\3\u028d\3\0\1\u028f"+
    "\3\0\1\u028e\10\0\1\u028d\65\0\1\u0297\61\0\1\u0298"+
    "\37\0\1\31\1\0\1\u0299\1\0\6\31\11\0\22\31"+
    "\3\0\1\31\2\0\3\31\20\0\1\31\3\0\1\31"+
    "\1\0\1\u029a\1\0\6\31\11\0\22\31\3\0\1\31"+
    "\2\0\3\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\1\31"+
    "\1\u029b\1\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\22\31\3\0\1\31\2\0\1\31"+
    "\1\u029c\1\31\20\0\1\31\3\0\1\31\1\0\1\31"+
    "\1\0\6\31\11\0\1\u029d\21\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\15\0\3\u0296\44\0\1\u028f\47\0"+
    "\1\u029e\52\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\22\31\3\0\1\31\2\0\1\31\1\u029f\1\31\20\0"+
    "\1\31\3\0\1\31\1\0\1\31\1\0\6\31\11\0"+
    "\15\31\1\u02a0\4\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\11\0\1\u02a1\73\0\1\31\1\0\1\u02a2\1\0"+
    "\6\31\11\0\22\31\3\0\1\31\2\0\3\31\20\0"+
    "\1\31\45\0\1\u02a3\37\0\1\31\1\0\1\31\1\0"+
    "\6\31\11\0\11\31\1\u02a4\10\31\3\0\1\31\2\0"+
    "\3\31\20\0\1\31\5\0\1\u02a5\111\0\3\u02a5\41\0"+
    "\1\u02a6\35\0\3\u02a6\1\0\1\u02a7\24\0\1\u02a8\33\0"+
    "\1\u02a9\45\0\1\u02aa\74\0\1\u02ab\106\0\1\u02ac\74\0"+
    "\1\u02ad\106\0\1\u02ae\74\0\1\u02af\106\0\1\u02b0\50\0"+
    "\3\u02ae\31\0\1\u02b1\76\0\1\u02b2\54\0\1\u02ae\162\0"+
    "\1\u02ae\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[33528];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\4\0\1\1\10\0\2\1\1\11\14\1\4\11\23\1"+
    "\1\11\12\1\4\11\1\1\2\11\1\1\1\11\2\1"+
    "\1\11\5\1\1\11\7\1\1\11\3\1\1\11\2\1"+
    "\1\11\2\1\2\11\1\1\24\11\2\1\1\11\3\1"+
    "\1\11\1\1\1\11\1\1\1\0\4\1\1\0\1\11"+
    "\6\1\2\11\2\0\6\1\2\0\1\1\2\0\1\11"+
    "\2\0\35\1\3\11\1\1\2\11\1\1\12\0\1\1"+
    "\1\11\2\1\2\11\1\1\1\0\2\11\2\1\6\11"+
    "\1\1\4\0\2\1\3\11\1\1\3\0\1\1\1\11"+
    "\1\1\3\0\5\1\3\0\1\1\2\0\1\11\1\1"+
    "\2\0\4\11\2\0\1\1\1\0\16\1\1\0\43\1"+
    "\1\11\1\1\12\0\7\1\3\11\3\0\1\1\1\0"+
    "\1\11\1\1\1\11\1\1\1\0\2\11\1\1\1\11"+
    "\1\0\2\1\2\0\57\1\12\0\10\1\4\0\1\11"+
    "\4\0\53\1\5\0\1\11\6\0\10\1\1\11\1\1"+
    "\4\0\2\11\1\1\1\0\34\1\4\0\1\11\5\0"+
    "\1\11\10\1\4\0\25\1\1\11\3\0\1\11\1\0"+
    "\10\1\3\0\20\1\2\11\7\1\4\0\20\1\2\0"+
    "\12\1\4\0\5\1\1\0\1\11\1\0\5\1\1\0"+
    "\2\1\1\0\1\1\1\0\1\1\14\0\1\11\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[690];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
	private final LinkedList commentList = new LinkedList();
	private String heredoc = null;
	private String nowdoc = null;
    private boolean asp_tags = false;
    private boolean short_tags_allowed = true;
    private StateStack stack = new StateStack();
    private char yy_old_buffer[] = new char[ZZ_BUFFERSIZE];
    private int yy_old_pushbackPos;
    protected int commentStartPosition;

	private AST ast;

    public void setAST(AST ast) {
    	this.ast = ast;
    }
    
	public PHPVersion getPHPVersion() {
		return PHPVersion.PHP5_4;
	}
    
	public void setInScriptingState() {
		yybegin(ST_IN_SCRIPTING);
	}

	public void resetCommentList() {
		commentList.clear();
	}
	
	public LinkedList getCommentList() {
		return commentList;
	}	
	
	protected void addComment(int type) {
		int leftPosition = getTokenStartPosition();
		Comment comment = new Comment(commentStartPosition, leftPosition + getTokenLength(), ast, type);
		commentList.add(comment);
	}	
	
	public void setUseAspTagsAsPhp(boolean useAspTagsAsPhp) {
		asp_tags = useAspTagsAsPhp;
	}
	
	public void setUseShortTags(boolean useShortTags) {
		short_tags_allowed = useShortTags;
	}
	
    private void pushState(int state) {
        stack.pushStack(zzLexicalState);
        yybegin(state);
    }

    private void popState() {
        yybegin(stack.popStack());
    }

    public int getCurrentLine() {
        return yyline;
    }

    protected int getTokenStartPosition() {
        return zzStartRead - zzPushbackPos;
    }

    protected int getTokenLength() {
        return zzMarkedPos - zzStartRead;
    }

    public int getLength() {
        return zzEndRead - zzPushbackPos;
    }
    
    private void handleCommentStart() {
		commentStartPosition = getTokenStartPosition();
	}
	
	private void handleLineCommentEnd() {
         addComment(Comment.TYPE_SINGLE_LINE);
    }
    
    private void handleMultilineCommentEnd() {
    	addComment(Comment.TYPE_MULTILINE);
    }

    private void handlePHPDocEnd() {
		addComment(Comment.TYPE_PHPDOC);
    }
    
    protected void handleVarComment() {
    	commentStartPosition = zzStartRead;
    	addComment(Comment.TYPE_MULTILINE);
    }
        
    private Symbol createFullSymbol(int symbolNumber) {
        Symbol symbol = createSymbol(symbolNumber);
        symbol.value = yytext();
        return symbol;
    }

    protected Symbol createSymbol(int symbolNumber) {
        int leftPosition = getTokenStartPosition();
        return new Symbol(symbolNumber, leftPosition, leftPosition + getTokenLength());
    }

    public int[] getParamenters(){
    	return new int[]{zzMarkedPos, zzPushbackPos, zzCurrentPos, zzStartRead, zzEndRead, yyline};
    }
    
	protected boolean parsePHPDoc(){	
		final IDocumentorLexer documentorLexer = getDocumentorLexer(zzReader);
		if(documentorLexer == null){
			return false;
		}
		yypushback(zzMarkedPos - zzStartRead);
		int[] parameters = getParamenters();
		documentorLexer.reset(zzReader, zzBuffer, parameters);
		Object phpDocBlock = documentorLexer.parse();
		commentList.add(phpDocBlock);
		reset(zzReader, documentorLexer.getBuffer(), documentorLexer.getParamenters());
		return true;
	}
	
	
	protected IDocumentorLexer getDocumentorLexer(java.io.Reader  reader) {
		return null;
	}
	
	public void reset(java.io.Reader  reader, char[] buffer, int[] parameters){
		this.zzReader = reader;
		this.zzBuffer = buffer;
		this.zzMarkedPos = parameters[0];
		this.zzPushbackPos = parameters[1];
		this.zzCurrentPos = parameters[2];
		this.zzStartRead = parameters[3];
		this.zzEndRead = parameters[4];
		this.yyline = parameters[5];  
		this.yychar = this.zzStartRead - this.zzPushbackPos;
	}



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public PhpAstLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public PhpAstLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 192) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol next_token() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          zzR = false;
          break;
        case '\r':
          yyline++;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
          }
          break;
        default:
          zzR = false;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 64: 
          { return createSymbol(ParserConstants.T_LOGICAL_OR);
          }
        case 188: break;
        case 41: 
          { popState();
    return createFullSymbol(ParserConstants.T_STRING);
          }
        case 189: break;
        case 157: 
          { return createSymbol(ParserConstants.T_REQUIRE);
          }
        case 190: break;
        case 55: 
          { return createFullSymbol(ParserConstants.T_DNUMBER);
          }
        case 191: break;
        case 172: 
          { return createSymbol(ParserConstants.T_INTERFACE);
          }
        case 192: break;
        case 88: 
          { pushState(ST_LOOKING_FOR_VARNAME);
    return createSymbol(ParserConstants.T_DOLLAR_OPEN_CURLY_BRACES);
          }
        case 193: break;
        case 47: 
          { return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 194: break;
        case 139: 
          { int removeChars = (yytext().charAt(0) == 'b') ? 4 : 3;
    String hereOrNowDoc = yytext().substring(removeChars).trim();    // for 'b<<<' or '<<<'
    int heredoc_len = hereOrNowDoc.length();

	Symbol sym = createFullSymbol(ParserConstants.T_START_HEREDOC);

    if (hereOrNowDoc.charAt(0) == '\'') {
    	nowdoc = hereOrNowDoc.substring(1, heredoc_len-1);
    	sym.value = nowdoc;
    	heredoc_len -= 2;
    	yybegin(ST_NOWDOC);
    }
    else if (hereOrNowDoc.charAt(0) == '"') {
    	heredoc = hereOrNowDoc.substring(1, heredoc_len-1);
    	sym.value = heredoc;
    	heredoc_len -= 2;
    	yybegin(ST_HEREDOC);
    } else {
    	heredoc = hereOrNowDoc;
    	sym.value = heredoc;
    	yybegin(ST_HEREDOC);
    }
    return sym;
          }
        case 195: break;
        case 23: 
          { return createSymbol(ParserConstants.T_TIMES);
          }
        case 196: break;
        case 57: 
          { return createSymbol(ParserConstants.T_INC);
          }
        case 197: break;
        case 36: 
          { handleCommentStart();
	yybegin(ST_ONE_LINE_COMMENT);
//	yymore();
          }
        case 198: break;
        case 131: 
          { return createSymbol(ParserConstants.T_UNSET);
          }
        case 199: break;
        case 27: 
          { return createSymbol(ParserConstants.T_OR);
          }
        case 200: break;
        case 17: 
          { return createSymbol(ParserConstants.T_NEKUDOTAIM);
          }
        case 201: break;
        case 51: 
          { //	yymore();
          }
        case 202: break;
        case 60: 
          { return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 203: break;
        case 35: 
          { /* This is a temporary fix which is dependant on flex and it's implementation */
    if (!stack.isEmpty()) {
        popState();
    }
    return createSymbol(ParserConstants.T_CURLY_CLOSE);
          }
        case 204: break;
        case 40: 
          { yypushback(yylength());
    popState();
          }
        case 205: break;
        case 77: 
          { return createSymbol(ParserConstants.T_DIV_EQUAL);
          }
        case 206: break;
        case 93: 
          { return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
          }
        case 207: break;
        case 13: 
          { pushState(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 208: break;
        case 128: 
          { return createSymbol(ParserConstants.T_TRAIT);
          }
        case 209: break;
        case 86: 
          { yybegin(YYINITIAL);
    return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
          }
        case 210: break;
        case 107: 
          { return createSymbol(ParserConstants.T_SR_EQUAL);
          }
        case 211: break;
        case 79: 
          { if (asp_tags) {
        yybegin(YYINITIAL);
        return createSymbol(ParserConstants.T_SEMICOLON);  /* implicit ';' at php-end tag */
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 212: break;
        case 186: 
          { return createSymbol(ParserConstants.T_NS_C);
          }
        case 213: break;
        case 176: 
          { return createSymbol(ParserConstants.T_CLASS_C);
          }
        case 214: break;
        case 12: 
          { yybegin(ST_BACKQUOTE);
    return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 215: break;
        case 111: 
          { return createSymbol(ParserConstants.T_SL_EQUAL);
          }
        case 216: break;
        case 117: 
          { return createSymbol(ParserConstants.T_ELSE);
          }
        case 217: break;
        case 148: 
          { return createSymbol(ParserConstants.T_GLOBAL);
          }
        case 218: break;
        case 126: 
          { return createSymbol(ParserConstants.T_BREAK);
          }
        case 219: break;
        case 63: 
          { return createSymbol(ParserConstants.T_DO);
          }
        case 220: break;
        case 21: 
          { return createSymbol(ParserConstants.T_NOT);
          }
        case 221: break;
        case 120: 
          { return createSymbol(ParserConstants.T_LIST);
          }
        case 222: break;
        case 133: 
          { return createSymbol(ParserConstants.T_CONST);
          }
        case 223: break;
        case 185: 
          { return createSymbol(ParserConstants.T_FUNC_C);
          }
        case 224: break;
        case 33: 
          { return createSymbol(ParserConstants.T_QUESTION_MARK);
          }
        case 225: break;
        case 151: 
          { return createSymbol(ParserConstants.T_DOUBLE_CAST);
          }
        case 226: break;
        case 178: 
          { return createSymbol(ParserConstants.T_ENDFOREACH);
          }
        case 227: break;
        case 37: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_QUATE);
          }
        case 228: break;
        case 145: 
          { return createSymbol(ParserConstants.T_STATIC);
          }
        case 229: break;
        case 116: 
          { return createSymbol(ParserConstants.T_ECHO);
          }
        case 230: break;
        case 52: 
          { String yytext = yytext();
	switch (yytext.charAt(yytext.length() - 1)) {
		case '?':
		case '%':
		case '>':
			yypushback(1);
			break;
		default:
			handleLineCommentEnd();
			yybegin(ST_IN_SCRIPTING);
	}
//	yymore();
          }
        case 231: break;
        case 45: 
          { yypushback(1);
	popState();
	return createSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 232: break;
        case 147: 
          { return createSymbol(ParserConstants.T_RETURN);
          }
        case 233: break;
        case 89: 
          { pushState(ST_IN_SCRIPTING);
    yypushback(yylength()-1);
    return createSymbol(ParserConstants.T_CURLY_OPEN_WITH_DOLAR);
          }
        case 234: break;
        case 159: 
          { return createSymbol(ParserConstants.T_ARRAY_CAST);
          }
        case 235: break;
        case 32: 
          { return createSymbol(ParserConstants.T_TILDA);
          }
        case 236: break;
        case 98: 
          { String text = yytext();
    if ((text.charAt(1)=='%' && asp_tags)
        || (text.charAt(1)=='?')) {
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG_WITH_ECHO;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 237: break;
        case 53: 
          { if (asp_tags) {
        yybegin(ST_IN_SCRIPTING);
		//return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 238: break;
        case 5: 
          { return createSymbol(ParserConstants.T_NEKUDA);
          }
        case 239: break;
        case 44: 
          { /* Offset could be treated as a long */
	return createFullSymbol(ParserConstants.T_NUM_STRING);
          }
        case 240: break;
        case 165: 
          { return createSymbol(ParserConstants.T_CALLABLE);
          }
        case 241: break;
        case 154: 
          { return createSymbol(ParserConstants.T_DEFAULT);
          }
        case 242: break;
        case 115: 
          { String text = yytext();

 	if (text.charAt(text.length() - 2)== ';') {
		text = text.substring(0, text.length() - 2);
        yypushback(1);
    } else {
		text = text.substring(0, text.length() - 1);
    }
 
 	int textLength = text.length();
 	int nowdocLength = nowdoc.length();
	if (textLength > nowdocLength && text.substring(textLength - nowdocLength, textLength).equals(nowdoc)) {
		yypushback(2);
       	yybegin(ST_END_HEREDOC);
       	nowdoc = null;
       	// we need to remove the closing label from the symbol value.
       	Symbol sym = createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
       	String value = (String)sym.value;
       	sym.value = value.substring(0, value.length() - nowdocLength + 1);
	   	return sym;
	}
	yypushback(1);
          }
        case 243: break;
        case 78: 
          { handleCommentStart();
    yybegin(ST_COMMENT);
          }
        case 244: break;
        case 141: 
          { yybegin(ST_IN_SCRIPTING);
	//return T_OPEN_TAG;
          }
        case 245: break;
        case 73: 
          { return createSymbol(ParserConstants.T_IS_NOT_EQUAL);
          }
        case 246: break;
        case 69: 
          { return createSymbol(ParserConstants.T_IS_GREATER_OR_EQUAL);
          }
        case 247: break;
        case 7: 
          { return createSymbol(ParserConstants.T_PLUS);
          }
        case 248: break;
        case 146: 
          { return createSymbol(ParserConstants.T_SWITCH);
          }
        case 249: break;
        case 174: 
          { return createSymbol(ParserConstants.T_NAMESPACE);
          }
        case 250: break;
        case 99: 
          { return createFullSymbol(ParserConstants.T_BNUMBER);
          }
        case 251: break;
        case 26: 
          { return createSymbol(ParserConstants.T_REFERENCE);
          }
        case 252: break;
        case 181: 
          { return createSymbol(ParserConstants.T_METHOD_C);
          }
        case 253: break;
        case 82: 
          { return createSymbol(ParserConstants.T_BOOLEAN_AND);
          }
        case 254: break;
        case 14: 
          { return createSymbol(ParserConstants.T_SEMICOLON);
          }
        case 255: break;
        case 96: 
          { handlePHPDocEnd();
     yybegin(ST_IN_SCRIPTING);
          }
        case 256: break;
        case 15: 
          { return createSymbol(ParserConstants.T_MINUS);
          }
        case 257: break;
        case 180: 
          { return createSymbol(ParserConstants.T_IMPLEMENTS);
          }
        case 258: break;
        case 3: 
          { // do nothing
          }
        case 259: break;
        case 173: 
          { return createSymbol(ParserConstants.T_INSTEADOF);
          }
        case 260: break;
        case 171: 
          { return createSymbol(ParserConstants.T_ENDSWITCH);
          }
        case 261: break;
        case 58: 
          { return createSymbol(ParserConstants.T_PLUS_EQUAL);
          }
        case 262: break;
        case 31: 
          { return createSymbol(ParserConstants.T_CLOSE_RECT);
          }
        case 263: break;
        case 100: 
          { return createSymbol(ParserConstants.T_LOGICAL_XOR);
          }
        case 264: break;
        case 95: 
          { handleMultilineCommentEnd();
    yybegin(ST_IN_SCRIPTING);
          }
        case 265: break;
        case 49: 
          { popState();
	return createSymbol(ParserConstants.T_CLOSE_RECT);
          }
        case 266: break;
        case 70: 
          { return createSymbol(ParserConstants.T_PAAMAYIM_NEKUDOTAYIM);
          }
        case 267: break;
        case 177: 
          { return createSymbol(ParserConstants.T_ENDDECLARE);
          }
        case 268: break;
        case 153: 
          { return createSymbol(ParserConstants.T_INCLUDE);
          }
        case 269: break;
        case 11: 
          { return createSymbol(ParserConstants.T_NS_SEPARATOR);
          }
        case 270: break;
        case 122: 
          { handleCommentStart();
          }
        case 271: break;
        case 61: 
          { return createFullSymbol(ParserConstants.T_CONSTANT_ENCAPSED_STRING);
          }
        case 272: break;
        case 72: 
          { return createSymbol(ParserConstants.T_IS_EQUAL);
          }
        case 273: break;
        case 125: 
          { return createSymbol(ParserConstants.T_ARRAY);
          }
        case 274: break;
        case 30: 
          { return createSymbol(ParserConstants.T_OPEN_RECT);
          }
        case 275: break;
        case 104: 
          { return createSymbol(ParserConstants.T_FOR);
          }
        case 276: break;
        case 168: 
          { return createSymbol(ParserConstants.T_OBJECT_CAST);
          }
        case 277: break;
        case 94: 
          { /* treat numbers (almost) as strings inside encapsulated strings */
    return createFullSymbol(ParserConstants.T_NUM_STRING);
          }
        case 278: break;
        case 158: 
          { return createSymbol(ParserConstants.T_PRIVATE);
          }
        case 279: break;
        case 163: 
          { return createSymbol(ParserConstants.T_ABSTRACT);
          }
        case 280: break;
        case 156: 
          { return createSymbol(ParserConstants.T_FOREACH);
          }
        case 281: break;
        case 129: 
          { return createSymbol(ParserConstants.T_THROW);
          }
        case 282: break;
        case 167: 
          { return createSymbol(ParserConstants.T_STRING_CAST);
          }
        case 283: break;
        case 81: 
          { return createSymbol(ParserConstants.T_AND_EQUAL);
          }
        case 284: break;
        case 136: 
          { return createSymbol(ParserConstants.T_WHILE);
          }
        case 285: break;
        case 106: 
          { return createSymbol(ParserConstants.T_NEW);
          }
        case 286: break;
        case 65: 
          { return createSymbol(ParserConstants.T_DEC);
          }
        case 287: break;
        case 54: 
          { if (short_tags_allowed || yylength()>2) { /* yyleng>2 means it's not <? but <script> */
        yybegin(ST_IN_SCRIPTING);
        //return T_OPEN_TAG;
    } else {
        return createSymbol(ParserConstants.T_INLINE_HTML);
    }
          }
        case 288: break;
        case 59: 
          { return createSymbol(ParserConstants.T_AS);
          }
        case 289: break;
        case 143: 
          { return createSymbol(ParserConstants.T_ELSEIF);
          }
        case 290: break;
        case 80: 
          { return createSymbol(ParserConstants.T_MOD_EQUAL);
          }
        case 291: break;
        case 91: 
          { String text = yytext();
    int length = text.length() - 1;
    text = text.trim();
    
    yypushback(1);
    
    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        yypushback(1);
    }
    if (text.equals(heredoc)) {
        heredoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    }
    else {
    	yybegin(ST_HEREDOC);
    }
          }
        case 292: break;
        case 109: 
          { return createSymbol(ParserConstants.T_IS_IDENTICAL);
          }
        case 293: break;
        case 25: 
          { return createSymbol(ParserConstants.T_PRECENT);
          }
        case 294: break;
        case 71: 
          { return createSymbol(ParserConstants.T_DOUBLE_ARROW);
          }
        case 295: break;
        case 132: 
          { return createSymbol(ParserConstants.T_CATCH);
          }
        case 296: break;
        case 9: 
          { return createSymbol(ParserConstants.T_DOLLAR);
          }
        case 297: break;
        case 22: 
          { return createSymbol(ParserConstants.T_RGREATER);
          }
        case 298: break;
        case 4: 
          { return createFullSymbol(ParserConstants.T_LNUMBER);
          }
        case 299: break;
        case 142: 
          { return createSymbol(ParserConstants.T_ENDFOR);
          }
        case 300: break;
        case 28: 
          { return createSymbol(ParserConstants.T_KOVA);
          }
        case 301: break;
        case 56: 
          { return createSymbol(ParserConstants.T_CONCAT_EQUAL);
          }
        case 302: break;
        case 43: 
          { popState();
    pushState(ST_IN_SCRIPTING);
    return createFullSymbol(ParserConstants.T_STRING_VARNAME);
          }
        case 303: break;
        case 134: 
          { return createSymbol(ParserConstants.T_CLASS);
          }
        case 304: break;
        case 102: 
          { return createSymbol(ParserConstants.T_TRY);
          }
        case 305: break;
        case 114: 
          { String text = yytext();

    if (text.charAt(text.length() - 2)== ';') {
		text = text.substring(0, text.length() - 2);
        yypushback(1);
    } else {
		text = text.substring(0, text.length() - 1);
    }
	
	int textLength = text.length();
	int heredocLength = heredoc.length();
	if (textLength > heredocLength && text.substring(textLength - heredocLength, textLength).equals(heredoc)) {
		yypushback(2);
        yybegin(ST_END_HEREDOC);
        heredoc = null;
        // we need to remove the closing label from the symbol value.
        Symbol sym = createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
        String value = (String)sym.value;
        sym.value = value.substring(0, value.length() - heredocLength + 1);
	   	return sym;
	}
	yypushback(1);
          }
        case 306: break;
        case 39: 
          { yybegin(ST_IN_SCRIPTING);
	return createSymbol(ParserConstants.T_END_HEREDOC);
          }
        case 307: break;
        case 127: 
          { return createSymbol(ParserConstants.T_ISSET);
          }
        case 308: break;
        case 182: 
          { handleVarComment();
    //return createFullSymbol(ParserConstants.T_VAR_COMMENT);
          }
        case 309: break;
        case 10: 
          { yybegin(ST_DOUBLE_QUOTES);
    return createSymbol(ParserConstants.T_QUATE);
          }
        case 310: break;
        case 123: 
          { return createSymbol(ParserConstants.T_ENDIF);
          }
        case 311: break;
        case 42: 
          { yypushback(yylength());
    popState();
    pushState(ST_IN_SCRIPTING);
          }
        case 312: break;
        case 76: 
          { return createSymbol(ParserConstants.T_MUL_EQUAL);
          }
        case 313: break;
        case 97: 
          { if (asp_tags || yytext().charAt(0)!='%') { /* asp comment? */
	    handleLineCommentEnd();
        yypushback(yylength());
		yybegin(ST_IN_SCRIPTING);
		//return T_COMMENT;
	}
          }
        case 314: break;
        case 24: 
          { return createSymbol(ParserConstants.T_DIV);
          }
        case 315: break;
        case 135: 
          { return createSymbol(ParserConstants.T_CLONE);
          }
        case 316: break;
        case 144: 
          { /* not a keyword, hust for recognize constans.*/
    return createFullSymbol(ParserConstants.T_DEFINE);
          }
        case 317: break;
        case 184: 
          { return createSymbol(ParserConstants.T_REQUIRE_ONCE);
          }
        case 318: break;
        case 6: 
          { return createFullSymbol(ParserConstants.T_STRING);
          }
        case 319: break;
        case 38: 
          { yybegin(ST_IN_SCRIPTING);
    return createSymbol(ParserConstants.T_BACKQUATE);
          }
        case 320: break;
        case 105: 
          { return createSymbol(ParserConstants.T_USE);
          }
        case 321: break;
        case 19: 
          { return createSymbol(ParserConstants.T_CLOSE_PARENTHESE);
          }
        case 322: break;
        case 179: 
          { return createSymbol(ParserConstants.T_INSTANCEOF);
          }
        case 323: break;
        case 161: 
          { return createSymbol(ParserConstants.T_DIR);
          }
        case 324: break;
        case 124: 
          { return createSymbol(ParserConstants.T_EMPTY);
          }
        case 325: break;
        case 90: 
          { yypushback(1);
	return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 326: break;
        case 50: 
          { return createSymbol(ParserConstants.T_CURLY_CLOSE);
          }
        case 327: break;
        case 170: 
          { return createSymbol(ParserConstants.T_LINE);
          }
        case 328: break;
        case 2: 
          { return createSymbol(ParserConstants.T_INLINE_HTML);
          }
        case 329: break;
        case 112: 
          { if (!parsePHPDoc()) {
handleCommentStart();
yybegin(ST_DOCBLOCK);
}
          }
        case 330: break;
        case 83: 
          { return createSymbol(ParserConstants.T_OR_EQUAL);
          }
        case 331: break;
        case 119: 
          { return createSymbol(ParserConstants.T_CASE);
          }
        case 332: break;
        case 169: 
          { return createSymbol(ParserConstants.T_FILE);
          }
        case 333: break;
        case 152: 
          { return createSymbol(ParserConstants.T_EXTENDS);
          }
        case 334: break;
        case 67: 
          { return createSymbol(ParserConstants.T_MINUS_EQUAL);
          }
        case 335: break;
        case 1: 
          { return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 336: break;
        case 130: 
          { return createSymbol(ParserConstants.T_FINAL);
          }
        case 337: break;
        case 155: 
          { return createSymbol(ParserConstants.T_DECLARE);
          }
        case 338: break;
        case 160: 
          { return createSymbol(ParserConstants.T_UNSET_CAST);
          }
        case 339: break;
        case 138: 
          { return createSymbol(ParserConstants.T_INT_CAST);
          }
        case 340: break;
        case 48: 
          { return createSymbol(ParserConstants.T_CURLY_OPEN);
          }
        case 341: break;
        case 18: 
          { return createSymbol(ParserConstants.T_OPEN_PARENTHESE);
          }
        case 342: break;
        case 150: 
          { return createSymbol(ParserConstants.T_BOOL_CAST);
          }
        case 343: break;
        case 101: 
          { return createSymbol(ParserConstants.T_LOGICAL_AND);
          }
        case 344: break;
        case 149: 
          { return createSymbol(ParserConstants.T_PUBLIC);
          }
        case 345: break;
        case 20: 
          { return createSymbol(ParserConstants.T_EQUAL);
          }
        case 346: break;
        case 62: 
          { return createSymbol(ParserConstants.T_IF);
          }
        case 347: break;
        case 29: 
          { return createSymbol(ParserConstants.T_COMMA);
          }
        case 348: break;
        case 110: 
          { return createSymbol(ParserConstants.T_IS_NOT_IDENTICAL);
          }
        case 349: break;
        case 74: 
          { return createSymbol(ParserConstants.T_IS_SMALLER_OR_EQUAL);
          }
        case 350: break;
        case 118: 
          { return createSymbol(ParserConstants.T_EVAL);
          }
        case 351: break;
        case 84: 
          { return createSymbol(ParserConstants.T_BOOLEAN_OR);
          }
        case 352: break;
        case 87: 
          { yypushback(1);
    return createFullSymbol(ParserConstants.T_ENCAPSED_AND_WHITESPACE);
          }
        case 353: break;
        case 92: 
          { String text = yytext();
    int length = text.length() - 1;
    text = text.trim();
    
    yypushback(1);
    
    if (text.endsWith(";")) {
        text = text.substring(0, text.length() - 1);
        yypushback(1);
    }
    if (text.equals(nowdoc)) {
    	nowdoc = null;
        yybegin(ST_IN_SCRIPTING);
        return createSymbol(ParserConstants.T_END_HEREDOC);
    }
    else {
    	yybegin(ST_HEREDOC);
    }
          }
        case 354: break;
        case 68: 
          { return createSymbol(ParserConstants.T_SR);
          }
        case 355: break;
        case 164: 
          { return createSymbol(ParserConstants.T_FUNCTION);
          }
        case 356: break;
        case 175: 
          { return createSymbol(ParserConstants.T_PROTECTED);
          }
        case 357: break;
        case 162: 
          { return createSymbol(ParserConstants.T_ENDWHILE);
          }
        case 358: break;
        case 16: 
          { return createSymbol(ParserConstants.T_LGREATER);
          }
        case 359: break;
        case 108: 
          { return createSymbol(ParserConstants.T_VAR);
          }
        case 360: break;
        case 85: 
          { return createSymbol(ParserConstants.T_XOR_EQUAL);
          }
        case 361: break;
        case 113: 
          { yypushback(1);
	pushState(ST_VAR_OFFSET);
	return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 362: break;
        case 46: 
          { return createSymbol(ParserConstants.T_QUATE);
          }
        case 363: break;
        case 166: 
          { return createSymbol(ParserConstants.T_CONTINUE);
          }
        case 364: break;
        case 66: 
          { pushState(ST_LOOKING_FOR_PROPERTY);
    return createSymbol(ParserConstants.T_OBJECT_OPERATOR);
          }
        case 365: break;
        case 103: 
          { return createFullSymbol(ParserConstants.T_EXIT);
          }
        case 366: break;
        case 137: 
          { return createSymbol(ParserConstants.T_PRINT);
          }
        case 367: break;
        case 187: 
          { return createSymbol(ParserConstants.T_HALT_COMPILER);
          }
        case 368: break;
        case 140: 
          { yypushback(3);
	pushState(ST_LOOKING_FOR_PROPERTY);
	return createFullSymbol(ParserConstants.T_VARIABLE);
          }
        case 369: break;
        case 75: 
          { return createSymbol(ParserConstants.T_SL);
          }
        case 370: break;
        case 121: 
          { return createSymbol(ParserConstants.T_GOTO);
          }
        case 371: break;
        case 183: 
          { return createSymbol(ParserConstants.T_INCLUDE_ONCE);
          }
        case 372: break;
        case 8: 
          { 
          }
        case 373: break;
        case 34: 
          { return createSymbol(ParserConstants.T_AT);
          }
        case 374: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {     return createSymbol(sym.EOF);
 }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java PhpAstLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        PhpAstLexer scanner = null;
        try {
          scanner = new PhpAstLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.zzAtEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
