/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.preferences.CodeFormatterPreview;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.ModifyDialogTabPage;
import org.eclipse.php.formatter.ui.preferences.PhpPreview;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class BracesTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = "<?php\n" + BracesTabPage.createPreviewHeader(FormatterMessages.BracesTabPage_preview_header) + "interface EmptyInterface {}\n" + "\n" + "class Example {" + "  function bar($p) {" + "    for ($i= 0; $i<10; $i++) {" + "    }" + "    switch($p) {" + "      case 0:" + "        $fField->set(0);" + "        break;" + "      case 1: {" + "        break;" + "        }" + "      default:" + "        $fField->reset();" + "    }" + "  }" + "}" + "\n?>";
    private CodeFormatterPreview fPreview;
    private boolean isInitialized = false;
    private ModifyDialogTabPage.ComboPreference classDeclaration;
    private ModifyDialogTabPage.ComboPreference methodDeclaration;
    private ModifyDialogTabPage.ComboPreference blocks;
    private ModifyDialogTabPage.ComboPreference switchCase;
    private final String[] fBracePositionNames = new String[]{FormatterMessages.BracesTabPage_position_same_line, FormatterMessages.BracesTabPage_position_next_line, FormatterMessages.BracesTabPage_position_next_line_indented};

    public BracesTabPage(ModifyDialog modifyDialog, CodeFormatterPreferences preferences) {
        super(modifyDialog, preferences);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group group = this.createGroup(numColumns, composite, FormatterMessages.BracesTabPage_group_brace_positions_title);
        this.classDeclaration = this.createBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_class_declaration);
        this.setComboValue(this.classDeclaration, this.codeFormatterPreferences.brace_position_for_class);
        this.methodDeclaration = this.createBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_method_declaration);
        this.setComboValue(this.methodDeclaration, this.codeFormatterPreferences.brace_position_for_function);
        this.blocks = this.createBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_blocks);
        this.setComboValue(this.blocks, this.codeFormatterPreferences.brace_position_for_block);
        this.switchCase = this.createBracesCombo((Composite)group, numColumns, FormatterMessages.BracesTabPage_option_switch_case);
        this.setComboValue(this.switchCase, this.codeFormatterPreferences.brace_position_for_switch);
        this.isInitialized = true;
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected PhpPreview doCreatePhpPreview(Composite parent) {
        this.fPreview = new CodeFormatterPreview(this.codeFormatterPreferences, parent);
        return this.fPreview;
    }

    private ModifyDialogTabPage.ComboPreference createBracesCombo(Composite composite, int numColumns, String message) {
        return this.createComboPref(composite, numColumns, message, this.fBracePositionNames);
    }

    protected void doUpdatePreview() {
        if (this.fPreview != null) {
            this.fPreview.update();
        }
    }

    protected void updatePreferences() {
        if (this.isInitialized) {
            this.codeFormatterPreferences.brace_position_for_class = this.getComboValue(this.classDeclaration);
            this.codeFormatterPreferences.brace_position_for_function = this.getComboValue(this.methodDeclaration);
            this.codeFormatterPreferences.brace_position_for_block = this.getComboValue(this.blocks);
            this.codeFormatterPreferences.brace_position_for_switch = this.getComboValue(this.switchCase);
        }
    }

    private byte getComboValue(ModifyDialogTabPage.ComboPreference combo) {
        int index = combo.getSelectionIndex();
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    private void setComboValue(ModifyDialogTabPage.ComboPreference combo, byte value) {
        switch (value) {
            case 0: {
                combo.setSelectedItem(FormatterMessages.BracesTabPage_position_same_line);
                break;
            }
            case 1: {
                combo.setSelectedItem(FormatterMessages.BracesTabPage_position_next_line);
                break;
            }
            case 2: {
                combo.setSelectedItem(FormatterMessages.BracesTabPage_position_next_line_indented);
            }
        }
    }
}

