/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.util.Comparator;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestMatchPathComparator
implements Comparator<PathEntry> {
    private String[] segments;

    public BestMatchPathComparator(VirtualPath path) {
        this.segments = path.getSegments();
    }

    @Override
    public int compare(PathEntry e1, PathEntry e2) {
        String[] s1 = e1.getAbstractPath().getSegments();
        String[] s2 = e2.getAbstractPath().getSegments();
        int ns1 = 0;
        int ns2 = 0;
        boolean found = true;
        int i = 0;
        int j = 0;
        int k = 0;
        while (found && i < this.segments.length && (j < s1.length || k < s2.length)) {
            found = false;
            if (j < s1.length && s1[j].equals(this.segments[i])) {
                ns1 = 0;
                found = true;
            }
            if (k < s2.length && s2[k].equals(this.segments[i])) {
                ns2 = 0;
                found = true;
            }
            ++i;
            ++j;
            ++k;
        }
        return Integer.signum(ns2 - ns1);
    }
}

