/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantDeclaration
extends Statement {
    private final ASTNode.NodeList<Identifier> names = new ASTNode.NodeList(this, NAMES_PROPERTY);
    private final ASTNode.NodeList<Expression> initializers = new ASTNode.NodeList(this, INITIALIZERS_PROPERTY);
    public static final ChildListPropertyDescriptor NAMES_PROPERTY = new ChildListPropertyDescriptor(ConstantDeclaration.class, "names", Identifier.class, true);
    public static final ChildListPropertyDescriptor INITIALIZERS_PROPERTY = new ChildListPropertyDescriptor(ConstantDeclaration.class, "initializers", Expression.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(2);
        properyList.add(NAMES_PROPERTY);
        properyList.add(INITIALIZERS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    private ConstantDeclaration(int start, int end, AST ast, List<Identifier> names, List<Expression> initializers) {
        super(start, end, ast);
        if (names == null || initializers == null || names.size() != initializers.size()) {
            throw new IllegalArgumentException();
        }
        Iterator<Identifier> iteratorNames = names.iterator();
        Iterator<Expression> iteratorInitializers = initializers.iterator();
        while (iteratorNames.hasNext()) {
            this.names.add(iteratorNames.next());
            this.initializers.add(iteratorInitializers.next());
        }
    }

    public ConstantDeclaration(int start, int end, AST ast, List variablesAndDefaults) {
        super(start, end, ast);
        if (variablesAndDefaults == null || variablesAndDefaults == null || variablesAndDefaults.size() == 0) {
            throw new IllegalArgumentException();
        }
        for (ASTNode[] element : variablesAndDefaults) {
            assert (element != null && element.length == 2 && element[0] != null && element[1] != null);
            this.names.add((Identifier)element[0]);
            this.initializers.add((Expression)element[1]);
        }
    }

    public ConstantDeclaration(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        Iterator iterator1 = this.names.iterator();
        Iterator iterator2 = this.initializers.iterator();
        while (iterator1.hasNext()) {
            ((Identifier)iterator1.next()).accept(visitor);
            ((Expression)iterator2.next()).accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        Iterator iterator1 = this.names.iterator();
        Iterator iterator2 = this.initializers.iterator();
        while (iterator1.hasNext()) {
            ((Identifier)iterator1.next()).traverseTopDown(visitor);
            ((Expression)iterator2.next()).traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        Iterator iterator1 = this.names.iterator();
        Iterator iterator2 = this.initializers.iterator();
        while (iterator1.hasNext()) {
            ((Identifier)iterator1.next()).traverseBottomUp(visitor);
            ((Expression)iterator2.next()).traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ConstantDeclaration");
        this.appendInterval(buffer);
        buffer.append(">\n");
        Iterator iterator1 = this.names.iterator();
        Iterator iterator2 = this.initializers.iterator();
        while (iterator1.hasNext()) {
            buffer.append(tab).append("\t").append("<VariableName>\n");
            ((Identifier)iterator1.next()).toString(buffer, "\t\t" + tab);
            buffer.append("\n");
            buffer.append(tab).append("\t").append("</VariableName>\n");
            buffer.append(tab).append("\t").append("<InitialValue>\n");
            Expression expr = (Expression)iterator2.next();
            if (expr != null) {
                expr.toString(buffer, "\t\t" + tab);
                buffer.append("\n");
            }
            buffer.append(tab).append("\t").append("</InitialValue>\n");
        }
        buffer.append(tab).append("</ConstantDeclaration>");
    }

    @Override
    public int getType() {
        return 11;
    }

    public List<Expression> initializers() {
        return this.initializers;
    }

    public List<Identifier> names() {
        return this.names;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == NAMES_PROPERTY) {
            return this.names();
        }
        if (property == INITIALIZERS_PROPERTY) {
            return this.initializers();
        }
        return super.internalGetChildListProperty(property);
    }

    public Expression[] getConstantValues() {
        return this.initializers.toArray((Expression[])new Expression[this.initializers.size()]);
    }

    public Identifier[] getVariableNames() {
        return this.names.toArray((Identifier[])new Identifier[this.names.size()]);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List names = ASTNode.copySubtrees(target, this.names());
        List initializers = ASTNode.copySubtrees(target, this.initializers());
        ConstantDeclaration ccd = new ConstantDeclaration(this.getStart(), this.getEnd(), target, names, initializers);
        return ccd;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

