/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class NamespaceMemberContext
extends StatementContext {
    private IType[] namespaces;
    private int elementStart;
    private boolean isGlobal;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        block8: {
            if (!super.isValid(sourceModule, offset, requestor)) {
                return false;
            }
            if (this.getPhpVersion().isLessThan(PHPVersion.PHP5_3)) {
                return false;
            }
            TextSequence statementText = this.getStatementText();
            int totalLength = statementText.length();
            int endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, totalLength);
            this.elementStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, endPosition, true);
            this.elementStart = PHPTextSequenceUtilities.readBackwardSpaces(statementText, this.elementStart);
            if (this.elementStart < 1) {
                return false;
            }
            String triggerText = statementText.subSequence(this.elementStart - 1, this.elementStart).toString();
            if (!triggerText.equals("\\")) {
                return false;
            }
            this.isGlobal = false;
            if (this.elementStart == 1) {
                this.isGlobal = true;
                return true;
            }
            int endNamespace = PHPTextSequenceUtilities.readBackwardSpaces(statementText, this.elementStart - 1);
            int nsNameStart = PHPTextSequenceUtilities.readNamespaceStartIndex(statementText, endNamespace, false);
            String nsName = statementText.subSequence(nsNameStart, this.elementStart).toString();
            if (nsName.equals("\\")) {
                this.isGlobal = true;
                return true;
            }
            try {
                this.namespaces = PHPModelUtils.getNamespaceOf(nsName, sourceModule, offset, null, null);
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
        return true;
    }

    public int getElementStart() {
        return this.elementStart;
    }

    public IType[] getNamespaces() {
        return this.namespaces;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public String getPrefix() throws BadLocationException {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        TextSequence statementText = this.getStatementText();
        int statementLength = statementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(statementText, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(statementText, prefixEnd, true);
        return statementText.subSequence(prefixStart, prefixEnd).toString();
    }

    public int getPrefixEnd() throws BadLocationException {
        ITextRegion phpToken = this.getPHPToken();
        if (phpToken.getType() == "PHP_NS_SEPARATOR") {
            IPhpScriptRegion phpScriptRegion = this.getPhpScriptRegion();
            ITextRegion nextRegion = phpScriptRegion.getPhpToken(phpToken.getEnd());
            return this.getRegionCollection().getStartOffset() + phpScriptRegion.getStart() + nextRegion.getTextEnd();
        }
        return super.getPrefixEnd();
    }
}

