/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import org.eclipse.php.internal.core.tar.CRCable;

public class CRCableOutputStream
extends OutputStream
implements CRCable {
    private BufferedOutputStream innerOutputStream;
    private CRC32 crc = new CRC32();
    private long crcValue = 0L;

    public CRCableOutputStream(OutputStream out) {
        this.innerOutputStream = new BufferedOutputStream(out);
        this.crc.reset();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.innerOutputStream.write(b, off, len);
        this.crc.update(b, off, len);
    }

    public synchronized void write(int b) throws IOException {
        this.innerOutputStream.write(b);
        this.crc.update(b);
    }

    public void close() throws IOException {
        this.innerOutputStream.close();
        this.crcValue = this.crc.getValue();
        this.crc.reset();
    }

    public void flush() throws IOException {
        this.innerOutputStream.flush();
    }

    public long getCrc() {
        return this.crcValue;
    }
}

