/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.context.MethodContext;

public class FormalParameterEvaluator
extends GoalEvaluator {
    private IEvaluatedType result;

    public FormalParameterEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        ExpressionTypeGoal typedGoal = (ExpressionTypeGoal)this.goal;
        FormalParameter parameter = (FormalParameter)typedGoal.getExpression();
        SimpleReference type = parameter.getParameterType();
        if (type != null && !"array".equals(type.getName())) {
            this.result = PHPClassType.fromSimpleReference(type);
        } else {
            IContext context = typedGoal.getContext();
            if (context instanceof MethodContext) {
                MethodContext methodContext = (MethodContext)context;
                PHPMethodDeclaration methodDeclaration = (PHPMethodDeclaration)methodContext.getMethodNode();
                PHPDocBlock[] docBlocks = new PHPDocBlock[]{};
                try {
                    IMethod method;
                    IModelElement element = methodContext.getSourceModule().getElementAt(methodDeclaration.getNameStart());
                    docBlocks = element instanceof IMethod ? ((method = (IMethod)element).getDeclaringType() != null ? PHPModelUtils.getTypeHierarchyMethodDoc(method.getDeclaringType(), method.getElementName(), true, null) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()}) : new PHPDocBlock[]{methodDeclaration.getPHPDoc()};
                }
                catch (CoreException coreException) {}
                PHPDocBlock[] pHPDocBlockArray = docBlocks;
                int n = docBlocks.length;
                int n2 = 0;
                while (n2 < n) {
                    PHPDocBlock docBlock = pHPDocBlockArray[n2];
                    if (this.result != null) break;
                    if (docBlock != null) {
                        PHPDocTag[] pHPDocTagArray = docBlock.getTags();
                        int n3 = pHPDocTagArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            SimpleReference[] references;
                            PHPDocTag tag = pHPDocTagArray[n4];
                            if (tag.getTagKind() == 7 && (references = tag.getReferences()).length == 2 && references[0].getName().equals(parameter.getName())) {
                                String typeName = references[1].getName();
                                if (typeName.endsWith("[]")) {
                                    typeName = typeName.substring(0, typeName.length() - 2);
                                }
                                if (typeName.indexOf(124) >= 0) {
                                    String[] typeNames = typeName.split("|");
                                    MultiTypeType arrayType = new MultiTypeType();
                                    int i = 0;
                                    while (i < typeNames.length) {
                                        if (typeNames[i].trim().length() != 0 && !typeNames[i].equals("|")) {
                                            arrayType.addType((IEvaluatedType)PHPClassType.fromTypeName(typeNames[i], methodContext.getSourceModule(), references[1].sourceStart()));
                                        }
                                        ++i;
                                    }
                                    this.result = arrayType;
                                } else {
                                    this.result = PHPClassType.fromTypeName(typeName, methodContext.getSourceModule(), references[1].sourceStart());
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                if (this.result == null && parameter.getInitialization() instanceof Scalar) {
                    Scalar scalar = (Scalar)parameter.getInitialization();
                    this.result = PHPSimpleTypes.fromString(scalar.getType());
                    if (this.result == null) {
                        this.result = new PHPClassType(scalar.getType());
                    }
                }
            }
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

