/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.List;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.core.CodeFormatterVisitor;
import org.eclipse.php.formatter.core.ReplaceEdit;
import org.eclipse.php.formatter.ui.Logger;
import org.eclipse.php.formatter.ui.preferences.PhpPreview;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.swt.widgets.Composite;

public class CodeFormatterPreview
extends PhpPreview {
    private final IDocument fPreviewDocument = new Document();
    protected String fOriInput;

    public CodeFormatterPreview(CodeFormatterPreferences codeFormatterPreferences, Composite parent) {
        super(codeFormatterPreferences, parent);
    }

    @Override
    protected void doFormatPreview() {
        this.fText.setRedraw(false);
        try {
            try {
                this.fPreviewDocument.set(this.fOriInput);
                Region region = new Region(0, this.fPreviewDocument.getLength());
                CodeFormatterVisitor codeFormatter = new CodeFormatterVisitor(this.fPreviewDocument, this.codeFormatterPreferences, System.getProperty("line.separator"), PHPVersion.PHP5_5, true, (IRegion)region);
                List changes = codeFormatter.getChanges();
                this.fInput = this.applyChanges(this.fOriInput, changes);
                this.setText(this.fInput);
            }
            catch (Exception e) {
                Logger.logException(e);
                this.fText.setRedraw(true);
            }
        }
        finally {
            this.fText.setRedraw(true);
        }
    }

    public void setPreviewText(String previewText) {
        assert (previewText != null);
        this.fOriInput = previewText;
        this.fInput = previewText;
        this.update();
    }

    private String applyChanges(String content, List<?> changes) {
        StringBuffer result = new StringBuffer(content);
        int i = changes.size() - 1;
        while (i >= 0) {
            ReplaceEdit replace = (ReplaceEdit)changes.get(i);
            result = result.replace(replace.offset, replace.getEnd(), replace.content);
            --i;
        }
        return result.toString();
    }
}

