/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZendDebuggerConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    protected Button fRunWithDebugInfo;
    protected Text fDebugTextBox;
    protected Text fClientIP;
    protected Text fDebugResponseTimeout;
    protected Button fUseNewProtocol;
    protected ZendDebuggerConfiguration zendDebuggerConfiguration;

    public ZendDebuggerConfigurationDialog(ZendDebuggerConfiguration zendDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.zendDebuggerConfiguration = zendDebuggerConfiguration;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = (Composite)super.createDialogArea(parent);
        this.setTitle(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebuggerSettings);
        Composite composite = this.createSubsection(parent, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebugger);
        this.fRunWithDebugInfo = this.addCheckBox(composite, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_runWithDebugInfo, PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, 0);
        this.addLabelControl(composite, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT);
        this.fDebugTextBox = this.addTextField(composite, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 6, 2);
        GridData gridData = (GridData)this.fDebugTextBox.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.fDebugTextBox.addModifyListener((ModifyListener)new DebugPortValidateListener());
        this.addLabelControl(composite, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_client_host_ip, PHPDebugCorePreferenceNames.CLIENT_IP);
        this.fClientIP = this.addTextField(composite, PHPDebugCorePreferenceNames.CLIENT_IP, 0, 2);
        gridData = (GridData)this.fClientIP.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.addLabelControl(composite, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_debug_response_timeout, PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT);
        this.fDebugResponseTimeout = this.addTextField(composite, PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 0, 2);
        gridData = (GridData)this.fDebugResponseTimeout.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.fDebugResponseTimeout.addModifyListener((ModifyListener)new DebugResponseTimeoutListener());
        this.fUseNewProtocol = this.addCheckBox(composite, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_useNewProtocol, PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, 0);
        this.internalInitializeValues();
        return composite;
    }

    private void internalInitializeValues() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        this.fRunWithDebugInfo.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO));
        this.fDebugTextBox.setText(Integer.toString(prefs.getInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT)));
        this.fClientIP.setText(prefs.getString(PHPDebugCorePreferenceNames.CLIENT_IP));
        this.fDebugResponseTimeout.setText(Integer.toString(prefs.getInt(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT)));
        this.fUseNewProtocol.setSelection(prefs.getBoolean(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL));
    }

    protected void okPressed() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        prefs.setValue(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.fRunWithDebugInfo.getSelection());
        prefs.setValue(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, this.fDebugTextBox.getText());
        prefs.setValue(PHPDebugCorePreferenceNames.CLIENT_IP, this.fClientIP.getText());
        prefs.setValue(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, Integer.parseInt(this.fDebugResponseTimeout.getText()));
        prefs.setValue(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, this.fUseNewProtocol.getSelection());
        PHPDebugPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }

    public class DebugPortValidateListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            String errorMessage = null;
            boolean valid = true;
            String value = ((Text)e.widget).getText();
            try {
                Integer iValue = Integer.valueOf(value);
                int i = iValue;
                if (i < 0 || i > 65535) {
                    valid = false;
                    errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
                }
            }
            catch (NumberFormatException numberFormatException) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
            }
            catch (Exception exception) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.DebuggerConfigurationDialog_invalidPort;
            }
            ZendDebuggerConfigurationDialog.this.setErrorMessage(errorMessage);
            Button bt = ZendDebuggerConfigurationDialog.this.getButton(0);
            if (bt != null) {
                bt.setEnabled(valid);
            }
        }
    }

    public class DebugResponseTimeoutListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            String errorMessage = null;
            boolean valid = true;
            String value = ((Text)e.widget).getText();
            try {
                Integer iValue = Integer.valueOf(value);
                int i = iValue;
                if (i < 5000) {
                    valid = false;
                    errorMessage = NLS.bind((String)PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time, (Object)5000);
                }
            }
            catch (Exception exception) {
                valid = false;
                errorMessage = PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time_exc;
            }
            ZendDebuggerConfigurationDialog.this.setErrorMessage(errorMessage);
            Button bt = ZendDebuggerConfigurationDialog.this.getButton(0);
            if (bt != null) {
                bt.setEnabled(valid);
            }
        }
    }
}

