/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.DefaultIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.IAfterNewLineAutoEditStrategy;
import org.eclipse.php.internal.ui.text.PHPDocumentRegionEdgeMatcher;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;

public class PairParenthesesAutoEditStrategy
implements IAfterNewLineAutoEditStrategy {
    private static final char PAREN_OPEN = '(';
    private static final char PAREN_CLOSE = ')';
    private static final char BRACKET_OPEN = '[';
    private static final char BRACKET_CLOSE = ']';
    private static PHPDocumentRegionEdgeMatcher matcher = new PHPDocumentRegionEdgeMatcher();

    private ITextRegion getPhpToken(IStructuredDocumentRegion sdRegion, int offset) {
        try {
            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
            int regionStart = sdRegion.getStartOffset(tRegion);
            if (tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += tRegion.getStart();
            }
            if (tRegion instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                tRegion = scriptRegion.getPhpToken(offset - regionStart);
                return tRegion;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    @Override
    public int autoEditAfterNewLine(IStructuredDocument document, DocumentCommand command, StringBuffer buffer) {
        try {
            boolean isClosingParen = this.isClosingParen(document, command);
            int offset = command.offset;
            int rvPosition = offset + buffer.length();
            if (!isClosingParen) {
                rvPosition += this.copyRestOfLine(document, command, buffer);
            }
            int parenCloseCounter = 0;
            int currOffset = offset;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(currOffset);
            int regionStart = sdRegion.getStart();
            String text = sdRegion.getFullText();
            ITextRegion tRegion = null;
            int indexInText = text.length() - 1;
            while (indexInText >= 0) {
                char currChar = text.charAt(indexInText);
                if (currChar == ')' || currChar == ']') {
                    tRegion = this.getPhpToken(sdRegion, regionStart + indexInText);
                    if (tRegion == null || tRegion.getType() == "PHP_ARRAY") {
                        ++parenCloseCounter;
                    }
                } else if (currChar == '(' || currChar == '[') {
                    tRegion = this.getPhpToken(sdRegion, regionStart + indexInText);
                    boolean found = false;
                    if (tRegion != null) {
                        if (tRegion.getType().equals("PHP_ARRAY")) {
                            found = true;
                        } else if (tRegion.getType().equals("PHP_TOKEN")) {
                            tRegion.getLength();
                        }
                    }
                    if (!found) {
                        --indexInText;
                        continue;
                    }
                    if (--parenCloseCounter < 0) {
                        if (matcher.match((IDocument)document, regionStart + indexInText + 1) == null) break;
                        ++parenCloseCounter;
                    }
                }
                --indexInText;
            }
            if (isClosingParen) {
                rvPosition += this.copyRestOfLine(document, command, buffer);
            }
            return rvPosition;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return -1;
        }
    }

    private boolean isClosingParen(IStructuredDocument document, DocumentCommand command) throws BadLocationException {
        String lineEnd;
        int documentLength = document.getLength();
        if (command.offset + command.length == documentLength) {
            return false;
        }
        int offset = command.offset;
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        int endOffset = lineInfo.getOffset() + lineInfo.getLength();
        int lengthToCopyDown = endOffset - offset;
        IStructuredDocumentRegion[] structuredDocumentRegions = document.getStructuredDocumentRegions(offset, lengthToCopyDown);
        if (structuredDocumentRegions != null && structuredDocumentRegions.length > 0) {
            int absolutOffset;
            ITextRegion regionAtCharacterOffset;
            IStructuredDocumentRegion structuredDocumentRegion = structuredDocumentRegions[0];
            ITextRegion firstRegion = structuredDocumentRegion.getFirstRegion();
            ITextRegion lastRegion = structuredDocumentRegion.getLastRegion();
            int xmlRelativeOffset = 0;
            if (!(firstRegion instanceof ContextRegion) && (regionAtCharacterOffset = structuredDocumentRegion.getRegionAtCharacterOffset(offset)) instanceof ContextRegionContainer) {
                ContextRegionContainer phpContext = (ContextRegionContainer)regionAtCharacterOffset;
                lastRegion = phpContext.getLastRegion();
                firstRegion = phpContext.getFirstRegion();
                xmlRelativeOffset = firstRegion.getLength();
            }
            if ((absolutOffset = lastRegion.getStart() + structuredDocumentRegion.getStartOffset() + xmlRelativeOffset) <= endOffset && offset <= absolutOffset) {
                lengthToCopyDown = absolutOffset - offset;
            }
        }
        return (lineEnd = document.get(offset, lengthToCopyDown).trim()).startsWith(")") || lineEnd.startsWith("]");
    }

    private int copyRestOfLine(IStructuredDocument document, DocumentCommand command, StringBuffer buffer) throws BadLocationException {
        int documentLength = document.getLength();
        if (command.offset + command.length == documentLength) {
            return 0;
        }
        int offset = command.offset;
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        int endOffset = lineInfo.getOffset() + lineInfo.getLength();
        int whiteSpacesAdded = 0;
        int lengthToCopyDown = endOffset - offset;
        IStructuredDocumentRegion[] structuredDocumentRegions = document.getStructuredDocumentRegions(offset, lengthToCopyDown);
        if (structuredDocumentRegions != null && structuredDocumentRegions.length > 0) {
            int absolutOffset;
            ITextRegion regionAtCharacterOffset;
            IStructuredDocumentRegion structuredDocumentRegion = structuredDocumentRegions[0];
            ITextRegion firstRegion = structuredDocumentRegion.getFirstRegion();
            ITextRegion lastRegion = structuredDocumentRegion.getLastRegion();
            int xmlRelativeOffset = 0;
            if (!(firstRegion instanceof ContextRegion) && (regionAtCharacterOffset = structuredDocumentRegion.getRegionAtCharacterOffset(offset)) instanceof ContextRegionContainer) {
                ContextRegionContainer phpContext = (ContextRegionContainer)regionAtCharacterOffset;
                lastRegion = phpContext.getLastRegion();
                firstRegion = phpContext.getFirstRegion();
                xmlRelativeOffset = firstRegion.getLength();
            }
            if ((absolutOffset = lastRegion.getStart() + structuredDocumentRegion.getStartOffset() + xmlRelativeOffset) <= endOffset && offset <= absolutOffset) {
                lengthToCopyDown = absolutOffset - offset;
            }
        }
        String lineEnd = document.get(offset, lengthToCopyDown);
        int i = 0;
        while (i < lineEnd.length()) {
            char c = lineEnd.charAt(i);
            --lengthToCopyDown;
            if (c == '\n' || c == '\r' || !Character.isWhitespace(c)) {
                command.length += i;
                ++lengthToCopyDown;
                break;
            }
            ++i;
        }
        String trimmedLineEnd = lineEnd.trim();
        if (trimmedLineEnd.length() > 0 && (trimmedLineEnd.charAt(0) == ')' || trimmedLineEnd.charAt(0) == ']')) {
            int indentationSize = FormatterUtils.getFormatterCommonPrferences().getIndentationSize((IDocument)document);
            char indentationChar = FormatterUtils.getFormatterCommonPrferences().getIndentationChar((IDocument)document);
            int i2 = 0;
            while (i2 < indentationSize) {
                buffer.append(indentationChar);
                ++whiteSpacesAdded;
                ++i2;
            }
            buffer.append(document.getLineDelimiter());
            int baseline = DefaultIndentationStrategy.getIndentationBaseLine((IStructuredDocument)document, (int)document.getLineOfOffset(offset), (int)offset, (boolean)true);
            lineInfo = document.getLineInformation(baseline);
            String blanks = FormatterUtils.getLineBlanks((IDocument)document, (IRegion)lineInfo);
            buffer.append(blanks);
        }
        char nextChar = document.getChar(offset += command.length);
        while (lengthToCopyDown > 0) {
            buffer.append(nextChar);
            ++command.length;
            if (++offset == documentLength) break;
            nextChar = document.getChar(offset);
            --lengthToCopyDown;
        }
        return whiteSpacesAdded;
    }
}

