/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.documentation;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.util.MethodOverrideTester;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.typeinference.FakeConstructor;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.MagicMemberUtil;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.corext.util.SuperTypeHierarchyCache;
import org.eclipse.php.internal.ui.documentation.BuiltinDoc;
import org.eclipse.php.internal.ui.documentation.PHPDocumentationMessages;
import org.eclipse.php.internal.ui.documentation.PHPElementLinks;

public class PHPDocumentationContentAccess {
    private static final Pattern INLINE_LINK_PATTERN = Pattern.compile("\\{@link[\\s]+[^\\}]*\\}");
    private static final String BLOCK_TAG_START = "<dl>";
    private static final String BLOCK_TAG_END = "</dl>";
    private static final String BlOCK_TAG_ENTRY_START = "<dd>";
    private static final String BlOCK_TAG_ENTRY_END = "</dd>";
    private static final String PARAM_NAME_START = "<b>";
    private static final String PARAM_NAME_END = "</b> ";
    private static final int PARAMETER_TYPE_TYPE = 1;
    private static final int PARAMETER_NAME_TYPE = 2;
    private static final int PARAMETER_DESCRIPTION_TYPE = 3;
    private final IMember fMember;
    private final IMethod fMethod;
    private final PHPDocBlock fJavadoc;
    private final JavadocLookup fJavadocLookup;
    private StringBuffer fBuf;
    private StringBuffer fMainDescription;
    private StringBuffer fReturnDescription;
    private StringBuffer[] fParamDescriptions;
    private StringBuffer[] fParamTypes;
    private HashMap<String, StringBuffer> fExceptionDescriptions;

    private PHPDocumentationContentAccess(IMethod method, PHPDocBlock javadoc, JavadocLookup lookup) {
        this.fMember = method;
        this.fMethod = method;
        this.fJavadoc = javadoc;
        this.fJavadocLookup = lookup;
    }

    private PHPDocumentationContentAccess(IMember member, PHPDocBlock javadoc) {
        this.fMember = member;
        this.fMethod = null;
        this.fJavadoc = javadoc;
        this.fJavadocLookup = JavadocLookup.NONE;
    }

    public static String getHTMLContent(IMember member) throws ModelException {
        return PHPDocumentationContentAccess.getHTMLContentFromSource(member);
    }

    private static StringBuffer createSuperMethodReferences(final IMethod method) throws ModelException {
        boolean hasSuperInterfaceMethods;
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(type);
        final MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(type);
        final ArrayList superInterfaceMethods = new ArrayList();
        final IMethod[] superClassMethod = new IMethod[1];
        new InheritDocVisitor(){

            @Override
            public Object visit(IType currType) throws ModelException {
                IMethod overridden = tester.findOverriddenMethodInType(currType, method);
                if (overridden == null) {
                    return InheritDocVisitor.CONTINUE;
                }
                if (PHPFlags.isInterface((int)currType.getFlags())) {
                    superInterfaceMethods.add(overridden);
                } else {
                    superClassMethod[0] = overridden;
                }
                return STOP_BRANCH;
            }
        }.visitInheritDoc(type, hierarchy);
        boolean bl = hasSuperInterfaceMethods = superInterfaceMethods.size() != 0;
        if (!hasSuperInterfaceMethods && superClassMethod[0] == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<div>");
        if (hasSuperInterfaceMethods) {
            buf.append(PARAM_NAME_START);
            buf.append(PHPDocumentationMessages.JavaDoc2HTMLTextReader_specified_by_section);
            buf.append(PARAM_NAME_END);
            Iterator iter = superInterfaceMethods.iterator();
            while (iter.hasNext()) {
                IMethod overridden = (IMethod)iter.next();
                buf.append(PHPDocumentationContentAccess.createMethodInTypeLinks(overridden));
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
        }
        if (superClassMethod[0] != null) {
            if (hasSuperInterfaceMethods) {
                buf.append(", ");
            }
            buf.append(PARAM_NAME_START);
            buf.append(PHPDocumentationMessages.JavaDoc2HTMLTextReader_overrides_section);
            buf.append(PARAM_NAME_END);
            buf.append(PHPDocumentationContentAccess.createMethodInTypeLinks(superClassMethod[0]));
        }
        buf.append("</div>");
        return buf;
    }

    private static String createMethodInTypeLinks(IMethod overridden) {
        CharSequence methodLink = PHPDocumentationContentAccess.createSimpleMemberLink((IMember)overridden);
        CharSequence typeLink = PHPDocumentationContentAccess.createSimpleMemberLink((IMember)overridden.getDeclaringType());
        String methodInType = MessageFormat.format(PHPDocumentationMessages.JavaDoc2HTMLTextReader_method_in_type, methodLink, typeLink);
        return methodInType;
    }

    private static CharSequence createSimpleMemberLink(IMember member) {
        StringBuffer buf = new StringBuffer();
        buf.append("<a href='");
        try {
            String uri = PHPElementLinks.createURI("eclipse-phpdoc", (IModelElement)member);
            buf.append(uri);
        }
        catch (URISyntaxException e) {
            PHPUiPlugin.log(e);
        }
        buf.append("'>");
        ScriptElementLabels.getDefault().getElementLabel((IModelElement)member, 0L, buf);
        buf.append("</a>");
        return buf;
    }

    private static String getHTMLContentFromSource(IMember member) throws ModelException {
        return PHPDocumentationContentAccess.javadoc2HTML(member);
    }

    private static PHPDocBlock getJavadocNode(IMember member) {
        if (member instanceof IType) {
            return PHPModelUtils.getDocBlock((IType)((IType)member));
        }
        if (member instanceof IMethod) {
            PHPDocBlock result = PHPModelUtils.getDocBlock((IMethod)((IMethod)member));
            if (result == null && member instanceof FakeConstructor) {
                FakeConstructor fc = (FakeConstructor)member;
                result = PHPModelUtils.getDocBlock((IType)((IType)fc.getParent()));
            }
            return result;
        }
        if (member instanceof IField) {
            return PHPModelUtils.getDocBlock((IField)((IField)member));
        }
        return null;
    }

    private static String javadoc2HTML(IMember member) {
        PHPDocBlock javadoc = PHPDocumentationContentAccess.getJavadocNode(member);
        if (javadoc == null) {
            MagicMemberUtil.MagicMember magicMember = PHPDocumentationContentAccess.getMagicMember(member);
            if (magicMember != null) {
                return PHPDocumentationContentAccess.getHTMLForMagicMember(member, magicMember);
            }
            javadoc = new PHPDocBlock(0, 0, null, null, new PHPDocTag[0]);
        }
        if (PHPDocumentationContentAccess.canInheritJavadoc(member)) {
            IMethod method = (IMethod)member;
            IType declaringType = method.getDeclaringType();
            JavadocLookup lookup = declaringType == null ? JavadocLookup.NONE : new JavadocLookup(method.getDeclaringType(), null, null);
            return new PHPDocumentationContentAccess(method, javadoc, lookup).toHTML();
        }
        return new PHPDocumentationContentAccess(member, javadoc).toHTML();
    }

    private static String getHTMLForMagicMember(IMember member, MagicMemberUtil.MagicMember magicMember) {
        StringBuffer fBuf = new StringBuffer();
        if (PHPDocumentationContentAccess.appendBuiltinDoc(member, fBuf)) {
            return fBuf.toString();
        }
        if (magicMember instanceof MagicMemberUtil.MagicField) {
            MagicMemberUtil.MagicField magicField = (MagicMemberUtil.MagicField)magicMember;
            fBuf.append(magicField.desc);
            fBuf.append(BLOCK_TAG_START);
            fBuf.append("<dt>");
            fBuf.append("Type");
            fBuf.append("</dt>");
            fBuf.append(BlOCK_TAG_ENTRY_START);
            fBuf.append("&nbsp");
            fBuf.append(magicField.type);
            fBuf.append(BlOCK_TAG_ENTRY_END);
            fBuf.append(BLOCK_TAG_END);
        } else {
            MagicMemberUtil.MagicMethod magicMethod = (MagicMemberUtil.MagicMethod)magicMember;
            fBuf.append(magicMethod.desc);
            fBuf.append(BLOCK_TAG_START);
            if (magicMethod.parameterNames != null && magicMethod.parameterNames.length > 0) {
                fBuf.append("<dt>");
                fBuf.append(PHPDocumentationMessages.JavaDoc2HTMLTextReader_parameters_section);
                fBuf.append("</dt>");
                int i = 0;
                while (i < magicMethod.parameterNames.length) {
                    fBuf.append(BlOCK_TAG_ENTRY_START);
                    fBuf.append("&nbsp");
                    String parameterName = magicMethod.parameterNames[i];
                    String parameterType = magicMethod.parameterTypes[i];
                    if (parameterType != null) {
                        fBuf.append(PARAM_NAME_START);
                        fBuf.append(parameterType);
                        fBuf.append(PARAM_NAME_END);
                    }
                    fBuf.append(PARAM_NAME_START);
                    fBuf.append(parameterName);
                    fBuf.append(PARAM_NAME_END);
                    fBuf.append(BlOCK_TAG_ENTRY_END);
                    ++i;
                }
            }
            if (magicMethod.returnType != null) {
                fBuf.append("<dt>");
                fBuf.append(PHPDocumentationMessages.JavaDoc2HTMLTextReader_returns_section);
                fBuf.append("</dt>");
                fBuf.append(BlOCK_TAG_ENTRY_START);
                fBuf.append("&nbsp");
                fBuf.append(magicMethod.returnType);
                fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            fBuf.append(BLOCK_TAG_END);
        }
        return fBuf.toString();
    }

    private static MagicMemberUtil.MagicMember getMagicMember(IMember member) {
        block7: {
            IType type;
            block8: {
                PHPDocTag[] tags;
                if (!(member instanceof IMethod) && !(member instanceof IField)) break block7;
                type = null;
                if (!(member instanceof IMethod)) break block8;
                type = ((IMethod)member).getDeclaringType();
                PHPDocBlock doc = PHPModelUtils.getDocBlock((IType)type);
                if (doc == null) break block7;
                Pattern WHITESPACE_SEPERATOR = Pattern.compile("\\s+");
                PHPDocTag[] pHPDocTagArray = tags = doc.getTags();
                int n = tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] split;
                    PHPDocTag docTag = pHPDocTagArray[n2];
                    int tagKind = docTag.getTagKind();
                    if (tagKind == 33 && (split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim())).length >= 2) {
                        if (MagicMemberUtil.removeParenthesis((String[])split).equals(member.getElementName())) {
                            return MagicMemberUtil.getMagicMethod((String)docTag.getValue());
                        }
                        if (MagicMemberUtil.removeParenthesis2((String[])split).equals(member.getElementName())) {
                            return MagicMemberUtil.getMagicMethod2((String)docTag.getValue());
                        }
                    }
                    ++n2;
                }
                break block7;
            }
            type = ((IField)member).getDeclaringType();
            PHPDocBlock doc = PHPModelUtils.getDocBlock((IType)type);
            if (doc != null) {
                PHPDocTag[] tags;
                Pattern WHITESPACE_SEPERATOR = Pattern.compile("\\s+");
                PHPDocTag[] pHPDocTagArray = tags = doc.getTags();
                int n = tags.length;
                int n3 = 0;
                while (n3 < n) {
                    String[] split;
                    PHPDocTag docTag = pHPDocTagArray[n3];
                    int tagKind = docTag.getTagKind();
                    if ((tagKind == 30 || tagKind == 31 || tagKind == 32) && (split = WHITESPACE_SEPERATOR.split(docTag.getValue().trim())).length >= 2 && split[1].equals(member.getElementName())) {
                        return MagicMemberUtil.getMagicField((String)docTag.getValue());
                    }
                    ++n3;
                }
            }
        }
        return null;
    }

    private static boolean canInheritJavadoc(IMember member) {
        if (member instanceof IMethod && member.getScriptProject().exists()) {
            try {
                return !((IMethod)member).isConstructor();
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
        return false;
    }

    private String toHTML() {
        boolean hasNamespace;
        PHPDocTag[] tags;
        this.fBuf = new StringBuffer();
        if (PHPDocumentationContentAccess.appendBuiltinDoc(this.fMember, this.fBuf)) {
            return this.fBuf.toString();
        }
        List<String> parameterNames = this.initParameterNames();
        ArrayList<String> exceptionNames = new ArrayList<String>();
        PHPDocTag deprecatedTag = null;
        PHPDocTag returnTag = null;
        PHPDocTag namespaceTag = null;
        ArrayList<PHPDocTag> parameters = new ArrayList<PHPDocTag>();
        ArrayList<PHPDocTag> exceptions = new ArrayList<PHPDocTag>();
        ArrayList<PHPDocTag> versions = new ArrayList<PHPDocTag>();
        ArrayList<PHPDocTag> authors = new ArrayList<PHPDocTag>();
        ArrayList<PHPDocTag> sees = new ArrayList<PHPDocTag>();
        ArrayList<PHPDocTag> since = new ArrayList<PHPDocTag>();
        ArrayList<PHPDocTag> rest = new ArrayList<PHPDocTag>();
        String shortDescription = this.fJavadoc.getShortDescription();
        String longDescription = this.fJavadoc.getLongDescription();
        PHPDocTag[] pHPDocTagArray = tags = this.fJavadoc.getTags();
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleReference[] fragments;
            PHPDocTag tag = pHPDocTagArray[n2];
            if (7 == tag.getTagKind()) {
                parameters.add(tag);
                fragments = tag.getReferences();
                if (fragments.length == 0 && parameterNames.size() > parameters.indexOf(tag)) {
                    parameterNames.set(parameters.indexOf(tag), null);
                }
                SimpleReference[] simpleReferenceArray = fragments;
                int n3 = fragments.length;
                int n4 = 0;
                while (n4 < n3) {
                    int paramIndex;
                    SimpleReference reference = simpleReferenceArray[n4];
                    String name = reference.getName();
                    if (!(reference instanceof TypeReference) && reference instanceof VariableReference && (paramIndex = parameterNames.indexOf(name)) != -1) {
                        parameterNames.set(paramIndex, null);
                    }
                    ++n4;
                }
            } else if (6 == tag.getTagKind()) {
                if (returnTag == null) {
                    returnTag = tag;
                }
            } else if (34 == tag.getTagKind()) {
                if (namespaceTag == null) {
                    namespaceTag = tag;
                }
            } else if (29 == tag.getTagKind()) {
                SimpleReference first;
                exceptions.add(tag);
                fragments = tag.getReferences();
                if (fragments.length > 0 && (first = fragments[0]) instanceof TypeReference) {
                    exceptionNames.add(((TypeReference)first).getName());
                }
            } else if (24 == tag.getTagKind()) {
                since.add(tag);
            } else if (28 == tag.getTagKind()) {
                versions.add(tag);
            } else if (1 == tag.getTagKind()) {
                authors.add(tag);
            } else if (8 == tag.getTagKind()) {
                sees.add(tag);
            } else if (2 == tag.getTagKind()) {
                if (deprecatedTag == null) {
                    deprecatedTag = tag;
                }
            } else {
                rest.add(tag);
            }
            ++n2;
        }
        if (deprecatedTag != null) {
            this.handleDeprecatedTag(deprecatedTag);
        }
        if (shortDescription != null && shortDescription.length() > 0) {
            this.fBuf.append(shortDescription);
        }
        if (longDescription != null && longDescription.length() > 0) {
            this.fBuf.append("<p>");
            longDescription = longDescription.replaceAll("\r\n", "<p>");
            longDescription = longDescription.replaceAll("\n\r", "<p>");
            longDescription = longDescription.replaceAll("\n", "<p>");
            longDescription = longDescription.replaceAll("\r", "<p>");
            this.fBuf.append(longDescription);
        } else if (this.fMethod != null) {
            CharSequence inherited = this.fJavadocLookup.getInheritedMainDescription(this.fMethod);
            this.handleInherited(inherited);
        }
        this.handleInlineLinks();
        CharSequence[] parameterDescriptions = new CharSequence[parameterNames.size()];
        CharSequence[] parameterTypes = new CharSequence[parameterNames.size()];
        boolean hasInheritedParameters = this.inheritParameterDescriptions(parameterNames, parameterDescriptions, parameterTypes);
        boolean hasParameters = parameters.size() > 0 || hasInheritedParameters;
        CharSequence returnDescription = null;
        if (returnTag == null) {
            returnDescription = this.fJavadocLookup.getInheritedReturnDescription(this.fMethod);
        }
        boolean hasReturnTag = returnTag != null || returnDescription != null;
        CharSequence[] exceptionDescriptions = new CharSequence[exceptionNames.size()];
        boolean hasInheritedExceptions = this.inheritExceptionDescriptions(exceptionNames, exceptionDescriptions);
        boolean hasExceptions = exceptions.size() > 0 || hasInheritedExceptions;
        boolean bl = hasNamespace = namespaceTag != null;
        if (hasParameters || hasReturnTag || hasExceptions || hasNamespace || versions.size() > 0 || authors.size() > 0 || since.size() > 0 || sees.size() > 0 || rest.size() > 0 || this.fBuf.length() > 0 && (parameterDescriptions.length > 0 || exceptionDescriptions.length > 0)) {
            this.handleSuperMethodReferences();
            this.fBuf.append(BLOCK_TAG_START);
            this.handleParameterTags(parameters, parameterNames, parameterTypes, parameterDescriptions);
            this.handleReturnTag(returnTag, returnDescription);
            this.handleNamespaceTag(namespaceTag);
            this.handleExceptionTags(exceptions, exceptionNames, exceptionDescriptions);
            this.handleBlockTags(PHPDocumentationMessages.JavaDoc2HTMLTextReader_since_section, since);
            this.handleBlockTags(PHPDocumentationMessages.JavaDoc2HTMLTextReader_version_section, versions);
            this.handleBlockTags(PHPDocumentationMessages.JavaDoc2HTMLTextReader_author_section, authors);
            this.handleBlockTags(PHPDocumentationMessages.JavaDoc2HTMLTextReader_see_section, sees);
            this.handleBlockTags(rest);
            this.fBuf.append(BLOCK_TAG_END);
        } else if (this.fBuf.length() > 0) {
            this.handleSuperMethodReferences();
        }
        String result = this.fBuf.toString();
        this.fBuf = null;
        return result;
    }

    private void handleInlineLinks() {
        Matcher m = INLINE_LINK_PATTERN.matcher(this.fBuf);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String[] strs = m.group().split("[\\s]+", 3);
            String url = this.removeLastRightCurlyBrace(strs[1]);
            if (url.toLowerCase().startsWith("http")) {
                String description = "";
                description = strs.length == 3 ? this.removeLastRightCurlyBrace(strs[2]) : url;
                String link = "<a href=\"" + url + "\">" + description + "</a>";
                sb.append(this.fBuf.toString().replace(m.group(), link));
                continue;
            }
            sb.append(this.fBuf.toString().replace(m.group(), this.handleLink(Arrays.asList(new TypeReference(0, 0, url)))));
        }
        this.fBuf.append(sb);
        sb = null;
    }

    private String removeLastRightCurlyBrace(String str) {
        if (str.endsWith("}")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void handleDeprecatedTag(PHPDocTag tag) {
        this.fBuf.append("<p><b>");
        this.fBuf.append(PHPDocumentationMessages.JavaDoc2HTMLTextReader_deprecated_section);
        this.fBuf.append("</b> <i>");
        this.handleContentElements(tag);
        this.fBuf.append("</i><p>");
    }

    private void handleSuperMethodReferences() {
        if (this.fMethod != null && this.fMethod.getDeclaringType() != null) {
            try {
                StringBuffer superMethodReferences = PHPDocumentationContentAccess.createSuperMethodReferences(this.fMethod);
                if (superMethodReferences != null) {
                    this.fBuf.append(superMethodReferences);
                }
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    private List<String> initParameterNames() {
        if (this.fMethod != null) {
            try {
                return new ArrayList<String>(Arrays.asList(this.fMethod.getParameterNames()));
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean inheritParameterDescriptions(List<String> parameterNames, CharSequence[] parameterDescriptions, CharSequence[] parameterTypes) {
        boolean hasInheritedParameters = false;
        if (this.fMethod != null && this.fMethod.getDeclaringType() == null) {
            return hasInheritedParameters;
        }
        int i = 0;
        while (i < parameterNames.size()) {
            String name = parameterNames.get(i);
            if (name != null) {
                parameterDescriptions[i] = this.fJavadocLookup.getInheritedParamDescription(this.fMethod, i);
                parameterTypes[i] = this.fJavadocLookup.getInheritedParamType(this.fMethod, i);
                if (parameterDescriptions[i] != null) {
                    hasInheritedParameters = true;
                }
            }
            ++i;
        }
        return hasInheritedParameters;
    }

    private boolean inheritExceptionDescriptions(List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
        boolean hasInheritedExceptions = false;
        if (this.fMethod != null && this.fMethod.getDeclaringType() == null) {
            return hasInheritedExceptions;
        }
        int i = 0;
        while (i < exceptionNames.size()) {
            String name = exceptionNames.get(i);
            if (name != null) {
                exceptionDescriptions[i] = this.fJavadocLookup.getInheritedExceptionDescription(this.fMethod, name);
                if (exceptionDescriptions[i] != null) {
                    hasInheritedExceptions = true;
                }
            }
            ++i;
        }
        return hasInheritedExceptions;
    }

    CharSequence getMainDescription() {
        if (this.fMainDescription == null) {
            this.fBuf = this.fMainDescription = new StringBuffer();
            String shortDescription = this.fJavadoc.getShortDescription();
            if (shortDescription != null && shortDescription.length() > 0) {
                this.fMainDescription.append(shortDescription);
            }
            this.fBuf = null;
        }
        return this.fMainDescription.length() > 0 ? this.fMainDescription : null;
    }

    CharSequence getReturnDescription() {
        if (this.fReturnDescription == null) {
            PHPDocTag[] tags;
            this.fBuf = this.fReturnDescription = new StringBuffer();
            PHPDocTag[] pHPDocTagArray = tags = this.fJavadoc.getTags();
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                if (6 == tag.getTagKind()) {
                    this.handleContentElements(tag);
                    break;
                }
                ++n2;
            }
            this.fBuf = null;
        }
        return this.fReturnDescription.length() > 0 ? this.fReturnDescription : null;
    }

    CharSequence getInheritedParamDescription(int paramIndex) throws ModelException {
        if (this.fMethod != null) {
            StringBuffer description;
            String[] parameterNames = this.fMethod.getParameterNames();
            if (paramIndex >= parameterNames.length) {
                return null;
            }
            if (this.fParamDescriptions == null) {
                this.fParamDescriptions = new StringBuffer[parameterNames.length];
            } else {
                description = this.fParamDescriptions[paramIndex];
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            this.fParamDescriptions[paramIndex] = description = new StringBuffer();
            this.fBuf = description;
            String paramName = parameterNames[paramIndex];
            String info = this.getParameterInfo(this.fJavadoc, paramName, 3);
            if (info != null) {
                description.append(info);
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    CharSequence getInheritedParamType(int paramIndex) throws ModelException {
        if (this.fMethod != null) {
            StringBuffer typeName;
            String[] parameterNames = this.fMethod.getParameterNames();
            if (paramIndex >= parameterNames.length) {
                return null;
            }
            if (this.fParamTypes == null) {
                this.fParamTypes = new StringBuffer[parameterNames.length];
            } else {
                typeName = this.fParamTypes[paramIndex];
                if (typeName != null) {
                    return typeName.length() > 0 ? typeName : null;
                }
            }
            this.fParamTypes[paramIndex] = typeName = new StringBuffer();
            this.fBuf = typeName;
            String paramName = parameterNames[paramIndex];
            String info = this.getParameterInfo(this.fJavadoc, paramName, 1);
            if (info != null) {
                typeName.append(info);
            }
            this.fBuf = null;
            return typeName.length() > 0 ? typeName : null;
        }
        return null;
    }

    CharSequence getExceptionDescription(String simpleName) {
        if (this.fMethod != null) {
            StringBuffer description;
            if (this.fExceptionDescriptions == null) {
                this.fExceptionDescriptions = new HashMap();
            } else {
                description = this.fExceptionDescriptions.get(simpleName);
                if (description != null) {
                    return description.length() > 0 ? description : null;
                }
            }
            description = new StringBuffer();
            this.fExceptionDescriptions.put(simpleName, description);
            this.fBuf = description;
            List<PHPDocTag> tags = Arrays.asList(this.fJavadoc.getTags());
            for (PHPDocTag tag : tags) {
                String name;
                SimpleReference first;
                List<SimpleReference> fragments;
                if (29 != tag.getTagKind() || (fragments = Arrays.asList(tag.getReferences())).size() <= 0 || !((first = fragments.get(0)) instanceof Identifier) || !(name = ((Identifier)first).getName()).equals(simpleName)) continue;
                if (fragments.size() <= 1) break;
                this.handleContentElements(tag);
                break;
            }
            this.fBuf = null;
            return description.length() > 0 ? description : null;
        }
        return null;
    }

    private void handleContentElements(PHPDocTag tag) {
        this.fBuf.append(tag.getValue());
    }

    private boolean handleInherited(CharSequence inherited) {
        if (inherited == null) {
            return false;
        }
        this.fBuf.append(inherited);
        return true;
    }

    private void handleBlockTags(String title, List tags) {
        if (tags.isEmpty()) {
            return;
        }
        this.handleBlockTagTitle(title);
        for (PHPDocTag tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            if (8 == tag.getTagKind()) {
                this.handleSeeTag(tag);
            } else {
                this.handleContentElements(tag);
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleReturnTag(PHPDocTag tag, CharSequence returnDescription) {
        if (tag == null && returnDescription == null) {
            return;
        }
        this.handleBlockTagTitle(PHPDocumentationMessages.JavaDoc2HTMLTextReader_returns_section);
        this.fBuf.append(BlOCK_TAG_ENTRY_START);
        this.doWorkAround();
        if (tag != null) {
            this.handleContentElements(tag);
        } else {
            this.fBuf.append(returnDescription);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleNamespaceTag(PHPDocTag tag) {
        if (tag == null) {
            return;
        }
        this.handleBlockTagTitle(PHPDocumentationMessages.JavaDoc2HTMLTextReader_namespace_section);
        this.fBuf.append(BlOCK_TAG_ENTRY_START);
        this.doWorkAround();
        if (tag != null) {
            this.handleContentElements(tag);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleBlockTags(List tags) {
        for (PHPDocTag tag : tags) {
            if (tag.getTagKind() == 35) continue;
            if (tag.getTagKind() == 12) {
                this.handleBlockTagTitle("Type");
            } else {
                this.handleBlockTagTitle(PHPDocTag.getTagKind((int)tag.getTagKind()));
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.doWorkAround();
            if (tag.getTagKind() == 23) {
                this.handleLinkTag(tag);
            } else {
                this.handleContentElements(tag);
            }
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
    }

    private void handleBlockTagTitle(String title) {
        this.fBuf.append("<dt>");
        this.fBuf.append(title);
        this.fBuf.append("</dt>");
    }

    private void handleSeeTag(PHPDocTag tag) {
        this.fBuf.append(this.handleLink(Arrays.asList(tag.getReferences())));
    }

    private void handleExceptionTags(List tags, List exceptionNames, CharSequence[] exceptionDescriptions) {
        if (tags.size() == 0 && this.containsOnlyNull(exceptionNames)) {
            return;
        }
        this.handleBlockTagTitle(PHPDocumentationMessages.JavaDoc2HTMLTextReader_throws_section);
        for (PHPDocTag tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.doWorkAround();
            this.handleThrowsTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < exceptionDescriptions.length) {
            CharSequence description = exceptionDescriptions[i];
            String name = (String)exceptionNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                if (description != null) {
                    this.fBuf.append(" - ");
                    this.fBuf.append(description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private void handleThrowsTag(PHPDocTag tag) {
        List<SimpleReference> fragments = Arrays.asList(tag.getReferences());
        int size = fragments.size();
        if (size > 0) {
            String value;
            String description;
            String exceptionName = "";
            if (fragments.get(0) instanceof TypeReference) {
                exceptionName = fragments.get(0).getName().trim();
                this.fBuf.append(exceptionName);
            }
            if ((description = (value = tag.getValue().trim()).substring(exceptionName.length())).length() > 0) {
                this.fBuf.append(" - ");
                this.fBuf.append(description.trim());
            }
        }
    }

    private void handleParameterTags(List tags, List parameterNames, CharSequence[] parameterTypes, CharSequence[] parameterDescriptions) {
        if (tags.size() == 0 && this.containsOnlyNull(parameterNames)) {
            return;
        }
        this.handleBlockTagTitle(PHPDocumentationMessages.JavaDoc2HTMLTextReader_parameters_section);
        for (PHPDocTag tag : tags) {
            this.fBuf.append(BlOCK_TAG_ENTRY_START);
            this.doWorkAround();
            this.handleParamTag(tag);
            this.fBuf.append(BlOCK_TAG_ENTRY_END);
        }
        int i = 0;
        while (i < parameterDescriptions.length) {
            CharSequence description = parameterDescriptions[i];
            String name = (String)parameterNames.get(i);
            if (name != null) {
                this.fBuf.append(BlOCK_TAG_ENTRY_START);
                this.doWorkAround();
                if (parameterTypes[i] != null) {
                    this.fBuf.append(PARAM_NAME_START);
                    this.fBuf.append(parameterTypes[i]);
                    this.fBuf.append(PARAM_NAME_END);
                }
                this.fBuf.append(PARAM_NAME_END);
                this.fBuf.append(PARAM_NAME_START);
                this.fBuf.append(name);
                this.fBuf.append(PARAM_NAME_END);
                if (description != null) {
                    this.fBuf.append(description);
                }
                this.fBuf.append(BlOCK_TAG_ENTRY_END);
            }
            ++i;
        }
    }

    private void handleParamTag(PHPDocTag tag) {
        if (tag.getReferences().length == 0) {
            this.fBuf.append(tag.getValue());
            return;
        }
        String parameterName = this.getParameterInfo(tag, 2);
        String parameterType = this.getParameterInfo(tag, 1);
        String description = this.getParameterInfo(tag, 3);
        this.fBuf.append(BlOCK_TAG_ENTRY_START);
        if (parameterType != null) {
            this.fBuf.append(PARAM_NAME_START);
            this.fBuf.append(parameterType);
            this.fBuf.append(PARAM_NAME_END);
        }
        this.fBuf.append(PARAM_NAME_START);
        this.fBuf.append(parameterName);
        this.fBuf.append(PARAM_NAME_END);
        if (description != null) {
            this.fBuf.append(description);
        }
        this.fBuf.append(BlOCK_TAG_ENTRY_END);
    }

    private void handleLinkTag(PHPDocTag tag) {
        this.fBuf.append("<a href=");
        this.fBuf.append(tag.getValue());
        this.fBuf.append(">").append(tag.getValue()).append("</a>");
    }

    private StringBuffer handleLink(List fragments) {
        StringBuffer sb = new StringBuffer();
        int fs = fragments.size();
        if (fs > 0) {
            Object first = fragments.get(0);
            String refTypeName = null;
            String refMemberName = null;
            String[] refMethodParamTypes = null;
            Object refMethodParamNames = null;
            if (first instanceof TypeReference) {
                TypeReference type = (TypeReference)first;
                String name = type.getName();
                int typeNameEnd = name.indexOf("::");
                if (typeNameEnd == -1) {
                    refTypeName = name;
                } else {
                    refTypeName = name.substring(0, typeNameEnd);
                    int argsListStart = name.indexOf(40, typeNameEnd);
                    if (argsListStart == -1) {
                        refMemberName = name.substring(typeNameEnd + "::".length());
                    } else {
                        refMemberName = name.substring(typeNameEnd + "::".length(), argsListStart);
                        int argsListEnd = name.indexOf(argsListStart, 41);
                        if (argsListEnd == -1) {
                            refMethodParamTypes = new String[]{};
                        } else {
                            String argsList = name.substring(argsListStart + ")".length(), argsListEnd);
                            String[] args = argsList.split(",");
                            int i = 0;
                            while (i < args.length) {
                                args[i] = args[i].trim();
                                ++i;
                            }
                            refMethodParamTypes = args;
                        }
                    }
                }
            }
            if (refTypeName != null) {
                sb.append("<a href='");
                try {
                    String scheme = "eclipse-phpdoc";
                    String uri = PHPElementLinks.createURI(scheme, (IModelElement)this.fMember, refTypeName, refMemberName, refMethodParamTypes);
                    sb.append(uri);
                }
                catch (URISyntaxException e) {
                    PHPUiPlugin.log(e);
                }
                sb.append("'>");
                if (fs <= 1) {
                    sb.append(refTypeName);
                    if (refMemberName != null) {
                        if (refTypeName.length() > 0) {
                            sb.append("::");
                        }
                        sb.append(refMemberName);
                        if (refMethodParamTypes != null) {
                            sb.append('(');
                            int i = 0;
                            while (i < refMethodParamTypes.length) {
                                String pType = refMethodParamTypes[i];
                                sb.append(pType);
                                void pName = refMethodParamNames[i];
                                if (pName != null) {
                                    sb.append(' ').append((String)pName);
                                }
                                if (i < refMethodParamTypes.length - 1) {
                                    sb.append(", ");
                                }
                                ++i;
                            }
                            sb.append(')');
                        }
                    }
                }
                sb.append("</a>");
            }
        }
        return sb;
    }

    private boolean containsOnlyNull(List parameterNames) {
        Iterator iter = parameterNames.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    private String getParameterInfo(PHPDocBlock phpDoc, String paramName, int infoType) {
        PHPDocTag[] pHPDocTagArray = phpDoc.getTags(7);
        int n = pHPDocTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag tag = pHPDocTagArray[n2];
            String name = this.getParameterInfo(tag, 2);
            if (name != null && name.equals(paramName)) {
                return this.getParameterInfo(tag, infoType);
            }
            ++n2;
        }
        return null;
    }

    private String getParameterInfo(PHPDocTag tag, int infoType) {
        if (tag.getTagKind() != 7) {
            return null;
        }
        SimpleReference typeRef = null;
        SimpleReference variableRef = null;
        String value = tag.getValue();
        if (tag.getReferences().length != 2) {
            return null;
        }
        SimpleReference[] simpleReferenceArray = tag.getReferences();
        int n = simpleReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleReference reference = simpleReferenceArray[n2];
            if (reference instanceof TypeReference) {
                typeRef = reference;
            } else if (reference instanceof VariableReference) {
                variableRef = reference;
            }
            ++n2;
        }
        if (infoType == 3) {
            int variableRefIndex;
            int typeRefIndex = value.indexOf(typeRef.getName());
            int lastRefIndex = typeRefIndex > (variableRefIndex = value.indexOf(variableRef.getName())) ? typeRefIndex + typeRef.getName().length() : variableRefIndex + variableRef.getName().length();
            return value.substring(lastRefIndex).trim();
        }
        if (infoType == 1) {
            return typeRef.getName();
        }
        if (infoType == 2) {
            return variableRef.getName();
        }
        return null;
    }

    private static boolean appendBuiltinDoc(IMember element, StringBuffer buf) {
        String builtinDoc = BuiltinDoc.getString(element.getElementName());
        if (builtinDoc.length() > 0) {
            buf.append(builtinDoc);
            return true;
        }
        return false;
    }

    private void doWorkAround() {
        this.fBuf.append("&nbsp");
    }

    /* synthetic */ PHPDocumentationContentAccess(IMethod iMethod, PHPDocBlock pHPDocBlock, JavadocLookup javadocLookup, PHPDocumentationContentAccess pHPDocumentationContentAccess) {
        this(iMethod, pHPDocBlock, javadocLookup);
    }

    private static abstract class InheritDocVisitor {
        public static final Object STOP_BRANCH = new Object(){

            public String toString() {
                return "STOP_BRANCH";
            }
        };
        public static final Object CONTINUE = new Object(){

            public String toString() {
                return "CONTINUE";
            }
        };

        private InheritDocVisitor() {
        }

        public abstract Object visit(IType var1) throws ModelException;

        public Object visitInheritDoc(IType currentType, ITypeHierarchy typeHierarchy) throws ModelException {
            IType[] superClasses;
            ArrayList<IType> visited = new ArrayList<IType>();
            visited.add(currentType);
            IType[] iTypeArray = superClasses = typeHierarchy.getSuperclass(currentType);
            int n = superClasses.length;
            int n2 = 0;
            while (n2 < n) {
                IType superClass = iTypeArray[n2];
                while (superClass != null && !visited.contains(superClass)) {
                    Object result = this.visit(superClass);
                    if (result == STOP_BRANCH) {
                        return null;
                    }
                    if (result == CONTINUE) {
                        visited.add(superClass);
                        result = this.visitInheritDocInterfaces(visited, superClass, typeHierarchy);
                        if (result != CONTINUE) {
                            return result;
                        }
                        superClasses = typeHierarchy.getSuperclass(superClass);
                        continue;
                    }
                    return result;
                }
                ++n2;
            }
            return null;
        }

        private Object visitInheritDocInterfaces(ArrayList visited, IType currentType, ITypeHierarchy typeHierarchy) throws ModelException {
            Object result;
            ArrayList<IType> toVisitChildren = new ArrayList<IType>();
            IType[] superInterfaces = typeHierarchy.getSuperclass(currentType);
            int i = 0;
            while (i < superInterfaces.length) {
                IType superInterface = superInterfaces[i];
                if (!visited.contains(superInterface)) {
                    visited.add(superInterface);
                    result = this.visit(superInterface);
                    if (result != STOP_BRANCH) {
                        if (result == CONTINUE) {
                            toVisitChildren.add(superInterface);
                        } else {
                            return result;
                        }
                    }
                }
                ++i;
            }
            for (IType child : toVisitChildren) {
                result = this.visitInheritDocInterfaces(visited, child, typeHierarchy);
                if (result == CONTINUE) continue;
                return result;
            }
            return CONTINUE;
        }
    }

    private static class JavadocLookup {
        private static final JavadocLookup NONE = new JavadocLookup(null){

            @Override
            public CharSequence getInheritedMainDescription(IMethod method) {
                return null;
            }

            @Override
            public CharSequence getInheritedParamDescription(IMethod method, int i) {
                return null;
            }

            @Override
            public CharSequence getInheritedReturnDescription(IMethod method) {
                return null;
            }

            @Override
            public CharSequence getInheritedExceptionDescription(IMethod method, String name) {
                return null;
            }
        };
        private final IType fStartingType;
        private final HashMap fContentAccesses;
        private ITypeHierarchy fTypeHierarchy;
        private MethodOverrideTester fOverrideTester;

        private JavadocLookup(IType startingType) {
            this.fStartingType = startingType;
            this.fContentAccesses = new HashMap();
        }

        public CharSequence getInheritedMainDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(PHPDocumentationContentAccess contentAccess) {
                    return contentAccess.getMainDescription();
                }
            });
        }

        public CharSequence getInheritedParamDescription(IMethod method, final int paramIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(PHPDocumentationContentAccess contentAccess) throws ModelException {
                    return contentAccess.getInheritedParamDescription(paramIndex);
                }
            });
        }

        public CharSequence getInheritedParamType(IMethod method, final int paramIndex) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(PHPDocumentationContentAccess contentAccess) throws ModelException {
                    return contentAccess.getInheritedParamType(paramIndex);
                }
            });
        }

        public CharSequence getInheritedReturnDescription(IMethod method) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(PHPDocumentationContentAccess contentAccess) {
                    return contentAccess.getReturnDescription();
                }
            });
        }

        public CharSequence getInheritedExceptionDescription(IMethod method, final String simpleName) {
            return this.getInheritedDescription(method, new DescriptionGetter(){

                @Override
                public CharSequence getDescription(PHPDocumentationContentAccess contentAccess) {
                    return contentAccess.getExceptionDescription(simpleName);
                }
            });
        }

        private CharSequence getInheritedDescription(final IMethod method, final DescriptionGetter descriptionGetter) {
            try {
                return (CharSequence)new InheritDocVisitor(){

                    @Override
                    public Object visit(IType currType) throws ModelException {
                        IMethod overridden = JavadocLookup.this.getOverrideTester().findOverriddenMethodInType(currType, method);
                        if (overridden == null) {
                            return InheritDocVisitor.CONTINUE;
                        }
                        PHPDocumentationContentAccess contentAccess = JavadocLookup.this.getJavadocContentAccess(overridden);
                        if (contentAccess == null) {
                            return InheritDocVisitor.CONTINUE;
                        }
                        CharSequence overriddenDescription = descriptionGetter.getDescription(contentAccess);
                        if (overriddenDescription != null) {
                            return overriddenDescription;
                        }
                        return InheritDocVisitor.CONTINUE;
                    }
                }.visitInheritDoc(method.getDeclaringType(), this.getTypeHierarchy());
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
                return null;
            }
        }

        private PHPDocumentationContentAccess getJavadocContentAccess(IMethod method) throws ModelException {
            Object cached = this.fContentAccesses.get(method);
            if (cached != null) {
                return (PHPDocumentationContentAccess)cached;
            }
            if (this.fContentAccesses.containsKey(method)) {
                return null;
            }
            PHPDocBlock javadoc = PHPModelUtils.getDocBlock((IMethod)method);
            if (javadoc == null) {
                this.fContentAccesses.put(method, null);
                return null;
            }
            PHPDocumentationContentAccess contentAccess = new PHPDocumentationContentAccess(method, javadoc, this, null);
            this.fContentAccesses.put(method, contentAccess);
            return contentAccess;
        }

        private ITypeHierarchy getTypeHierarchy() throws ModelException {
            if (this.fTypeHierarchy == null) {
                this.fTypeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy(this.fStartingType);
            }
            return this.fTypeHierarchy;
        }

        private MethodOverrideTester getOverrideTester() throws ModelException {
            if (this.fOverrideTester == null) {
                this.fOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester(this.fStartingType);
            }
            return this.fOverrideTester;
        }

        /* synthetic */ JavadocLookup(IType iType, JavadocLookup javadocLookup, JavadocLookup javadocLookup2) {
            this(iType);
        }

        private static interface DescriptionGetter {
            public CharSequence getDescription(PHPDocumentationContentAccess var1) throws ModelException;
        }
    }
}

