/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextLineBreakingReader;

public class PHPStructuredTextAnnotationHover
extends StructuredTextAnnotationHover {
    private HTMLPrinter printer = new HTMLPrinter();

    private int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int markerLine;
            block5: {
                try {
                    markerLine = document.getLineOfOffset(position.getOffset());
                    if (line != markerLine) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (markerLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    private String formatHoverText(String text, ISourceViewer sourceViewer) {
        String result = null;
        String lineDelim = new String();
        try {
            lineDelim = sourceViewer.getDocument().getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        Display display = sourceViewer.getTextWidget().getDisplay();
        text = StringUtils.convertToHTMLContent((String)text);
        StringReader textReader = new StringReader(text);
        GC gc = new GC((Drawable)display);
        try {
            try {
                StringBuffer buf = new StringBuffer();
                StructuredTextLineBreakingReader reader = new StructuredTextLineBreakingReader((Reader)textReader, gc, this.getHoverWidth(display));
                String line = reader.readLine();
                while (line != null) {
                    if (buf.length() != 0) {
                        buf.append(lineDelim);
                    }
                    buf.append(line);
                    line = reader.readLine();
                }
                result = buf.toString();
            }
            catch (IOException exception) {
                Logger.logException((Throwable)exception);
                gc.dispose();
            }
        }
        finally {
            gc.dispose();
        }
        return result;
    }

    private String formatMultipleHoverText(List<String> messages) {
        StringBuffer buffer = new StringBuffer();
        this.printer.addPageProlog(buffer);
        this.printer.addParagraph(buffer, SSEUIMessages.Multiple_errors);
        this.printer.startBulletList(buffer);
        Iterator<String> e = messages.iterator();
        while (e.hasNext()) {
            this.printer.addBullet(buffer, this.printer.convertToHTMLContent(e.next()));
        }
        this.printer.endBulletList(buffer);
        this.printer.addPageEpilog(buffer);
        return buffer.toString();
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List<String> messages = this.dropDuplicateMessages(this.getMarkerMessages(sourceViewer, lineNumber));
        List<ITemporaryAnnotation> temporaryAnnotations = this.getTemporaryAnnotationsForLine(sourceViewer, lineNumber);
        int i = 0;
        while (i < temporaryAnnotations.size()) {
            String message = ((Annotation)temporaryAnnotations.get(i)).getText();
            if (message != null) {
                boolean duplicated = false;
                int j = 0;
                while (j < messages.size()) {
                    duplicated = duplicated || messages.get(j).equals(message);
                    ++j;
                }
                if (!duplicated) {
                    messages.add(message);
                }
            } else {
                messages.add(temporaryAnnotations.get(i).toString());
            }
            ++i;
        }
        if (messages.size() > 1) {
            return this.formatMultipleHoverText(messages);
        }
        if (messages.size() > 0) {
            return this.formatHoverText(messages.get(0).toString(), sourceViewer);
        }
        return null;
    }

    private List<String> dropDuplicateMessages(List<String> messages) {
        HashSet<String> rt = new HashSet<String>();
        for (String message : messages) {
            if (rt.contains(message)) continue;
            rt.add(message);
        }
        return new ArrayList<String>(rt);
    }

    private int getHoverWidth(Display display) {
        Rectangle displayBounds = display.getBounds();
        int hoverWidth = displayBounds.width - (display.getCursorLocation().x - displayBounds.x);
        if ((hoverWidth -= 12) < 200) {
            hoverWidth = 200;
        }
        return hoverWidth;
    }

    private List<String> getMarkerMessages(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = this.getAnnotationModel(viewer);
        ArrayList<String> messages = new ArrayList<String>();
        if (model == null) {
            return messages;
        }
        HashMap messagesAtPosition = new HashMap();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Annotation a;
            Object o = e.next();
            if (!(o instanceof Annotation) || this.compareRulerLine(model.getPosition(a = (Annotation)o), document, line) != 1) continue;
            if (a instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)a;
                for (Annotation annotation : bag) {
                    this.addText(model, annotation, messages, messagesAtPosition);
                }
                continue;
            }
            this.addText(model, a, messages, messagesAtPosition);
        }
        return messages;
    }

    private void addText(IAnnotationModel model, Annotation annotation, List<String> messages, HashMap messagesAtPosition) {
        String text;
        Position position = model.getPosition(annotation);
        if (position != null && this.includeAnnotation(annotation, position, messagesAtPosition) && (text = this.getText(annotation)) != null) {
            messages.add(text);
        }
    }

    private String getText(Annotation a) {
        String text = null;
        if (a instanceof MarkerAnnotation) {
            IMarker marker = ((MarkerAnnotation)a).getMarker();
            text = marker.getAttribute("message", null);
        } else {
            text = a.getText();
        }
        return text;
    }

    private List<ITemporaryAnnotation> getTemporaryAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<ITemporaryAnnotation> annotations = new ArrayList<ITemporaryAnnotation>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            ITemporaryAnnotation a;
            Position position;
            Object o = e.next();
            if (!(o instanceof ITemporaryAnnotation) || (position = model.getPosition((Annotation)(a = (ITemporaryAnnotation)o))) == null || this.compareRulerLine(position, document, line) != 1) continue;
            annotations.add(a);
        }
        return annotations;
    }

    private boolean includeAnnotation(Annotation annotation, Position position, HashMap messagesAtPosition) {
        if (!this.isIncluded(annotation)) {
            return false;
        }
        String text = annotation.getText();
        return text != null && !this.isDuplicateAnnotation(messagesAtPosition, position, text);
    }

    private boolean isDuplicateAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    class HTMLPrinter {
        HTMLPrinter() {
        }

        void addBullet(StringBuffer buffer, String bullet) {
            if (bullet != null) {
                buffer.append("<li>");
                buffer.append(bullet);
                buffer.append("</li>");
            }
        }

        void addPageEpilog(StringBuffer buffer) {
            buffer.append("</font></body></html>");
        }

        void addPageProlog(StringBuffer buffer) {
            this.insertPageProlog(buffer, buffer.length());
        }

        void addParagraph(StringBuffer buffer, Reader paragraphReader) {
            if (paragraphReader != null) {
                this.addParagraph(buffer, this.read(paragraphReader));
            }
        }

        void addParagraph(StringBuffer buffer, String paragraph) {
            if (paragraph != null) {
                buffer.append("<p>");
                buffer.append(paragraph);
            }
        }

        void addSmallHeader(StringBuffer buffer, String header) {
            if (header != null) {
                buffer.append("<h5>");
                buffer.append(header);
                buffer.append("</h5>");
            }
        }

        String convertToHTMLContent(String content) {
            content = this.replace(content, '<', "&lt;");
            return this.replace(content, '>', "&gt;");
        }

        void endBulletList(StringBuffer buffer) {
            buffer.append("</ul>");
        }

        void insertPageProlog(StringBuffer buffer, int position) {
            buffer.insert(position, "<html><body text=\"#000000\" bgcolor=\"#FFFF88\"><font size=-1>");
        }

        String read(Reader rd) {
            StringBuffer buffer = new StringBuffer();
            char[] readBuffer = new char[2048];
            try {
                int n = rd.read(readBuffer);
                while (n > 0) {
                    buffer.append(readBuffer, 0, n);
                    n = rd.read(readBuffer);
                }
                return buffer.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private String replace(String text, char c, String s) {
            int previous = 0;
            int current = text.indexOf(c, previous);
            if (current == -1) {
                return text;
            }
            StringBuffer buffer = new StringBuffer();
            while (current > -1) {
                buffer.append(text.substring(previous, current));
                buffer.append(s);
                previous = current + 1;
                current = text.indexOf(c, previous);
            }
            buffer.append(text.substring(previous));
            return buffer.toString();
        }

        void startBulletList(StringBuffer buffer) {
            buffer.append("<ul>");
        }
    }
}

