/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.language.PHPVariables;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class SuperGlobalHighlighting
extends AbstractSemanticHighlighting {
    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new SuperGlobalApply();
    }

    @Override
    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setDefaultTextColor(127, 0, 85).setBoldByDefault(true);
    }

    public String getDisplayName() {
        return Messages.SuperGlobalHighlighting_0;
    }

    protected class SuperGlobalApply
    extends AbstractSemanticApply {
        protected SuperGlobalApply() {
        }

        public boolean visit(ArrayAccess n) {
            if (this.isSuperGlobal(n.getName())) {
                SuperGlobalHighlighting.this.highlight((ASTNode)n.getName());
            }
            return true;
        }

        private boolean isSuperGlobal(VariableBase n) {
            if (n instanceof Variable && ((Variable)n).getName() instanceof Identifier) {
                String[] globals;
                String name = "$" + ((Identifier)((Variable)n).getName()).getName();
                String[] stringArray = globals = PHPVariables.getVariables((PHPVersion)PHPVersion.PHP5_3);
                int n2 = globals.length;
                int n3 = 0;
                while (n3 < n2) {
                    String global = stringArray[n3];
                    if (global.equals(name)) {
                        return true;
                    }
                    ++n3;
                }
            }
            return false;
        }
    }
}

