/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetFilter;

public class PHPWorkingSetFilter
extends WorkingSetFilter {
    private IAdaptable[] fCachedWorkingSet = null;

    public boolean isEnclosing(IModelElement element) {
        IResource resource;
        Assert.isNotNull((Object)element);
        IAdaptable[] cachedWorkingSet = this.fCachedWorkingSet;
        if (cachedWorkingSet == null) {
            cachedWorkingSet = this.getWorkingSet().getElements();
        }
        if ((resource = (IResource)element.getAdapter(IResource.class)) == null) {
            return false;
        }
        IPath path = resource.getFullPath();
        int i = 0;
        while (i < cachedWorkingSet.length) {
            if (this.isEnclosing(cachedWorkingSet[i], path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isEnclosing(IAdaptable element, IPath path) {
        IModelElement scriptElement;
        if (path == null) {
            return false;
        }
        IPath elementPath = null;
        IResource elementResource = (IResource)element.getAdapter(IResource.class);
        if (elementResource != null) {
            elementPath = elementResource.getFullPath();
        }
        if (elementPath == null && (scriptElement = (IModelElement)element.getAdapter(IModelElement.class)) != null) {
            elementPath = scriptElement.getPath();
        }
        if (elementPath == null && element instanceof IStorage) {
            elementPath = ((IStorage)element).getFullPath();
        }
        if (elementPath == null) {
            return false;
        }
        if (elementPath.isPrefixOf(path)) {
            return true;
        }
        return path.isPrefixOf(elementPath);
    }
}

