/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChainingInstanceCall;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ClassInstanceCreation
extends VariableBase {
    private ClassName className;
    private ASTNode.NodeList<Expression> ctorParams = new ASTNode.NodeList(CTOR_PARAMS_PROPERTY);
    private ChainingInstanceCall chainingInstanceCall;
    public static final ChildPropertyDescriptor CLASSNAME_PROPERTY = new ChildPropertyDescriptor(ClassInstanceCreation.class, "className", ClassName.class, true, true);
    public static final ChildListPropertyDescriptor CTOR_PARAMS_PROPERTY = new ChildListPropertyDescriptor(ClassInstanceCreation.class, "ctorParams", Expression.class, true);
    public static final ChildPropertyDescriptor CHAINING_INSTANCE_CALL_PROPERTY = new ChildPropertyDescriptor(ClassInstanceCreation.class, "className", ClassName.class, false, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(2);
        propertyList.add(CLASSNAME_PROPERTY);
        propertyList.add(CTOR_PARAMS_PROPERTY);
        propertyList.add(CHAINING_INSTANCE_CALL_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public ClassInstanceCreation(int start, int end, AST ast, ClassName className, Expression[] ctorParams) {
        super(start, end, ast);
        if (className == null || ctorParams == null) {
            throw new IllegalArgumentException();
        }
        this.setClassName(className);
        Expression[] expressionArray = ctorParams;
        int n = ctorParams.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            this.ctorParams.add(expression);
            ++n2;
        }
    }

    public ClassInstanceCreation(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    public ClassInstanceCreation(int start, int end, AST ast, ClassName className, List ctorParams) {
        this(start, end, ast, className, ctorParams == null ? null : ctorParams.toArray(new Expression[ctorParams.size()]));
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.className.accept(visitor);
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.className.traverseTopDown(visitor);
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.className.traverseBottomUp(visitor);
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<ClassInstanceCreation");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.className.toString(buffer, "\t" + tab);
        buffer.append("\n").append("\t").append(tab).append("<ConstructorParameters>\n");
        for (ASTNode aSTNode : this.ctorParams) {
            aSTNode.toString(buffer, "\t\t" + tab);
            buffer.append("\n");
        }
        buffer.append("\t").append(tab).append("</ConstructorParameters>\n");
        buffer.append(tab).append("</ClassInstanceCreation>");
    }

    @Override
    public int getType() {
        return 13;
    }

    public ClassName getClassName() {
        return this.className;
    }

    public void setClassName(ClassName classname) {
        if (classname == null) {
            throw new IllegalArgumentException();
        }
        ClassName oldChild = this.className;
        this.preReplaceChild(oldChild, classname, CLASSNAME_PROPERTY);
        this.className = classname;
        this.postReplaceChild(oldChild, classname, CLASSNAME_PROPERTY);
    }

    public ChainingInstanceCall getChainingInstanceCall() {
        return this.chainingInstanceCall;
    }

    public void setChainingInstanceCall(ChainingInstanceCall chainingInstanceCall) {
        this.chainingInstanceCall = chainingInstanceCall;
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == CLASSNAME_PROPERTY) {
            if (get) {
                return this.getClassName();
            }
            this.setClassName((ClassName)child);
            return null;
        }
        if (property == CHAINING_INSTANCE_CALL_PROPERTY) {
            if (get) {
                return this.getChainingInstanceCall();
            }
            this.setChainingInstanceCall((ChainingInstanceCall)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    public List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == CTOR_PARAMS_PROPERTY) {
            return this.ctorParams();
        }
        return super.internalGetChildListProperty(property);
    }

    public Expression[] getCtorParams() {
        return this.ctorParams.toArray((Expression[])new Expression[this.ctorParams.size()]);
    }

    public List<Expression> ctorParams() {
        return this.ctorParams;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List params = ASTNode.copySubtrees(target, this.ctorParams());
        ClassName cn = ASTNode.copySubtree(target, this.getClassName());
        ClassInstanceCreation result = new ClassInstanceCreation(this.getStart(), this.getEnd(), target, cn, params);
        return result;
    }

    public ClassInstanceCreation cloneWithNewStart(int offset) {
        AST target = this.getAST();
        List params = ASTNode.copySubtrees(target, this.ctorParams());
        ClassName cn = ASTNode.copySubtree(target, this.getClassName());
        ClassInstanceCreation result = new ClassInstanceCreation(offset, this.getEnd(), target, cn, params);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    public IMethodBinding resolveConstructorBinding() {
        return this.ast.getBindingResolver().resolveConstructor(this);
    }
}

