/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class FunctionName
extends ASTNode {
    private Expression name;
    public static final ChildPropertyDescriptor NAME_PROPERTY = new ChildPropertyDescriptor(FunctionName.class, "functionName", Expression.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(1);
        propertyList.add(NAME_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public FunctionName(int start, int end, AST ast, Expression functionName) {
        super(start, end, ast);
        if (functionName == null) {
            throw new IllegalArgumentException();
        }
        this.setName(functionName);
    }

    public FunctionName(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.name.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.name.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.name.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionName");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.name.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</FunctionName>");
    }

    @Override
    public int getType() {
        return 31;
    }

    public Expression getName() {
        return this.name;
    }

    public Expression getFunctionName() {
        return this.name;
    }

    public void setName(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.name;
        this.preReplaceChild(oldChild, expression, NAME_PROPERTY);
        this.name = expression;
        this.postReplaceChild(oldChild, expression, NAME_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == NAME_PROPERTY) {
            if (get) {
                return this.getName();
            }
            this.setName((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Expression expr = ASTNode.copySubtree(target, this.getName());
        FunctionName result = new FunctionName(this.getStart(), this.getEnd(), target, expr);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

