/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class AbstractPHPDocTagStartContext
extends PHPDocTagContext {
    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        String tagName = this.getTagName();
        if (!this.getTags().contains(tagName)) {
            return false;
        }
        TextSequence statementText = this.getStatementText();
        String statementTextString = statementText.toString();
        StringTokenizer st = new StringTokenizer(statementTextString);
        Stack<String> stack = new Stack<String>();
        while (st.hasMoreElements()) {
            stack.add((String)st.nextElement());
        }
        if (!stack.empty()) {
            String lastWord = (String)stack.pop();
            if (lastWord.startsWith("@")) {
                lastWord = lastWord.substring(1);
            }
            if (!statementTextString.endsWith(lastWord)) {
                return this.getTags().contains(lastWord);
            }
            if (!stack.empty() && this.isPrefix(lastWord)) {
                lastWord = (String)stack.pop();
                return lastWord.endsWith(tagName);
            }
        }
        return false;
    }

    protected abstract List<String> getTags();

    private boolean isPrefix(String lastWord) {
        try {
            return this.getPrefix().endsWith(lastWord);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

