/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class GlobalConstantsStrategy
extends GlobalElementStrategy {
    public GlobalConstantsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public GlobalConstantsStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        if (abstractContext.getPrefixWithoutProcessing().trim().length() == 0) {
            return;
        }
        String prefix = abstractContext.getPrefix();
        if (prefix.startsWith("$")) {
            return;
        }
        ISearchEngine.MatchRule matchRule = ISearchEngine.MatchRule.PREFIX;
        if (requestor.isContextInformationMode()) {
            matchRule = ISearchEngine.MatchRule.EXACT;
        }
        ISourceModule sourceModule = abstractContext.getSourceModule();
        IType enclosingType = null;
        try {
            IModelElement enclosingElement = sourceModule.getElementAt(abstractContext.getOffset());
            if (enclosingElement != null && enclosingElement instanceof IType) {
                enclosingType = (IType)enclosingElement;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        IDLTKSearchScope scope = null;
        IField[] enclosingTypeConstants = null;
        scope = enclosingType != null && this.isStartOfStatement(prefix, abstractContext, abstractContext.getOffset()) ? SearchEngine.createSearchScope((IModelElement)enclosingType) : this.getSearchScope(abstractContext);
        enclosingTypeConstants = PhpModelAccess.getDefault().findFields(prefix, matchRule, 2, 0, scope, null);
        if (this.isCaseSensitive()) {
            enclosingTypeConstants = this.filterByCase((IModelElement[])enclosingTypeConstants, prefix);
        }
        enclosingTypeConstants = this.filterClassConstants((IModelElement[])enclosingTypeConstants);
        SourceRange replaceRange = this.getReplacementRange(abstractContext);
        IField[] iFieldArray = enclosingTypeConstants;
        int n = enclosingTypeConstants.length;
        int n2 = 0;
        while (n2 < n) {
            IField constant = iFieldArray[n2];
            reporter.reportField(constant, "", replaceRange, false);
            ++n2;
        }
    }

    private boolean isStartOfStatement(String prefix, AbstractCompletionContext abstractContext, int offset) {
        IStructuredDocument doc = abstractContext.getDocument();
        try {
            int pos = offset - prefix.length() - 1;
            char previousChar = doc.getChar(pos);
            while (Character.isWhitespace(previousChar)) {
                previousChar = doc.getChar(--pos);
            }
            return previousChar == '{' || previousChar == ';';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private IModelElement[] filterClassConstants(IModelElement[] elements) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>(elements.length);
        IModelElement[] iModelElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            try {
                if ((((IField)element).getFlags() & 0x400) == 0) {
                    result.add(element);
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    private IDLTKSearchScope getSearchScope(AbstractCompletionContext abstractContext) {
        IDLTKSearchScope scope = this.createSearchScope();
        return scope;
    }
}

