/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class DeclareStatement
extends Statement {
    private final List<String> directiveNames;
    private final List<? extends Expression> directiveValues;
    private final Statement action;

    public DeclareStatement(int start, int end, List<String> directiveNames, List<? extends Expression> directiveValues, Statement action) {
        super(start, end);
        assert (directiveNames != null && directiveValues != null && directiveNames.size() == directiveValues.size());
        this.directiveNames = directiveNames;
        this.directiveValues = directiveValues;
        this.action = action;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Statement)this);
        if (visit) {
            for (Expression expression : this.directiveValues) {
                expression.traverse(visitor);
            }
            this.action.traverse(visitor);
        }
        visitor.endvisit((Statement)this);
    }

    public int getKind() {
        return 19;
    }

    public Statement getAction() {
        return this.action;
    }

    public Collection<String> getDirectiveNames() {
        return this.directiveNames;
    }

    public Collection<? extends Expression> getDirectiveValues() {
        return this.directiveValues;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

