/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.compiler.ast.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.nodes.TraitStatement;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class TraitUseStatement
extends Statement {
    private List<TypeReference> traitList;
    private List<TraitStatement> tsList;

    public TraitUseStatement(int start, int end, List<TypeReference> traitList, List<TraitStatement> tsList) {
        super(start, end);
        assert (traitList != null);
        assert (tsList != null);
        this.traitList = traitList;
        this.tsList = tsList;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.traitList != null) {
                for (TypeReference typeReference : this.traitList) {
                    typeReference.traverse(visitor);
                }
            }
            if (this.tsList != null) {
                for (TraitStatement traitStatement : this.tsList) {
                    traitStatement.traverse(visitor);
                }
            }
            visitor.endvisit((Statement)this);
        }
    }

    public List<TypeReference> getTraitList() {
        return this.traitList;
    }

    public void setTraitList(List<TypeReference> traitList) {
        this.traitList = traitList;
    }

    public List<TraitStatement> getTsList() {
        if (this.tsList == null) {
            this.tsList = new ArrayList<TraitStatement>();
        }
        return this.tsList;
    }

    public void setTsList(List<TraitStatement> tsList) {
        this.tsList = tsList;
    }

    public int getKind() {
        return 70;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

