/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.IFormatterCommonPrferences;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class FormatterUtils {
    private static final String FORMATTER_COMMON_PREFERENCE_EXT = "org.eclipse.php.core.phpFormatterCommonPreferences";
    private static PHPStructuredTextPartitioner partitioner = new PHPStructuredTextPartitioner();
    private static IFormatterCommonPrferences usedFormatter;
    private static StringBuffer helpBuffer;

    static {
        helpBuffer = new StringBuffer(50);
    }

    public static String getRegionType(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion;
        block8: {
            try {
                sdRegion = document.getRegionAtCharacterOffset(offset);
                if (sdRegion != null) break block8;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        if (tRegion != null && tRegion.getType().equals("PHP_CLOSE")) {
            tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
        }
        if (tRegion != null) {
            int regionStart = sdRegion.getStartOffset(tRegion);
            if (tRegion != null && tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += tRegion.getStart();
            }
            if (tRegion != null && tRegion instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                int regionOffset = offset - regionStart;
                ITextRegion innerRegion = scriptRegion.getPhpToken(regionOffset);
                return innerRegion.getType();
            }
        }
        return null;
    }

    public static String getPartitionType(IStructuredDocument document, int offset, boolean perferOpenPartitions) {
        block10: {
            String partition;
            block11: {
                IStructuredDocumentRegion sdRegion;
                block9: {
                    try {
                        sdRegion = document.getRegionAtCharacterOffset(offset);
                        if (sdRegion != null) break block9;
                        return null;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
                if (tRegion == null && offset == document.getLength()) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
                }
                if (tRegion != null && tRegion.getType().equals("PHP_CLOSE")) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                }
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion != null && tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(offset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion == null || !(tRegion instanceof IPhpScriptRegion)) break block10;
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                int regionOffset = offset - regionStart;
                ITextRegion innerRegion = scriptRegion.getPhpToken(regionOffset);
                partition = scriptRegion.getPartition(regionOffset);
                if (offset - (sdRegion.getStart() + regionStart + innerRegion.getStart()) != 0) break block11;
                String regionType = innerRegion.getType();
                if (PHPPartitionTypes.isPHPDocCommentState(regionType) || regionType != "PHPDOC_COMMENT_START") {
                    return partition;
                }
                if (PHPPartitionTypes.isPHPMultiLineCommentState(regionType) || regionType != "PHP_COMMENT_START") {
                    return partition;
                }
                return "org.eclipse.php.PHP_DEFAULT";
            }
            return partition;
        }
        partitioner.connect((IDocument)document);
        return partitioner.getContentType(offset, perferOpenPartitions);
    }

    public static String getPartitionType(IStructuredDocument document, int offset) {
        return FormatterUtils.getPartitionType(document, offset, false);
    }

    public static String getLineBlanks(IDocument document, IRegion lineInfo) throws BadLocationException {
        helpBuffer.setLength(0);
        int startOffset = lineInfo.getOffset();
        int length = lineInfo.getLength();
        char[] line = document.get(startOffset, length).toCharArray();
        int i = 0;
        while (i < line.length) {
            char c = line[i];
            if (!Character.isWhitespace(c)) break;
            helpBuffer.append(c);
            ++i;
        }
        return helpBuffer.toString();
    }

    public static IStructuredDocumentRegion getLastPhpStructuredDocumentRegion(IStructuredDocumentRegion currentStructuredDocumentRegion) {
        assert (currentStructuredDocumentRegion != null);
        currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        while (currentStructuredDocumentRegion != null && currentStructuredDocumentRegion.getType() != "PHP_CONTENT") {
            currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        }
        return currentStructuredDocumentRegion;
    }

    public static IFormatterCommonPrferences getFormatterCommonPrferences() {
        if (usedFormatter == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(FORMATTER_COMMON_PREFERENCE_EXT);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals("processor")) {
                    try {
                        usedFormatter = (IFormatterCommonPrferences)element.createExecutableExtension("class");
                    }
                    catch (CoreException coreException) {}
                }
                ++i;
            }
            if (usedFormatter == null) {
                usedFormatter = FormatPreferencesSupport.getInstance();
            }
        }
        return usedFormatter;
    }
}

