/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.php.internal.core.search.BreakContinueTargetFinder;
import org.eclipse.php.internal.core.search.ClassMembersOccurrencesFinder;
import org.eclipse.php.internal.core.search.ClassNameOccurrencesFinder;
import org.eclipse.php.internal.core.search.ConstantsOccurrencesFinder;
import org.eclipse.php.internal.core.search.FunctionOccurrencesFinder;
import org.eclipse.php.internal.core.search.GlobalVariableOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.ImplementOccurrencesFinder;
import org.eclipse.php.internal.core.search.IncludeOccurrencesFinder;
import org.eclipse.php.internal.core.search.LocalVariableOccurrencesFinder;
import org.eclipse.php.internal.core.search.MethodExitsFinder;
import org.eclipse.php.internal.core.search.TraitNameOccurrencesFinder;

public class OccurrencesFinderFactory {
    public static IOccurrencesFinder getOccurrencesFinder(int type) {
        switch (type) {
            case 3: {
                return new LocalVariableOccurrencesFinder();
            }
            case 1: {
                return new GlobalVariableOccurrencesFinder();
            }
            case 2: {
                return new FunctionOccurrencesFinder();
            }
            case 5: {
                return new ConstantsOccurrencesFinder();
            }
            case 4: {
                return new ClassNameOccurrencesFinder();
            }
            case 8: {
                return new TraitNameOccurrencesFinder();
            }
            case 6: {
                return new ClassMembersOccurrencesFinder();
            }
        }
        return null;
    }

    public static IOccurrencesFinder createMethodExitsFinder() {
        return new MethodExitsFinder();
    }

    public static IOccurrencesFinder createBreakContinueTargetFinder() {
        return new BreakContinueTargetFinder();
    }

    public static IOccurrencesFinder createImplementorsOccurrencesFinder() {
        return new ImplementOccurrencesFinder();
    }

    public static IOccurrencesFinder createIncludeFinder() {
        return new IncludeOccurrencesFinder();
    }
}

