/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceField;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.compiler.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.internal.core.filenetwork.ReferenceTree;
import org.eclipse.php.internal.core.language.LanguageModelInitializer;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.DeclarationSearcher;
import org.eclipse.php.internal.core.typeinference.DefineMethodUtils;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;

public class CopyOfPHPModelUtils {
    public static String extractElementName(String element) {
        int i;
        if (element != null && (i = element.lastIndexOf(92)) != -1) {
            element = element.substring(i + 1).trim();
        }
        return element;
    }

    public static String extractNameSapceName(String element) {
        int i;
        String nameSpaceName = null;
        if (element != null && (i = element.lastIndexOf(92)) != -1) {
            nameSpaceName = element.substring(0, i).trim();
        }
        return nameSpaceName;
    }

    public static String getRealName(String elementName, ISourceModule sourceModule, int offset, String defaultClassName) {
        int nsIndex;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        UsePart usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, elementName, offset);
        if (usePart != null && (nsIndex = (elementName = usePart.getNamespace().getFullyQualifiedName()).lastIndexOf(92)) != -1) {
            defaultClassName = elementName.substring(nsIndex + 1);
        }
        return defaultClassName;
    }

    public static String extractNamespaceName(String elementName, ISourceModule sourceModule, int offset) {
        int nsIndex;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        UsePart usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, elementName, offset);
        if (usePart != null && (elementName = usePart.getNamespace().getFullyQualifiedName()).charAt(0) != '\\') {
            elementName = String.valueOf('\\') + elementName;
        }
        boolean isGlobal = false;
        if (elementName.charAt(0) == '\\') {
            isGlobal = true;
        }
        if ((nsIndex = elementName.lastIndexOf(92)) != -1) {
            String namespace = elementName.substring(0, nsIndex);
            if (isGlobal && namespace.length() > 0) {
                namespace = namespace.substring(1);
            }
            if (!isGlobal) {
                IType currentNamespace;
                if ("namespace".equalsIgnoreCase(namespace)) {
                    IType currentNamespace2 = CopyOfPHPModelUtils.getCurrentNamespace(sourceModule, offset);
                    return currentNamespace2.getElementName();
                }
                if (namespace.indexOf(92) == -1) {
                    usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, namespace, offset);
                    if (usePart != null) {
                        return usePart.getNamespace().getFullyQualifiedName();
                    }
                } else {
                    nsIndex = namespace.indexOf(92);
                    String alias = namespace.substring(0, nsIndex);
                    usePart = ASTUtils.findUseStatementByAlias(moduleDeclaration, alias, offset);
                    if (usePart != null) {
                        return String.valueOf(usePart.getNamespace().getFullyQualifiedName()) + '\\' + namespace.substring(nsIndex + 1);
                    }
                }
                if ((currentNamespace = CopyOfPHPModelUtils.getCurrentNamespace(sourceModule, offset)) != null) {
                    return currentNamespace.getElementName() + '\\' + namespace;
                }
            }
            return namespace;
        }
        return null;
    }

    public static <T extends IModelElement> Collection<T> fileNetworkFilter(ISourceModule sourceModule, Collection<T> elements, IModelAccessCache cache, IProgressMonitor monitor) {
        if (elements != null && elements.size() > 0) {
            LinkedList<T> filteredElements = new LinkedList<T>();
            for (IModelElement element : elements) {
                if (!sourceModule.equals(element.getOpenable())) continue;
                filteredElements.add(element);
            }
            if (filteredElements.size() == 0) {
                ReferenceTree referenceTree = cache != null ? cache.getFileHierarchy(sourceModule, monitor) : FileNetworkUtility.buildReferencedFilesTree(sourceModule, monitor);
                for (IModelElement element : elements) {
                    if (!LanguageModelInitializer.isLanguageModelElement(element) && !referenceTree.find(((ModelElement)element).getSourceModule())) continue;
                    filteredElements.add(element);
                }
            }
            if (filteredElements.size() > 0) {
                elements = filteredElements;
            }
        }
        return elements;
    }

    private static <T extends IModelElement> boolean canUseFileNetworkFilter(Collection<T> elements) {
        int elementType = 0;
        String elementName = null;
        for (IModelElement element : elements) {
            if (elementName == null) {
                elementType = element.getElementType();
                elementName = element.getElementName();
                continue;
            }
            if (elementName.equalsIgnoreCase(element.getElementName()) && elementType == element.getElementType()) continue;
            return false;
        }
        return true;
    }

    public static <T extends IModelElement> Collection<T> filterElements(ISourceModule sourceModule, Collection<T> elements, IModelAccessCache cache, IProgressMonitor monitor) {
        if (elements == null) {
            return null;
        }
        if (CopyOfPHPModelUtils.canUseFileNetworkFilter(elements)) {
            return CopyOfPHPModelUtils.fileNetworkFilter(sourceModule, elements, cache, monitor);
        }
        return elements;
    }

    public static IMethod getCurrentMethod(ISourceModule sourceModule, int offset) {
        try {
            IModelElement currentMethod = sourceModule.getElementAt(offset);
            while (currentMethod != null) {
                if (currentMethod instanceof IMethod) {
                    return (IMethod)currentMethod;
                }
                if (currentMethod instanceof IField) {
                    currentMethod = currentMethod.getParent();
                    continue;
                }
                break;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespace(IModelElement element) {
        try {
            IModelElement currentNs = element;
            while (currentNs != null) {
                if (currentNs instanceof IType && PHPFlags.isNamespace(((IType)currentNs).getFlags())) {
                    return (IType)currentNs;
                }
                currentNs = currentNs.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentNamespace(ISourceModule sourceModule, int offset) {
        try {
            IModelElement currentNs = sourceModule.getElementAt(offset);
            while (currentNs instanceof IField) {
                currentNs = sourceModule.getElementAt(((IField)currentNs).getSourceRange().getOffset() - 1);
            }
            while (currentNs != null) {
                if (currentNs instanceof IType && PHPFlags.isNamespace(((IType)currentNs).getFlags())) {
                    return (IType)currentNs;
                }
                currentNs = currentNs.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentType(IModelElement element) {
        try {
            while (element != null) {
                if (element instanceof IType) {
                    if (!PHPFlags.isNamespace(((IType)element).getFlags())) {
                        return (IType)element;
                    }
                    break;
                }
                element = element.getParent();
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        return null;
    }

    public static IType getCurrentType(ISourceModule sourceModule, int offset) {
        try {
            return CopyOfPHPModelUtils.getCurrentType(sourceModule.getElementAt(offset));
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
            return null;
        }
    }

    public static PHPDocBlock getDocBlock(IField field) {
        block5: {
            if (field == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = field.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                ASTNode fieldDeclaration = CopyOfPHPModelUtils.getNodeByField(moduleDeclaration, field);
                if (fieldDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)fieldDeclaration).getPHPDoc();
                }
                if (fieldDeclaration == null) {
                    return DefineMethodUtils.getDefinePHPDocBlockByField(moduleDeclaration, field);
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block5;
                Logger.logException(e);
            }
        }
        return null;
    }

    public static PHPDocBlock getDocBlock(IMethod method) {
        block4: {
            if (method == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = method.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                MethodDeclaration methodDeclaration = CopyOfPHPModelUtils.getNodeByMethod(moduleDeclaration, method);
                if (methodDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)methodDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                Logger.logException(e);
            }
        }
        return null;
    }

    public static PHPDocBlock getDocBlock(IType type) {
        block4: {
            if (type == null) {
                return null;
            }
            try {
                ISourceModule sourceModule = type.getSourceModule();
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
                TypeDeclaration typeDeclaration = CopyOfPHPModelUtils.getNodeByClass(moduleDeclaration, type);
                if (typeDeclaration instanceof IPHPDocAwareDeclaration) {
                    return ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc();
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block4;
                Logger.logException(e);
            }
        }
        return null;
    }

    public static IField[] getFields(String fieldName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getFields(fieldName, sourceModule, offset, null, monitor);
    }

    public static IField[] getFields(String fieldName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (fieldName == null || fieldName.length() == 0) {
            return PhpModelAccess.NULL_FIELDS;
        }
        if (!fieldName.startsWith("$")) {
            String namespace = CopyOfPHPModelUtils.extractNamespaceName(fieldName, sourceModule, offset);
            fieldName = CopyOfPHPModelUtils.extractElementName(fieldName);
            if (namespace != null) {
                if (namespace.length() > 0) {
                    IField[] fields = CopyOfPHPModelUtils.getNamespaceField(namespace, fieldName, true, sourceModule, cache, monitor);
                    if (fields.length > 0) {
                        return fields;
                    }
                    return PhpModelAccess.NULL_FIELDS;
                }
            } else {
                IType currentNamespace = CopyOfPHPModelUtils.getCurrentNamespace(sourceModule, offset);
                if (currentNamespace != null) {
                    namespace = currentNamespace.getElementName();
                    IField[] fields = CopyOfPHPModelUtils.getNamespaceField(namespace, fieldName, true, sourceModule, cache, monitor);
                    if (fields.length > 0) {
                        return fields;
                    }
                    IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
                    fields = PhpModelAccess.getDefault().findFields(fieldName, ISearchEngine.MatchRule.EXACT, 8194, 0, scope, null);
                    Collection<IField> filteredElements = CopyOfPHPModelUtils.filterElements(sourceModule, Arrays.asList(fields), cache, monitor);
                    return filteredElements.toArray(new IField[filteredElements.size()]);
                }
            }
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IField[] fields = PhpModelAccess.getDefault().findFields(fieldName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
        Collection<IField> filteredElements = null;
        if (fields != null) {
            filteredElements = CopyOfPHPModelUtils.filterElements(sourceModule, Arrays.asList(fields), cache, monitor);
            return filteredElements.toArray(new IField[filteredElements.size()]);
        }
        return PhpModelAccess.NULL_FIELDS;
    }

    public static IMethod[] getFunctions(String functionName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getFunctions(functionName, sourceModule, offset, null, monitor);
    }

    public static IMethod[] getFunctions(String functionName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (functionName == null || functionName.length() == 0) {
            return PhpModelAccess.NULL_METHODS;
        }
        String namespace = CopyOfPHPModelUtils.extractNamespaceName(functionName, sourceModule, offset);
        functionName = CopyOfPHPModelUtils.extractElementName(functionName);
        if (namespace != null) {
            if (namespace.length() > 0) {
                IMethod[] functions = CopyOfPHPModelUtils.getNamespaceFunction(namespace, functionName, true, sourceModule, cache, monitor);
                if (functions.length > 0) {
                    return functions;
                }
                return PhpModelAccess.NULL_METHODS;
            }
        } else {
            IType currentNamespace = CopyOfPHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (currentNamespace != null) {
                namespace = currentNamespace.getElementName();
                IMethod[] functions = CopyOfPHPModelUtils.getNamespaceFunction(namespace, functionName, true, sourceModule, cache, monitor);
                if (functions.length > 0) {
                    return functions;
                }
                return CopyOfPHPModelUtils.getGlobalFunctions(sourceModule, functionName, cache, monitor);
            }
        }
        return CopyOfPHPModelUtils.getGlobalFunctions(sourceModule, functionName, cache, monitor);
    }

    private static IMethod[] getGlobalFunctions(ISourceModule sourceModule, String functionName, IModelAccessCache cache, IProgressMonitor monitor) {
        if (cache != null) {
            Collection<IMethod> functions = cache.getGlobalFunctions(sourceModule, functionName, monitor);
            if (functions == null) {
                return PhpModelAccess.NULL_METHODS;
            }
            return functions.toArray(new IMethod[functions.size()]);
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IMethod[] functions = PhpModelAccess.getDefault().findMethods(functionName, ISearchEngine.MatchRule.EXACT, 8192, 0, scope, null);
        Collection<IMethod> filteredElements = CopyOfPHPModelUtils.filterElements(sourceModule, Arrays.asList(functions), cache, monitor);
        return filteredElements.toArray(new IMethod[filteredElements.size()]);
    }

    public static IModelElement[] getMethodFields(final IMethod method, final String prefix, final boolean exactName, IProgressMonitor monitor) {
        final LinkedList<IField> elements = new LinkedList<IField>();
        final HashSet<String> processedVars = new HashSet<String>();
        try {
            CopyOfPHPModelUtils.getMethodFields(method, prefix, exactName, elements, processedVars);
            ModuleDeclaration rootNode = SourceParserUtil.getModuleDeclaration((ISourceModule)method.getSourceModule());
            MethodDeclaration methodDeclaration = CopyOfPHPModelUtils.getNodeByMethod(rootNode, method);
            if (methodDeclaration != null) {
                methodDeclaration.traverse(new ASTVisitor(){

                    public boolean visit(Statement s) throws Exception {
                        if (s instanceof GlobalStatement) {
                            GlobalStatement globalStatement = (GlobalStatement)s;
                            for (Expression expression : globalStatement.getVariables()) {
                                VariableReference varReference;
                                String varName;
                                if (!(expression instanceof VariableReference) || processedVars.contains(varName = (varReference = (VariableReference)expression).getName()) || (!exactName || !varName.equalsIgnoreCase(prefix)) && (exactName || !varName.toLowerCase().startsWith(prefix.toLowerCase()))) continue;
                                elements.add(new FakeField((ModelElement)method, varName, expression.sourceStart(), expression.sourceEnd() - expression.sourceStart()));
                                processedVars.add(varName);
                            }
                        }
                        return super.visit(s);
                    }
                });
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return elements.toArray(new IModelElement[elements.size()]);
    }

    public static void getMethodFields(IMethod method, String prefix, boolean exactName, List<IField> elements, Set<String> processedVars) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = method.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement child = iModelElementArray[n2];
            if (child.getElementType() == 8) {
                IField field;
                String elementName = child.getElementName();
                if ((exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) && !CopyOfPHPModelUtils.isSameFileExisiting(elements, field = (IField)child)) {
                    elements.add((IField)child);
                    processedVars.add(elementName);
                }
            }
            ++n2;
        }
        if (CopyOfPHPModelUtils.isNestedAnonymousMethod(method)) {
            CopyOfPHPModelUtils.getMethodFields((IMethod)method.getParent().getParent(), prefix, exactName, elements, processedVars);
        }
    }

    public static boolean isNestedAnonymousMethod(IMethod method) {
        return "__anonymous".equals(method.getElementName()) && method.getParent() instanceof IField && method.getParent().getParent() instanceof IMethod;
    }

    private static boolean isSameFileExisiting(List<IField> elements, IField field) {
        for (IField current : elements) {
            if (!CopyOfPHPModelUtils.isSameField(current, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSameField(IField current, IField field) {
        if (!(field instanceof SourceField)) {
            return false;
        }
        if (current == field) {
            return true;
        }
        return current.getElementName().equals(field.getElementName()) && current.getParent().equals(field.getParent());
    }

    public static IField[] getFileFields(ISourceModule sourceModule, String prefix, boolean exactName, IProgressMonitor monitor) {
        LinkedList<IField> elements = new LinkedList<IField>();
        try {
            IField[] sourceModuleFields;
            IField[] iFieldArray = sourceModuleFields = sourceModule.getFields();
            int n = sourceModuleFields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String elementName = field.getElementName();
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    elements.add(field);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            PHPCorePlugin.log(e);
        }
        return elements.toArray(new IField[elements.size()]);
    }

    public static IField[] getNamespaceField(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getNamespaceField(namespace, prefix, exactName, sourceModule, null, monitor);
    }

    public static IField[] getNamespaceField(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        IType[] namespaces = CopyOfPHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeField(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] getNamespaceFunction(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getNamespaceFunction(namespace, prefix, exactName, sourceModule, null, monitor);
    }

    public static IMethod[] getNamespaceFunction(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        IType[] namespaces = CopyOfPHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeMethod(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getNamespaceOf(String elementName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getNamespaceOf(elementName, sourceModule, offset, null, monitor);
    }

    public static IType[] getNamespaceOf(String elementName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        String namespace = CopyOfPHPModelUtils.extractNamespaceName(elementName, sourceModule, offset);
        if (namespace != null && namespace.length() > 0) {
            return CopyOfPHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        }
        return PhpModelAccess.NULL_TYPES;
    }

    public static IType[] getNamespaceType(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getNamespaceType(namespace, prefix, exactName, sourceModule, monitor);
    }

    public static IType[] getNamespaceType(String namespace, String prefix, boolean exactName, ISourceModule sourceModule, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        IType[] namespaces = CopyOfPHPModelUtils.getNamespaces(sourceModule, namespace, cache, monitor);
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType ns = iTypeArray[n2];
            result.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeType(ns, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] getNamespaces(ISourceModule sourceModule, String namespaceName, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        if (cache != null) {
            Collection<IType> namespaces = cache.getNamespaces(sourceModule, namespaceName, monitor);
            if (namespaces == null) {
                return PhpModelAccess.NULL_TYPES;
            }
            return namespaces.toArray(new IType[namespaces.size()]);
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        IType[] namespaces = PhpModelAccess.getDefault().findTypes(null, namespaceName, ISearchEngine.MatchRule.EXACT, 2048, 0, scope, monitor);
        return namespaces;
    }

    public static TypeDeclaration getNodeByClass(ModuleDeclaration rootNode, IType type) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)type, DeclarationSearcher.DeclarationType.CLASS);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return (TypeDeclaration)visitor.getResult();
    }

    public static ASTNode getNodeByElement(ModuleDeclaration rootNode, IModelElement element) throws ModelException {
        switch (element.getElementType()) {
            case 7: {
                return CopyOfPHPModelUtils.getNodeByClass(rootNode, (IType)element);
            }
            case 9: {
                return CopyOfPHPModelUtils.getNodeByMethod(rootNode, (IMethod)element);
            }
            case 8: {
                return CopyOfPHPModelUtils.getNodeByField(rootNode, (IField)element);
            }
        }
        throw new IllegalArgumentException("Unsupported element type: " + element.getClass().getName());
    }

    public static ASTNode getNodeByField(ModuleDeclaration rootNode, IField field) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)field, DeclarationSearcher.DeclarationType.FIELD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return visitor.getResult();
    }

    public static MethodDeclaration getNodeByMethod(ModuleDeclaration rootNode, IMethod method) throws ModelException {
        DeclarationSearcher visitor;
        block2: {
            visitor = new DeclarationSearcher(rootNode, (IMember)method, DeclarationSearcher.DeclarationType.METHOD);
            try {
                rootNode.traverse((ASTVisitor)visitor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block2;
                Logger.logException(e);
            }
        }
        return (MethodDeclaration)visitor.getResult();
    }

    public static IType[] getSuperClasses(IType type, ITypeHierarchy hierarchy) throws ModelException {
        if (hierarchy == null) {
            hierarchy = type.newSupertypeHierarchy(null);
        }
        Collection<IType> filtered = CopyOfPHPModelUtils.filterElements(type.getSourceModule(), Arrays.asList(hierarchy.getAllSuperclasses(type)), null, null);
        return filtered.toArray(new IType[filtered.size()]);
    }

    public static IField[] getSuperTypeHierarchyField(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return CopyOfPHPModelUtils.getSuperTypeHierarchyField(type, null, prefix, exactName, monitor);
    }

    public static IField[] getSuperTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        IType[] allSuperclasses = CopyOfPHPModelUtils.getSuperClasses(type, hierarchy);
        return CopyOfPHPModelUtils.getTypesField(allSuperclasses, prefix, exactName);
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return CopyOfPHPModelUtils.getSuperTypeHierarchyMethod(type, null, prefix, exactName, monitor);
    }

    public static IMethod[] getSuperTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        IType[] allSuperclasses = CopyOfPHPModelUtils.getSuperClasses(type, hierarchy);
        return CopyOfPHPModelUtils.getTypesMethod(allSuperclasses, prefix, exactName);
    }

    public static IField[] getTypeField(IType type, String prefix, boolean exactName) throws ModelException {
        LinkedList<IField> result = new LinkedList<IField>();
        if (type.exists()) {
            IField[] fields;
            IField[] iFieldArray = fields = type.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                String elementName = field.getElementName();
                if (elementName.startsWith("$") && !prefix.startsWith("$")) {
                    elementName = elementName.substring(1);
                }
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(field);
                }
                ++n2;
            }
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IField[] getTypeHierarchyField(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IField> fields = new LinkedList<IField>();
        fields.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeField(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            fields.addAll(Arrays.asList(CopyOfPHPModelUtils.getSuperTypeHierarchyField(type, hierarchy, prefix, exactName, monitor)));
        }
        return fields.toArray(new IField[fields.size()]);
    }

    public static IField[] getTypeHierarchyField(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return CopyOfPHPModelUtils.getTypeHierarchyField(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyFieldDoc(IType type, String name, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (name == null) {
            throw new NullPointerException();
        }
        LinkedList<PHPDocBlock> docs = new LinkedList<PHPDocBlock>();
        IField[] iFieldArray = CopyOfPHPModelUtils.getTypeHierarchyField(type, name, exactName, monitor);
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            PHPDocBlock docBlock = CopyOfPHPModelUtils.getDocBlock(field);
            if (docBlock != null) {
                docs.add(docBlock);
            }
            ++n2;
        }
        return docs.toArray(new PHPDocBlock[docs.size()]);
    }

    public static IMethod[] getTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        methods.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeMethod(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0) {
            methods.addAll(Arrays.asList(CopyOfPHPModelUtils.getSuperTypeHierarchyMethod(type, hierarchy, prefix, exactName, monitor)));
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IMethod[] getFirstTypeHierarchyMethod(IType type, ITypeHierarchy hierarchy, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<IMethod> methods = new LinkedList<IMethod>();
        methods.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeMethod(type, prefix, exactName)));
        if (type.getSuperClasses() != null && type.getSuperClasses().length > 0 && methods.size() == 0) {
            IType[] allSuperclasses;
            IType[] iTypeArray = allSuperclasses = CopyOfPHPModelUtils.getSuperClasses(type, hierarchy);
            int n = allSuperclasses.length;
            int n2 = 0;
            while (n2 < n) {
                IType superClass = iTypeArray[n2];
                IMethod[] method = CopyOfPHPModelUtils.getTypeMethod(superClass, prefix, exactName);
                if (method != null && method.length > 0) {
                    methods.addAll(Arrays.asList(method));
                    break;
                }
                ++n2;
            }
        }
        return methods.toArray(new IMethod[methods.size()]);
    }

    public static IMethod[] getTypeHierarchyMethod(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        return CopyOfPHPModelUtils.getTypeHierarchyMethod(type, null, prefix, exactName, monitor);
    }

    public static PHPDocBlock[] getTypeHierarchyMethodDoc(IType type, String prefix, boolean exactName, IProgressMonitor monitor) throws CoreException {
        if (prefix == null) {
            throw new NullPointerException();
        }
        LinkedList<PHPDocBlock> docs = new LinkedList<PHPDocBlock>();
        IMethod[] iMethodArray = CopyOfPHPModelUtils.getTypeHierarchyMethod(type, prefix, exactName, monitor);
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            PHPDocBlock docBlock = CopyOfPHPModelUtils.getDocBlock(method);
            if (docBlock != null) {
                docs.add(docBlock);
            }
            ++n2;
        }
        return docs.toArray(new PHPDocBlock[docs.size()]);
    }

    public static IMethod[] getTypeMethod(IType type, String prefix, boolean exactName) throws ModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        if (type.exists()) {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                String elementName = method.getElementName();
                if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                    result.add(method);
                }
                ++n2;
            }
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getTypes(typeName, sourceModule, offset, null, monitor);
    }

    public static IType[] getTypes(String typeName, ISourceModule sourceModule, int offset, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        Collection<IType> types;
        if (typeName == null || typeName.length() == 0) {
            return PhpModelAccess.NULL_TYPES;
        }
        String namespace = CopyOfPHPModelUtils.extractNamespaceName(typeName, sourceModule, offset);
        typeName = CopyOfPHPModelUtils.extractElementName(typeName);
        if (namespace != null) {
            if (namespace.length() > 0) {
                IType[] types2 = CopyOfPHPModelUtils.getNamespaceType(namespace, typeName = CopyOfPHPModelUtils.getRealName(typeName, sourceModule, offset, typeName), true, sourceModule, cache, monitor);
                if (types2.length > 0) {
                    return types2;
                }
                return PhpModelAccess.NULL_TYPES;
            }
        } else {
            IType[] types3;
            IType currentNamespace = CopyOfPHPModelUtils.getCurrentNamespace(sourceModule, offset);
            if (currentNamespace != null && (types3 = CopyOfPHPModelUtils.getNamespaceType(namespace = currentNamespace.getElementName(), typeName, true, sourceModule, cache, monitor)).length > 0) {
                return types3;
            }
        }
        if (cache == null) {
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
            IType[] r = PhpModelAccess.getDefault().findTypes(typeName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            types = CopyOfPHPModelUtils.filterElements(sourceModule, Arrays.asList(r), null, monitor);
        } else {
            types = cache.getTypes(sourceModule, typeName, null, monitor);
            if (types == null) {
                return PhpModelAccess.NULL_TYPES;
            }
        }
        ArrayList<IType> result = new ArrayList<IType>(types.size());
        for (IType type : types) {
            if (CopyOfPHPModelUtils.getCurrentNamespace((IModelElement)type) != null) continue;
            result.add(type);
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IField[] getTypesField(IType[] types, String prefix, boolean exactName) throws ModelException {
        LinkedList<IField> result = new LinkedList<IField>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeField(type, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IField[result.size()]);
    }

    public static IMethod[] getTypesMethod(IType[] types, String prefix, boolean exactName) throws ModelException {
        LinkedList<IMethod> result = new LinkedList<IMethod>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            result.addAll(Arrays.asList(CopyOfPHPModelUtils.getTypeMethod(type, prefix, exactName)));
            ++n2;
        }
        return result.toArray(new IMethod[result.size()]);
    }

    public static IType[] getTypeType(IType type, String prefix, boolean exactName) throws ModelException {
        IType[] types;
        LinkedList<IType> result = new LinkedList<IType>();
        IType[] iTypeArray = types = type.getTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            String elementName = t.getElementName();
            if (exactName && elementName.equalsIgnoreCase(prefix) || !exactName && elementName.toLowerCase().startsWith(prefix.toLowerCase())) {
                result.add(t);
            }
            ++n2;
        }
        return result.toArray(new IType[result.size()]);
    }

    public static IMethod[] getUnimplementedMethods(IType type, IProgressMonitor monitor) throws ModelException {
        return CopyOfPHPModelUtils.getUnimplementedMethods(type, null, monitor);
    }

    public static IMethod[] getUnimplementedMethods(IType type, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        HashMap<String, IMethod> abstractMethods = new HashMap<String, IMethod>();
        HashSet<String> nonAbstractMethods = new HashSet<String>();
        CopyOfPHPModelUtils.internalGetUnimplementedMethods(type, nonAbstractMethods, abstractMethods, new HashSet<String>(), cache, monitor);
        for (String methodName : nonAbstractMethods) {
            abstractMethods.remove(methodName);
        }
        Collection<IMethod> unimplementedMethods = abstractMethods.values();
        return unimplementedMethods.toArray(new IMethod[unimplementedMethods.size()]);
    }

    private static void internalGetUnimplementedMethods(IType type, HashSet<String> nonAbstractMethods, HashMap<String, IMethod> abstractMethods, Set<String> processedTypes, IModelAccessCache cache, IProgressMonitor monitor) throws ModelException {
        int typeFlags = type.getFlags();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String methodName = method.getElementName();
            int methodFlags = method.getFlags();
            boolean isAbstract = PHPFlags.isAbstract((int)methodFlags);
            if (isAbstract || PHPFlags.isInterface((int)typeFlags)) {
                if (!abstractMethods.containsKey(methodName)) {
                    abstractMethods.put(methodName, method);
                }
            } else if (!isAbstract) {
                nonAbstractMethods.add(methodName);
            }
            ++n2;
        }
        String[] superClasses = type.getSuperClasses();
        if (superClasses != null) {
            String[] stringArray = superClasses;
            int n3 = superClasses.length;
            n = 0;
            while (n < n3) {
                String superClass = stringArray[n];
                if (processedTypes.add(superClass)) {
                    Collection<IType> types = null;
                    if (cache == null) {
                        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)type.getScriptProject());
                        IType[] superTypes = PhpModelAccess.getDefault().findTypes(superClass, ISearchEngine.MatchRule.EXACT, 0, 2048, scope, null);
                        types = CopyOfPHPModelUtils.fileNetworkFilter(type.getSourceModule(), Arrays.asList(superTypes), null, monitor);
                    } else {
                        String namespaceName = null;
                        int i = superClass.lastIndexOf(92);
                        if (i != -1) {
                            namespaceName = superClass.substring(0, i);
                            superClass = superClass.substring(i + 1);
                        }
                        types = cache.getClassesOrInterfaces(type.getSourceModule(), superClass, namespaceName, monitor);
                    }
                    if (types != null) {
                        for (IType superType : types) {
                            CopyOfPHPModelUtils.internalGetUnimplementedMethods(superType, nonAbstractMethods, abstractMethods, processedTypes, cache, monitor);
                        }
                    }
                }
                ++n;
            }
        }
    }

    public static boolean hasStaticOrConstMember(IType type) {
        IField[] members;
        ITypeHierarchy hierarchy;
        block7: {
            block6: {
                if (!PHPFlags.isNamespace(type.getFlags())) break block6;
                return false;
            }
            hierarchy = type.newSupertypeHierarchy(null);
            members = CopyOfPHPModelUtils.getTypeHierarchyField(type, hierarchy, "", false, null);
            if (!CopyOfPHPModelUtils.hasStaticOrConstMember((IModelElement[])members)) break block7;
            return true;
        }
        try {
            members = CopyOfPHPModelUtils.getTypeHierarchyMethod(type, hierarchy, "", false, null);
            if (CopyOfPHPModelUtils.hasStaticOrConstMember((IModelElement[])members)) {
                return true;
            }
        }
        catch (ModelException e) {
            PHPCorePlugin.log(e);
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
        }
        return false;
    }

    public static boolean hasStaticOrConstMember(IModelElement[] elements) throws ModelException {
        int i = 0;
        while (i < elements.length) {
            IMember member;
            int flags;
            IModelElement modelElement = elements[i];
            if (modelElement instanceof IMember && (Flags.isStatic((int)(flags = (member = (IMember)modelElement).getFlags())) || modelElement instanceof IField && Flags.isFinal((int)flags))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

